/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParserBucket;
import org.joda.time.format.InternalParser;
import org.joda.time.format.InternalPrinter;

public class DateTimeFormat {
    static final int FULL = 0;
    static final int LONG = 1;
    static final int MEDIUM = 2;
    static final int SHORT = 3;
    static final int NONE = 4;
    static final int DATE = 0;
    static final int TIME = 1;
    static final int DATETIME = 2;
    private static final int PATTERN_CACHE_SIZE = 500;
    private static final ConcurrentHashMap<String, DateTimeFormatter> cPatternCache = new ConcurrentHashMap();
    private static final AtomicReferenceArray<DateTimeFormatter> cStyleCache = new AtomicReferenceArray(25);

    public static DateTimeFormatter forPattern(String pattern) {
        return DateTimeFormat.createFormatterForPattern(pattern);
    }

    public static DateTimeFormatter forStyle(String style) {
        return DateTimeFormat.createFormatterForStyle(style);
    }

    public static String patternForStyle(String style, Locale locale) {
        DateTimeFormatter formatter = DateTimeFormat.createFormatterForStyle(style);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ((StyleFormatter)formatter.getPrinter0()).getPattern(locale);
    }

    public static DateTimeFormatter shortDate() {
        return DateTimeFormat.createFormatterForStyleIndex(3, 4);
    }

    public static DateTimeFormatter shortTime() {
        return DateTimeFormat.createFormatterForStyleIndex(4, 3);
    }

    public static DateTimeFormatter shortDateTime() {
        return DateTimeFormat.createFormatterForStyleIndex(3, 3);
    }

    public static DateTimeFormatter mediumDate() {
        return DateTimeFormat.createFormatterForStyleIndex(2, 4);
    }

    public static DateTimeFormatter mediumTime() {
        return DateTimeFormat.createFormatterForStyleIndex(4, 2);
    }

    public static DateTimeFormatter mediumDateTime() {
        return DateTimeFormat.createFormatterForStyleIndex(2, 2);
    }

    public static DateTimeFormatter longDate() {
        return DateTimeFormat.createFormatterForStyleIndex(1, 4);
    }

    public static DateTimeFormatter longTime() {
        return DateTimeFormat.createFormatterForStyleIndex(4, 1);
    }

    public static DateTimeFormatter longDateTime() {
        return DateTimeFormat.createFormatterForStyleIndex(1, 1);
    }

    public static DateTimeFormatter fullDate() {
        return DateTimeFormat.createFormatterForStyleIndex(0, 4);
    }

    public static DateTimeFormatter fullTime() {
        return DateTimeFormat.createFormatterForStyleIndex(4, 0);
    }

    public static DateTimeFormatter fullDateTime() {
        return DateTimeFormat.createFormatterForStyleIndex(0, 0);
    }

    static void appendPatternTo(DateTimeFormatterBuilder builder, String pattern) {
        DateTimeFormat.parsePatternTo(builder, pattern);
    }

    protected DateTimeFormat() {
    }

    private static void parsePatternTo(DateTimeFormatterBuilder builder, String pattern) {
        int length = pattern.length();
        int[] indexRef = new int[1];
        block30: for (int i = 0; i < length; ++i) {
            indexRef[0] = i;
            String token = DateTimeFormat.parseToken(pattern, indexRef);
            i = indexRef[0];
            int tokenLen = token.length();
            if (tokenLen == 0) break;
            char c = token.charAt(0);
            switch (c) {
                case 'G': {
                    builder.appendEraText();
                    continue block30;
                }
                case 'C': {
                    builder.appendCenturyOfEra(tokenLen, tokenLen);
                    continue block30;
                }
                case 'Y': 
                case 'x': 
                case 'y': {
                    if (tokenLen == 2) {
                        boolean lenientParse = true;
                        if (i + 1 < length) {
                            indexRef[0] = indexRef[0] + 1;
                            if (DateTimeFormat.isNumericToken(DateTimeFormat.parseToken(pattern, indexRef))) {
                                lenientParse = false;
                            }
                            indexRef[0] = indexRef[0] - 1;
                        }
                        switch (c) {
                            case 'x': {
                                builder.appendTwoDigitWeekyear(new DateTime().getWeekyear() - 30, lenientParse);
                                continue block30;
                            }
                        }
                        builder.appendTwoDigitYear(new DateTime().getYear() - 30, lenientParse);
                        continue block30;
                    }
                    int maxDigits = 9;
                    if (i + 1 < length) {
                        indexRef[0] = indexRef[0] + 1;
                        if (DateTimeFormat.isNumericToken(DateTimeFormat.parseToken(pattern, indexRef))) {
                            maxDigits = tokenLen;
                        }
                        indexRef[0] = indexRef[0] - 1;
                    }
                    switch (c) {
                        case 'x': {
                            builder.appendWeekyear(tokenLen, maxDigits);
                            break;
                        }
                        case 'y': {
                            builder.appendYear(tokenLen, maxDigits);
                            break;
                        }
                        case 'Y': {
                            builder.appendYearOfEra(tokenLen, maxDigits);
                        }
                    }
                    continue block30;
                }
                case 'M': {
                    if (tokenLen >= 3) {
                        if (tokenLen >= 4) {
                            builder.appendMonthOfYearText();
                            continue block30;
                        }
                        builder.appendMonthOfYearShortText();
                        continue block30;
                    }
                    builder.appendMonthOfYear(tokenLen);
                    continue block30;
                }
                case 'd': {
                    builder.appendDayOfMonth(tokenLen);
                    continue block30;
                }
                case 'a': {
                    builder.appendHalfdayOfDayText();
                    continue block30;
                }
                case 'h': {
                    builder.appendClockhourOfHalfday(tokenLen);
                    continue block30;
                }
                case 'H': {
                    builder.appendHourOfDay(tokenLen);
                    continue block30;
                }
                case 'k': {
                    builder.appendClockhourOfDay(tokenLen);
                    continue block30;
                }
                case 'K': {
                    builder.appendHourOfHalfday(tokenLen);
                    continue block30;
                }
                case 'm': {
                    builder.appendMinuteOfHour(tokenLen);
                    continue block30;
                }
                case 's': {
                    builder.appendSecondOfMinute(tokenLen);
                    continue block30;
                }
                case 'S': {
                    builder.appendFractionOfSecond(tokenLen, tokenLen);
                    continue block30;
                }
                case 'e': {
                    builder.appendDayOfWeek(tokenLen);
                    continue block30;
                }
                case 'E': {
                    if (tokenLen >= 4) {
                        builder.appendDayOfWeekText();
                        continue block30;
                    }
                    builder.appendDayOfWeekShortText();
                    continue block30;
                }
                case 'D': {
                    builder.appendDayOfYear(tokenLen);
                    continue block30;
                }
                case 'w': {
                    builder.appendWeekOfWeekyear(tokenLen);
                    continue block30;
                }
                case 'z': {
                    if (tokenLen >= 4) {
                        builder.appendTimeZoneName();
                        continue block30;
                    }
                    builder.appendTimeZoneShortName(null);
                    continue block30;
                }
                case 'Z': {
                    if (tokenLen == 1) {
                        builder.appendTimeZoneOffset(null, "Z", false, 2, 2);
                        continue block30;
                    }
                    if (tokenLen == 2) {
                        builder.appendTimeZoneOffset(null, "Z", true, 2, 2);
                        continue block30;
                    }
                    builder.appendTimeZoneId();
                    continue block30;
                }
                case '\'': {
                    String sub = token.substring(1);
                    if (sub.length() == 1) {
                        builder.appendLiteral(sub.charAt(0));
                        continue block30;
                    }
                    builder.appendLiteral(new String(sub));
                    continue block30;
                }
                default: {
                    throw new IllegalArgumentException("Illegal pattern component: " + token);
                }
            }
        }
    }

    private static String parseToken(String pattern, int[] indexRef) {
        int i;
        StringBuilder buf = new StringBuilder();
        int length = pattern.length();
        char c = pattern.charAt(i);
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
            char peek;
            buf.append(c);
            while (i + 1 < length && (peek = pattern.charAt(i + 1)) == c) {
                buf.append(c);
                ++i;
            }
        } else {
            buf.append('\'');
            boolean inLiteral = false;
            for (i = indexRef[0]; i < length; ++i) {
                c = pattern.charAt(i);
                if (c == '\'') {
                    if (i + 1 < length && pattern.charAt(i + 1) == '\'') {
                        ++i;
                        buf.append(c);
                        continue;
                    }
                    inLiteral = !inLiteral;
                    continue;
                }
                if (inLiteral || (c < 'A' || c > 'Z') && (c < 'a' || c > 'z')) {
                    buf.append(c);
                    continue;
                }
                break;
            }
        }
        indexRef[0] = --i;
        return buf.toString();
    }

    private static boolean isNumericToken(String token) {
        int tokenLen = token.length();
        if (tokenLen > 0) {
            char c = token.charAt(0);
            switch (c) {
                case 'C': 
                case 'D': 
                case 'F': 
                case 'H': 
                case 'K': 
                case 'S': 
                case 'W': 
                case 'Y': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'h': 
                case 'k': 
                case 'm': 
                case 's': 
                case 'w': 
                case 'x': 
                case 'y': {
                    return true;
                }
                case 'M': {
                    if (tokenLen > 2) break;
                    return true;
                }
            }
        }
        return false;
    }

    private static DateTimeFormatter createFormatterForPattern(String pattern) {
        if (pattern == null || pattern.length() == 0) {
            throw new IllegalArgumentException("Invalid pattern specification");
        }
        DateTimeFormatter formatter = cPatternCache.get(pattern);
        if (formatter == null) {
            DateTimeFormatter oldFormatter;
            DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
            DateTimeFormat.parsePatternTo(builder, pattern);
            formatter = builder.toFormatter();
            if (cPatternCache.size() < 500 && (oldFormatter = cPatternCache.putIfAbsent(pattern, formatter)) != null) {
                formatter = oldFormatter;
            }
        }
        return formatter;
    }

    private static DateTimeFormatter createFormatterForStyle(String style) {
        if (style == null || style.length() != 2) {
            throw new IllegalArgumentException("Invalid style specification: " + style);
        }
        int dateStyle = DateTimeFormat.selectStyle(style.charAt(0));
        int timeStyle = DateTimeFormat.selectStyle(style.charAt(1));
        if (dateStyle == 4 && timeStyle == 4) {
            throw new IllegalArgumentException("Style '--' is invalid");
        }
        return DateTimeFormat.createFormatterForStyleIndex(dateStyle, timeStyle);
    }

    private static DateTimeFormatter createFormatterForStyleIndex(int dateStyle, int timeStyle) {
        int index = (dateStyle << 2) + dateStyle + timeStyle;
        if (index >= cStyleCache.length()) {
            return DateTimeFormat.createDateTimeFormatter(dateStyle, timeStyle);
        }
        DateTimeFormatter f = cStyleCache.get(index);
        if (f == null && !cStyleCache.compareAndSet(index, null, f = DateTimeFormat.createDateTimeFormatter(dateStyle, timeStyle))) {
            f = cStyleCache.get(index);
        }
        return f;
    }

    private static DateTimeFormatter createDateTimeFormatter(int dateStyle, int timeStyle) {
        int type = 2;
        if (dateStyle == 4) {
            type = 1;
        } else if (timeStyle == 4) {
            type = 0;
        }
        StyleFormatter llf = new StyleFormatter(dateStyle, timeStyle, type);
        return new DateTimeFormatter(llf, llf);
    }

    private static int selectStyle(char ch) {
        switch (ch) {
            case 'S': {
                return 3;
            }
            case 'M': {
                return 2;
            }
            case 'L': {
                return 1;
            }
            case 'F': {
                return 0;
            }
            case '-': {
                return 4;
            }
        }
        throw new IllegalArgumentException("Invalid style character: " + ch);
    }

    static class StyleFormatterCacheKey {
        private final int combinedTypeAndStyle;
        private final Locale locale;

        public StyleFormatterCacheKey(int iType, int iDateStyle, int iTimeStyle, Locale locale) {
            this.locale = locale;
            this.combinedTypeAndStyle = iType + (iDateStyle << 4) + (iTimeStyle << 8);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.combinedTypeAndStyle;
            result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof StyleFormatterCacheKey)) {
                return false;
            }
            StyleFormatterCacheKey other = (StyleFormatterCacheKey)obj;
            if (this.combinedTypeAndStyle != other.combinedTypeAndStyle) {
                return false;
            }
            return !(this.locale == null ? other.locale != null : !this.locale.equals(other.locale));
        }
    }

    static class StyleFormatter
    implements InternalPrinter,
    InternalParser {
        private static final ConcurrentHashMap<StyleFormatterCacheKey, DateTimeFormatter> cCache = new ConcurrentHashMap();
        private final int iDateStyle;
        private final int iTimeStyle;
        private final int iType;

        StyleFormatter(int dateStyle, int timeStyle, int type) {
            this.iDateStyle = dateStyle;
            this.iTimeStyle = timeStyle;
            this.iType = type;
        }

        @Override
        public int estimatePrintedLength() {
            return 40;
        }

        @Override
        public void printTo(Appendable appenadble, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) throws IOException {
            InternalPrinter p = this.getFormatter(locale).getPrinter0();
            p.printTo(appenadble, instant, chrono, displayOffset, displayZone, locale);
        }

        @Override
        public void printTo(Appendable appendable, ReadablePartial partial, Locale locale) throws IOException {
            InternalPrinter p = this.getFormatter(locale).getPrinter0();
            p.printTo(appendable, partial, locale);
        }

        @Override
        public int estimateParsedLength() {
            return 40;
        }

        @Override
        public int parseInto(DateTimeParserBucket bucket, CharSequence text, int position) {
            InternalParser p = this.getFormatter(bucket.getLocale()).getParser0();
            return p.parseInto(bucket, text, position);
        }

        private DateTimeFormatter getFormatter(Locale locale) {
            DateTimeFormatter oldFormatter;
            locale = locale == null ? Locale.getDefault() : locale;
            StyleFormatterCacheKey key = new StyleFormatterCacheKey(this.iType, this.iDateStyle, this.iTimeStyle, locale);
            DateTimeFormatter f = cCache.get(key);
            if (f == null && (oldFormatter = cCache.putIfAbsent(key, f = DateTimeFormat.forPattern(this.getPattern(locale)))) != null) {
                f = oldFormatter;
            }
            return f;
        }

        String getPattern(Locale locale) {
            DateFormat f = null;
            switch (this.iType) {
                case 0: {
                    f = DateFormat.getDateInstance(this.iDateStyle, locale);
                    break;
                }
                case 1: {
                    f = DateFormat.getTimeInstance(this.iTimeStyle, locale);
                    break;
                }
                case 2: {
                    f = DateFormat.getDateTimeInstance(this.iDateStyle, this.iTimeStyle, locale);
                }
            }
            if (!(f instanceof SimpleDateFormat)) {
                throw new IllegalArgumentException("No datetime pattern for locale: " + locale);
            }
            return ((SimpleDateFormat)f).toPattern();
        }
    }
}

