/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.HashMap;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableDateTime;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.field.DecoratedDateTimeField;
import org.joda.time.field.DecoratedDurationField;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class LimitChronology
extends AssembledChronology {
    private static final long serialVersionUID = 7670866536893052522L;
    final DateTime iLowerLimit;
    final DateTime iUpperLimit;
    private transient LimitChronology iWithUTC;

    public static LimitChronology getInstance(Chronology base, ReadableDateTime lowerLimit, ReadableDateTime upperLimit) {
        if (base == null) {
            throw new IllegalArgumentException("Must supply a chronology");
        }
        lowerLimit = lowerLimit == null ? null : lowerLimit.toDateTime();
        ReadableDateTime readableDateTime = upperLimit = upperLimit == null ? null : upperLimit.toDateTime();
        if (lowerLimit != null && upperLimit != null && !lowerLimit.isBefore(upperLimit)) {
            throw new IllegalArgumentException("The lower limit must be come before than the upper limit");
        }
        return new LimitChronology(base, (DateTime)lowerLimit, (DateTime)upperLimit);
    }

    private LimitChronology(Chronology base, DateTime lowerLimit, DateTime upperLimit) {
        super(base, null);
        this.iLowerLimit = lowerLimit;
        this.iUpperLimit = upperLimit;
    }

    public DateTime getLowerLimit() {
        return this.iLowerLimit;
    }

    public DateTime getUpperLimit() {
        return this.iUpperLimit;
    }

    @Override
    public Chronology withUTC() {
        return this.withZone(DateTimeZone.UTC);
    }

    @Override
    public Chronology withZone(DateTimeZone zone) {
        DateTime upperLimit;
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        if (zone == this.getZone()) {
            return this;
        }
        if (zone == DateTimeZone.UTC && this.iWithUTC != null) {
            return this.iWithUTC;
        }
        DateTime lowerLimit = this.iLowerLimit;
        if (lowerLimit != null) {
            MutableDateTime mdt = lowerLimit.toMutableDateTime();
            mdt.setZoneRetainFields(zone);
            lowerLimit = mdt.toDateTime();
        }
        if ((upperLimit = this.iUpperLimit) != null) {
            MutableDateTime mdt = upperLimit.toMutableDateTime();
            mdt.setZoneRetainFields(zone);
            upperLimit = mdt.toDateTime();
        }
        LimitChronology chrono = LimitChronology.getInstance(this.getBase().withZone(zone), lowerLimit, upperLimit);
        if (zone == DateTimeZone.UTC) {
            this.iWithUTC = chrono;
        }
        return chrono;
    }

    @Override
    public long getDateTimeMillis(int year, int monthOfYear, int dayOfMonth, int millisOfDay) throws IllegalArgumentException {
        long instant = this.getBase().getDateTimeMillis(year, monthOfYear, dayOfMonth, millisOfDay);
        this.checkLimits(instant, "resulting");
        return instant;
    }

    @Override
    public long getDateTimeMillis(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) throws IllegalArgumentException {
        long instant = this.getBase().getDateTimeMillis(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond);
        this.checkLimits(instant, "resulting");
        return instant;
    }

    @Override
    public long getDateTimeMillis(long instant, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) throws IllegalArgumentException {
        this.checkLimits(instant, null);
        instant = this.getBase().getDateTimeMillis(instant, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond);
        this.checkLimits(instant, "resulting");
        return instant;
    }

    @Override
    protected void assemble(AssembledChronology.Fields fields) {
        HashMap<Object, Object> converted = new HashMap<Object, Object>();
        fields.eras = this.convertField(fields.eras, converted);
        fields.centuries = this.convertField(fields.centuries, converted);
        fields.years = this.convertField(fields.years, converted);
        fields.months = this.convertField(fields.months, converted);
        fields.weekyears = this.convertField(fields.weekyears, converted);
        fields.weeks = this.convertField(fields.weeks, converted);
        fields.days = this.convertField(fields.days, converted);
        fields.halfdays = this.convertField(fields.halfdays, converted);
        fields.hours = this.convertField(fields.hours, converted);
        fields.minutes = this.convertField(fields.minutes, converted);
        fields.seconds = this.convertField(fields.seconds, converted);
        fields.millis = this.convertField(fields.millis, converted);
        fields.year = this.convertField(fields.year, converted);
        fields.yearOfEra = this.convertField(fields.yearOfEra, converted);
        fields.yearOfCentury = this.convertField(fields.yearOfCentury, converted);
        fields.centuryOfEra = this.convertField(fields.centuryOfEra, converted);
        fields.era = this.convertField(fields.era, converted);
        fields.dayOfWeek = this.convertField(fields.dayOfWeek, converted);
        fields.dayOfMonth = this.convertField(fields.dayOfMonth, converted);
        fields.dayOfYear = this.convertField(fields.dayOfYear, converted);
        fields.monthOfYear = this.convertField(fields.monthOfYear, converted);
        fields.weekOfWeekyear = this.convertField(fields.weekOfWeekyear, converted);
        fields.weekyear = this.convertField(fields.weekyear, converted);
        fields.weekyearOfCentury = this.convertField(fields.weekyearOfCentury, converted);
        fields.millisOfSecond = this.convertField(fields.millisOfSecond, converted);
        fields.millisOfDay = this.convertField(fields.millisOfDay, converted);
        fields.secondOfMinute = this.convertField(fields.secondOfMinute, converted);
        fields.secondOfDay = this.convertField(fields.secondOfDay, converted);
        fields.minuteOfHour = this.convertField(fields.minuteOfHour, converted);
        fields.minuteOfDay = this.convertField(fields.minuteOfDay, converted);
        fields.hourOfDay = this.convertField(fields.hourOfDay, converted);
        fields.hourOfHalfday = this.convertField(fields.hourOfHalfday, converted);
        fields.clockhourOfDay = this.convertField(fields.clockhourOfDay, converted);
        fields.clockhourOfHalfday = this.convertField(fields.clockhourOfHalfday, converted);
        fields.halfdayOfDay = this.convertField(fields.halfdayOfDay, converted);
    }

    private DurationField convertField(DurationField field, HashMap<Object, Object> converted) {
        if (field == null || !field.isSupported()) {
            return field;
        }
        if (converted.containsKey(field)) {
            return (DurationField)converted.get(field);
        }
        LimitDurationField limitField = new LimitDurationField(field);
        converted.put(field, limitField);
        return limitField;
    }

    private DateTimeField convertField(DateTimeField field, HashMap<Object, Object> converted) {
        if (field == null || !field.isSupported()) {
            return field;
        }
        if (converted.containsKey(field)) {
            return (DateTimeField)converted.get(field);
        }
        LimitDateTimeField limitField = new LimitDateTimeField(field, this.convertField(field.getDurationField(), converted), this.convertField(field.getRangeDurationField(), converted), this.convertField(field.getLeapDurationField(), converted));
        converted.put(field, limitField);
        return limitField;
    }

    void checkLimits(long instant, String desc) {
        DateTime limit = this.iLowerLimit;
        if (limit != null && instant < limit.getMillis()) {
            throw new LimitException(desc, true);
        }
        limit = this.iUpperLimit;
        if (limit != null && instant >= limit.getMillis()) {
            throw new LimitException(desc, false);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LimitChronology)) {
            return false;
        }
        LimitChronology chrono = (LimitChronology)obj;
        return this.getBase().equals(chrono.getBase()) && FieldUtils.equals(this.getLowerLimit(), chrono.getLowerLimit()) && FieldUtils.equals(this.getUpperLimit(), chrono.getUpperLimit());
    }

    public int hashCode() {
        int hash = 317351877;
        hash += this.getLowerLimit() != null ? this.getLowerLimit().hashCode() : 0;
        hash += this.getUpperLimit() != null ? this.getUpperLimit().hashCode() : 0;
        return hash += this.getBase().hashCode() * 7;
    }

    @Override
    public String toString() {
        return "LimitChronology[" + this.getBase().toString() + ", " + (this.getLowerLimit() == null ? "NoLimit" : this.getLowerLimit().toString()) + ", " + (this.getUpperLimit() == null ? "NoLimit" : this.getUpperLimit().toString()) + ']';
    }

    private class LimitDateTimeField
    extends DecoratedDateTimeField {
        private static final long serialVersionUID = -2435306746995699312L;
        private final DurationField iDurationField;
        private final DurationField iRangeDurationField;
        private final DurationField iLeapDurationField;

        LimitDateTimeField(DateTimeField field, DurationField durationField, DurationField rangeDurationField, DurationField leapDurationField) {
            super(field, field.getType());
            this.iDurationField = durationField;
            this.iRangeDurationField = rangeDurationField;
            this.iLeapDurationField = leapDurationField;
        }

        @Override
        public int get(long instant) {
            LimitChronology.this.checkLimits(instant, null);
            return this.getWrappedField().get(instant);
        }

        @Override
        public String getAsText(long instant, Locale locale) {
            LimitChronology.this.checkLimits(instant, null);
            return this.getWrappedField().getAsText(instant, locale);
        }

        @Override
        public String getAsShortText(long instant, Locale locale) {
            LimitChronology.this.checkLimits(instant, null);
            return this.getWrappedField().getAsShortText(instant, locale);
        }

        @Override
        public long add(long instant, int amount) {
            LimitChronology.this.checkLimits(instant, null);
            long result = this.getWrappedField().add(instant, amount);
            LimitChronology.this.checkLimits(result, "resulting");
            return result;
        }

        @Override
        public long add(long instant, long amount) {
            LimitChronology.this.checkLimits(instant, null);
            long result = this.getWrappedField().add(instant, amount);
            LimitChronology.this.checkLimits(result, "resulting");
            return result;
        }

        @Override
        public long addWrapField(long instant, int amount) {
            LimitChronology.this.checkLimits(instant, null);
            long result = this.getWrappedField().addWrapField(instant, amount);
            LimitChronology.this.checkLimits(result, "resulting");
            return result;
        }

        @Override
        public int getDifference(long minuendInstant, long subtrahendInstant) {
            LimitChronology.this.checkLimits(minuendInstant, "minuend");
            LimitChronology.this.checkLimits(subtrahendInstant, "subtrahend");
            return this.getWrappedField().getDifference(minuendInstant, subtrahendInstant);
        }

        @Override
        public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
            LimitChronology.this.checkLimits(minuendInstant, "minuend");
            LimitChronology.this.checkLimits(subtrahendInstant, "subtrahend");
            return this.getWrappedField().getDifferenceAsLong(minuendInstant, subtrahendInstant);
        }

        @Override
        public long set(long instant, int value) {
            LimitChronology.this.checkLimits(instant, null);
            long result = this.getWrappedField().set(instant, value);
            LimitChronology.this.checkLimits(result, "resulting");
            return result;
        }

        @Override
        public long set(long instant, String text, Locale locale) {
            LimitChronology.this.checkLimits(instant, null);
            long result = this.getWrappedField().set(instant, text, locale);
            LimitChronology.this.checkLimits(result, "resulting");
            return result;
        }

        @Override
        public final DurationField getDurationField() {
            return this.iDurationField;
        }

        @Override
        public final DurationField getRangeDurationField() {
            return this.iRangeDurationField;
        }

        @Override
        public boolean isLeap(long instant) {
            LimitChronology.this.checkLimits(instant, null);
            return this.getWrappedField().isLeap(instant);
        }

        @Override
        public int getLeapAmount(long instant) {
            LimitChronology.this.checkLimits(instant, null);
            return this.getWrappedField().getLeapAmount(instant);
        }

        @Override
        public final DurationField getLeapDurationField() {
            return this.iLeapDurationField;
        }

        @Override
        public long roundFloor(long instant) {
            LimitChronology.this.checkLimits(instant, null);
            long result = this.getWrappedField().roundFloor(instant);
            LimitChronology.this.checkLimits(result, "resulting");
            return result;
        }

        @Override
        public long roundCeiling(long instant) {
            LimitChronology.this.checkLimits(instant, null);
            long result = this.getWrappedField().roundCeiling(instant);
            LimitChronology.this.checkLimits(result, "resulting");
            return result;
        }

        @Override
        public long roundHalfFloor(long instant) {
            LimitChronology.this.checkLimits(instant, null);
            long result = this.getWrappedField().roundHalfFloor(instant);
            LimitChronology.this.checkLimits(result, "resulting");
            return result;
        }

        @Override
        public long roundHalfCeiling(long instant) {
            LimitChronology.this.checkLimits(instant, null);
            long result = this.getWrappedField().roundHalfCeiling(instant);
            LimitChronology.this.checkLimits(result, "resulting");
            return result;
        }

        @Override
        public long roundHalfEven(long instant) {
            LimitChronology.this.checkLimits(instant, null);
            long result = this.getWrappedField().roundHalfEven(instant);
            LimitChronology.this.checkLimits(result, "resulting");
            return result;
        }

        @Override
        public long remainder(long instant) {
            LimitChronology.this.checkLimits(instant, null);
            long result = this.getWrappedField().remainder(instant);
            LimitChronology.this.checkLimits(result, "resulting");
            return result;
        }

        @Override
        public int getMinimumValue(long instant) {
            LimitChronology.this.checkLimits(instant, null);
            return this.getWrappedField().getMinimumValue(instant);
        }

        @Override
        public int getMaximumValue(long instant) {
            LimitChronology.this.checkLimits(instant, null);
            return this.getWrappedField().getMaximumValue(instant);
        }

        @Override
        public int getMaximumTextLength(Locale locale) {
            return this.getWrappedField().getMaximumTextLength(locale);
        }

        @Override
        public int getMaximumShortTextLength(Locale locale) {
            return this.getWrappedField().getMaximumShortTextLength(locale);
        }
    }

    private class LimitDurationField
    extends DecoratedDurationField {
        private static final long serialVersionUID = 8049297699408782284L;

        LimitDurationField(DurationField field) {
            super(field, field.getType());
        }

        @Override
        public int getValue(long duration, long instant) {
            LimitChronology.this.checkLimits(instant, null);
            return this.getWrappedField().getValue(duration, instant);
        }

        @Override
        public long getValueAsLong(long duration, long instant) {
            LimitChronology.this.checkLimits(instant, null);
            return this.getWrappedField().getValueAsLong(duration, instant);
        }

        @Override
        public long getMillis(int value, long instant) {
            LimitChronology.this.checkLimits(instant, null);
            return this.getWrappedField().getMillis(value, instant);
        }

        @Override
        public long getMillis(long value, long instant) {
            LimitChronology.this.checkLimits(instant, null);
            return this.getWrappedField().getMillis(value, instant);
        }

        @Override
        public long add(long instant, int amount) {
            LimitChronology.this.checkLimits(instant, null);
            long result = this.getWrappedField().add(instant, amount);
            LimitChronology.this.checkLimits(result, "resulting");
            return result;
        }

        @Override
        public long add(long instant, long amount) {
            LimitChronology.this.checkLimits(instant, null);
            long result = this.getWrappedField().add(instant, amount);
            LimitChronology.this.checkLimits(result, "resulting");
            return result;
        }

        @Override
        public int getDifference(long minuendInstant, long subtrahendInstant) {
            LimitChronology.this.checkLimits(minuendInstant, "minuend");
            LimitChronology.this.checkLimits(subtrahendInstant, "subtrahend");
            return this.getWrappedField().getDifference(minuendInstant, subtrahendInstant);
        }

        @Override
        public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
            LimitChronology.this.checkLimits(minuendInstant, "minuend");
            LimitChronology.this.checkLimits(subtrahendInstant, "subtrahend");
            return this.getWrappedField().getDifferenceAsLong(minuendInstant, subtrahendInstant);
        }
    }

    private class LimitException
    extends IllegalArgumentException {
        private static final long serialVersionUID = -5924689995607498581L;
        private final boolean iIsLow;

        LimitException(String desc, boolean isLow) {
            super(desc);
            this.iIsLow = isLow;
        }

        @Override
        public String getMessage() {
            StringBuffer buf = new StringBuffer(85);
            buf.append("The");
            String desc = super.getMessage();
            if (desc != null) {
                buf.append(' ');
                buf.append(desc);
            }
            buf.append(" instant is ");
            DateTimeFormatter p = ISODateTimeFormat.dateTime();
            p = p.withChronology(LimitChronology.this.getBase());
            if (this.iIsLow) {
                buf.append("below the supported minimum of ");
                p.printTo(buf, LimitChronology.this.getLowerLimit().getMillis());
            } else {
                buf.append("above the supported maximum of ");
                p.printTo(buf, LimitChronology.this.getUpperLimit().getMillis());
            }
            buf.append(" (");
            buf.append(LimitChronology.this.getBase());
            buf.append(')');
            return buf.toString();
        }

        @Override
        public String toString() {
            return "IllegalArgumentException: " + this.getMessage();
        }
    }
}

