/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.joda.time.DurationFieldType;
import org.joda.time.PeriodType;
import org.joda.time.ReadWritablePeriod;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.FormatUtils;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodParser;
import org.joda.time.format.PeriodPrinter;

public class PeriodFormatterBuilder {
    private static final int PRINT_ZERO_RARELY_FIRST = 1;
    private static final int PRINT_ZERO_RARELY_LAST = 2;
    private static final int PRINT_ZERO_IF_SUPPORTED = 3;
    private static final int PRINT_ZERO_ALWAYS = 4;
    private static final int PRINT_ZERO_NEVER = 5;
    private static final int YEARS = 0;
    private static final int MONTHS = 1;
    private static final int WEEKS = 2;
    private static final int DAYS = 3;
    private static final int HOURS = 4;
    private static final int MINUTES = 5;
    private static final int SECONDS = 6;
    private static final int MILLIS = 7;
    private static final int SECONDS_MILLIS = 8;
    private static final int SECONDS_OPTIONAL_MILLIS = 9;
    private static final int MAX_FIELD = 9;
    private static final ConcurrentMap<String, Pattern> PATTERNS = new ConcurrentHashMap<String, Pattern>();
    private int iMinPrintedDigits;
    private int iPrintZeroSetting;
    private int iMaxParsedDigits;
    private boolean iRejectSignedValues;
    private PeriodFieldAffix iPrefix;
    private List<Object> iElementPairs;
    private boolean iNotPrinter;
    private boolean iNotParser;
    private FieldFormatter[] iFieldFormatters;

    public PeriodFormatterBuilder() {
        this.clear();
    }

    public PeriodFormatter toFormatter() {
        PeriodFormatter formatter = PeriodFormatterBuilder.toFormatter(this.iElementPairs, this.iNotPrinter, this.iNotParser);
        for (FieldFormatter fieldFormatter : this.iFieldFormatters) {
            if (fieldFormatter == null) continue;
            fieldFormatter.finish(this.iFieldFormatters);
        }
        this.iFieldFormatters = (FieldFormatter[])this.iFieldFormatters.clone();
        return formatter;
    }

    public PeriodPrinter toPrinter() {
        if (this.iNotPrinter) {
            return null;
        }
        return this.toFormatter().getPrinter();
    }

    public PeriodParser toParser() {
        if (this.iNotParser) {
            return null;
        }
        return this.toFormatter().getParser();
    }

    public void clear() {
        this.iMinPrintedDigits = 1;
        this.iPrintZeroSetting = 2;
        this.iMaxParsedDigits = 10;
        this.iRejectSignedValues = false;
        this.iPrefix = null;
        if (this.iElementPairs == null) {
            this.iElementPairs = new ArrayList<Object>();
        } else {
            this.iElementPairs.clear();
        }
        this.iNotPrinter = false;
        this.iNotParser = false;
        this.iFieldFormatters = new FieldFormatter[10];
    }

    public PeriodFormatterBuilder append(PeriodFormatter formatter) {
        if (formatter == null) {
            throw new IllegalArgumentException("No formatter supplied");
        }
        this.clearPrefix();
        this.append0(formatter.getPrinter(), formatter.getParser());
        return this;
    }

    public PeriodFormatterBuilder append(PeriodPrinter printer, PeriodParser parser) {
        if (printer == null && parser == null) {
            throw new IllegalArgumentException("No printer or parser supplied");
        }
        this.clearPrefix();
        this.append0(printer, parser);
        return this;
    }

    public PeriodFormatterBuilder appendLiteral(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Literal must not be null");
        }
        this.clearPrefix();
        Literal literal = new Literal(text);
        this.append0(literal, literal);
        return this;
    }

    public PeriodFormatterBuilder minimumPrintedDigits(int minDigits) {
        this.iMinPrintedDigits = minDigits;
        return this;
    }

    public PeriodFormatterBuilder maximumParsedDigits(int maxDigits) {
        this.iMaxParsedDigits = maxDigits;
        return this;
    }

    public PeriodFormatterBuilder rejectSignedValues(boolean v) {
        this.iRejectSignedValues = v;
        return this;
    }

    public PeriodFormatterBuilder printZeroRarelyLast() {
        this.iPrintZeroSetting = 2;
        return this;
    }

    public PeriodFormatterBuilder printZeroRarelyFirst() {
        this.iPrintZeroSetting = 1;
        return this;
    }

    public PeriodFormatterBuilder printZeroIfSupported() {
        this.iPrintZeroSetting = 3;
        return this;
    }

    public PeriodFormatterBuilder printZeroAlways() {
        this.iPrintZeroSetting = 4;
        return this;
    }

    public PeriodFormatterBuilder printZeroNever() {
        this.iPrintZeroSetting = 5;
        return this;
    }

    public PeriodFormatterBuilder appendPrefix(String text) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        return this.appendPrefix(new SimpleAffix(text));
    }

    public PeriodFormatterBuilder appendPrefix(String singularText, String pluralText) {
        if (singularText == null || pluralText == null) {
            throw new IllegalArgumentException();
        }
        return this.appendPrefix(new PluralAffix(singularText, pluralText));
    }

    public PeriodFormatterBuilder appendPrefix(String[] regularExpressions, String[] prefixes) {
        if (regularExpressions == null || prefixes == null || regularExpressions.length < 1 || regularExpressions.length != prefixes.length) {
            throw new IllegalArgumentException();
        }
        return this.appendPrefix(new RegExAffix(regularExpressions, prefixes));
    }

    private PeriodFormatterBuilder appendPrefix(PeriodFieldAffix prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if (this.iPrefix != null) {
            prefix = new CompositeAffix(this.iPrefix, prefix);
        }
        this.iPrefix = prefix;
        return this;
    }

    public PeriodFormatterBuilder appendYears() {
        this.appendField(0);
        return this;
    }

    public PeriodFormatterBuilder appendMonths() {
        this.appendField(1);
        return this;
    }

    public PeriodFormatterBuilder appendWeeks() {
        this.appendField(2);
        return this;
    }

    public PeriodFormatterBuilder appendDays() {
        this.appendField(3);
        return this;
    }

    public PeriodFormatterBuilder appendHours() {
        this.appendField(4);
        return this;
    }

    public PeriodFormatterBuilder appendMinutes() {
        this.appendField(5);
        return this;
    }

    public PeriodFormatterBuilder appendSeconds() {
        this.appendField(6);
        return this;
    }

    public PeriodFormatterBuilder appendSecondsWithMillis() {
        this.appendField(8);
        return this;
    }

    public PeriodFormatterBuilder appendSecondsWithOptionalMillis() {
        this.appendField(9);
        return this;
    }

    public PeriodFormatterBuilder appendMillis() {
        this.appendField(7);
        return this;
    }

    public PeriodFormatterBuilder appendMillis3Digit() {
        this.appendField(7, 3);
        return this;
    }

    private void appendField(int type) {
        this.appendField(type, this.iMinPrintedDigits);
    }

    private void appendField(int type, int minPrinted) {
        FieldFormatter field = new FieldFormatter(minPrinted, this.iPrintZeroSetting, this.iMaxParsedDigits, this.iRejectSignedValues, type, this.iFieldFormatters, this.iPrefix, null);
        this.append0(field, field);
        this.iFieldFormatters[type] = field;
        this.iPrefix = null;
    }

    public PeriodFormatterBuilder appendSuffix(String text) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        return this.appendSuffix(new SimpleAffix(text));
    }

    public PeriodFormatterBuilder appendSuffix(String singularText, String pluralText) {
        if (singularText == null || pluralText == null) {
            throw new IllegalArgumentException();
        }
        return this.appendSuffix(new PluralAffix(singularText, pluralText));
    }

    public PeriodFormatterBuilder appendSuffix(String[] regularExpressions, String[] suffixes) {
        if (regularExpressions == null || suffixes == null || regularExpressions.length < 1 || regularExpressions.length != suffixes.length) {
            throw new IllegalArgumentException();
        }
        return this.appendSuffix(new RegExAffix(regularExpressions, suffixes));
    }

    private PeriodFormatterBuilder appendSuffix(PeriodFieldAffix suffix) {
        Object originalParser;
        Object originalPrinter;
        if (this.iElementPairs.size() > 0) {
            originalPrinter = this.iElementPairs.get(this.iElementPairs.size() - 2);
            originalParser = this.iElementPairs.get(this.iElementPairs.size() - 1);
        } else {
            originalPrinter = null;
            originalParser = null;
        }
        if (originalPrinter == null || originalParser == null || originalPrinter != originalParser || !(originalPrinter instanceof FieldFormatter)) {
            throw new IllegalStateException("No field to apply suffix to");
        }
        this.clearPrefix();
        FieldFormatter newField = new FieldFormatter((FieldFormatter)originalPrinter, suffix);
        this.iElementPairs.set(this.iElementPairs.size() - 2, newField);
        this.iElementPairs.set(this.iElementPairs.size() - 1, newField);
        this.iFieldFormatters[newField.getFieldType()] = newField;
        return this;
    }

    public PeriodFormatterBuilder appendSeparator(String text) {
        return this.appendSeparator(text, text, null, true, true);
    }

    public PeriodFormatterBuilder appendSeparatorIfFieldsAfter(String text) {
        return this.appendSeparator(text, text, null, false, true);
    }

    public PeriodFormatterBuilder appendSeparatorIfFieldsBefore(String text) {
        return this.appendSeparator(text, text, null, true, false);
    }

    public PeriodFormatterBuilder appendSeparator(String text, String finalText) {
        return this.appendSeparator(text, finalText, null, true, true);
    }

    public PeriodFormatterBuilder appendSeparator(String text, String finalText, String[] variants) {
        return this.appendSeparator(text, finalText, variants, true, true);
    }

    private PeriodFormatterBuilder appendSeparator(String text, String finalText, String[] variants, boolean useBefore, boolean useAfter) {
        if (text == null || finalText == null) {
            throw new IllegalArgumentException();
        }
        this.clearPrefix();
        List<Object> pairs = this.iElementPairs;
        if (pairs.size() == 0) {
            if (useAfter && !useBefore) {
                Separator separator = new Separator(text, finalText, variants, Literal.EMPTY, Literal.EMPTY, useBefore, useAfter);
                this.append0(separator, separator);
            }
            return this;
        }
        Separator lastSeparator = null;
        int i = pairs.size();
        while (--i >= 0) {
            if (pairs.get(i) instanceof Separator) {
                lastSeparator = (Separator)pairs.get(i);
                pairs = pairs.subList(i + 1, pairs.size());
                break;
            }
            --i;
        }
        if (lastSeparator != null && pairs.size() == 0) {
            throw new IllegalStateException("Cannot have two adjacent separators");
        }
        Object[] comp = PeriodFormatterBuilder.createComposite(pairs);
        pairs.clear();
        Separator separator = new Separator(text, finalText, variants, (PeriodPrinter)comp[0], (PeriodParser)comp[1], useBefore, useAfter);
        pairs.add(separator);
        pairs.add(separator);
        return this;
    }

    private void clearPrefix() throws IllegalStateException {
        if (this.iPrefix != null) {
            throw new IllegalStateException("Prefix not followed by field");
        }
        this.iPrefix = null;
    }

    private PeriodFormatterBuilder append0(PeriodPrinter printer, PeriodParser parser) {
        this.iElementPairs.add(printer);
        this.iElementPairs.add(parser);
        this.iNotPrinter |= printer == null;
        this.iNotParser |= parser == null;
        return this;
    }

    private static PeriodFormatter toFormatter(List<Object> elementPairs, boolean notPrinter, boolean notParser) {
        Separator sep;
        if (notPrinter && notParser) {
            throw new IllegalStateException("Builder has created neither a printer nor a parser");
        }
        int size = elementPairs.size();
        if (size >= 2 && elementPairs.get(0) instanceof Separator && (sep = (Separator)elementPairs.get(0)).iAfterParser == null && sep.iAfterPrinter == null) {
            PeriodFormatter f = PeriodFormatterBuilder.toFormatter(elementPairs.subList(2, size), notPrinter, notParser);
            sep = sep.finish(f.getPrinter(), f.getParser());
            return new PeriodFormatter(sep, sep);
        }
        Object[] comp = PeriodFormatterBuilder.createComposite(elementPairs);
        if (notPrinter) {
            return new PeriodFormatter(null, (PeriodParser)comp[1]);
        }
        if (notParser) {
            return new PeriodFormatter((PeriodPrinter)comp[0], null);
        }
        return new PeriodFormatter((PeriodPrinter)comp[0], (PeriodParser)comp[1]);
    }

    private static Object[] createComposite(List<Object> elementPairs) {
        switch (elementPairs.size()) {
            case 0: {
                return new Object[]{Literal.EMPTY, Literal.EMPTY};
            }
            case 1: {
                return new Object[]{elementPairs.get(0), elementPairs.get(1)};
            }
        }
        Composite comp = new Composite(elementPairs);
        return new Object[]{comp, comp};
    }

    static class Composite
    implements PeriodPrinter,
    PeriodParser {
        private final PeriodPrinter[] iPrinters;
        private final PeriodParser[] iParsers;

        Composite(List<Object> elementPairs) {
            ArrayList<Object> printerList = new ArrayList<Object>();
            ArrayList<Object> parserList = new ArrayList<Object>();
            this.decompose(elementPairs, printerList, parserList);
            this.iPrinters = printerList.size() <= 0 ? null : printerList.toArray(new PeriodPrinter[printerList.size()]);
            this.iParsers = parserList.size() <= 0 ? null : parserList.toArray(new PeriodParser[parserList.size()]);
        }

        @Override
        public int countFieldsToPrint(ReadablePeriod period, int stopAt, Locale locale) {
            int sum;
            PeriodPrinter[] printers = this.iPrinters;
            int i = printers.length;
            for (sum = 0; sum < stopAt && --i >= 0; sum += printers[i].countFieldsToPrint(period, Integer.MAX_VALUE, locale)) {
            }
            return sum;
        }

        @Override
        public int calculatePrintedLength(ReadablePeriod period, Locale locale) {
            int sum = 0;
            PeriodPrinter[] printers = this.iPrinters;
            int i = printers.length;
            while (--i >= 0) {
                sum += printers[i].calculatePrintedLength(period, locale);
            }
            return sum;
        }

        @Override
        public void printTo(StringBuffer buf, ReadablePeriod period, Locale locale) {
            PeriodPrinter[] printers = this.iPrinters;
            int len = printers.length;
            for (int i = 0; i < len; ++i) {
                printers[i].printTo(buf, period, locale);
            }
        }

        @Override
        public void printTo(Writer out, ReadablePeriod period, Locale locale) throws IOException {
            PeriodPrinter[] printers = this.iPrinters;
            int len = printers.length;
            for (int i = 0; i < len; ++i) {
                printers[i].printTo(out, period, locale);
            }
        }

        @Override
        public int parseInto(ReadWritablePeriod period, String periodStr, int position, Locale locale) {
            PeriodParser[] parsers = this.iParsers;
            if (parsers == null) {
                throw new UnsupportedOperationException();
            }
            int len = parsers.length;
            for (int i = 0; i < len && position >= 0; ++i) {
                position = parsers[i].parseInto(period, periodStr, position, locale);
            }
            return position;
        }

        private void decompose(List<Object> elementPairs, List<Object> printerList, List<Object> parserList) {
            int size = elementPairs.size();
            for (int i = 0; i < size; i += 2) {
                Object element = elementPairs.get(i);
                if (element instanceof PeriodPrinter) {
                    if (element instanceof Composite) {
                        this.addArrayToList(printerList, ((Composite)element).iPrinters);
                    } else {
                        printerList.add(element);
                    }
                }
                if (!((element = elementPairs.get(i + 1)) instanceof PeriodParser)) continue;
                if (element instanceof Composite) {
                    this.addArrayToList(parserList, ((Composite)element).iParsers);
                    continue;
                }
                parserList.add(element);
            }
        }

        private void addArrayToList(List<Object> list, Object[] array) {
            if (array != null) {
                for (int i = 0; i < array.length; ++i) {
                    list.add(array[i]);
                }
            }
        }
    }

    static class Separator
    implements PeriodPrinter,
    PeriodParser {
        private final String iText;
        private final String iFinalText;
        private final String[] iParsedForms;
        private final boolean iUseBefore;
        private final boolean iUseAfter;
        private final PeriodPrinter iBeforePrinter;
        private volatile PeriodPrinter iAfterPrinter;
        private final PeriodParser iBeforeParser;
        private volatile PeriodParser iAfterParser;

        Separator(String text, String finalText, String[] variants, PeriodPrinter beforePrinter, PeriodParser beforeParser, boolean useBefore, boolean useAfter) {
            this.iText = text;
            this.iFinalText = finalText;
            if (!(finalText != null && !text.equals(finalText) || variants != null && variants.length != 0)) {
                this.iParsedForms = new String[]{text};
            } else {
                TreeSet<String> parsedSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                parsedSet.add(text);
                parsedSet.add(finalText);
                if (variants != null) {
                    int i = variants.length;
                    while (--i >= 0) {
                        parsedSet.add(variants[i]);
                    }
                }
                ArrayList parsedList = new ArrayList(parsedSet);
                Collections.reverse(parsedList);
                this.iParsedForms = parsedList.toArray(new String[parsedList.size()]);
            }
            this.iBeforePrinter = beforePrinter;
            this.iBeforeParser = beforeParser;
            this.iUseBefore = useBefore;
            this.iUseAfter = useAfter;
        }

        @Override
        public int countFieldsToPrint(ReadablePeriod period, int stopAt, Locale locale) {
            int sum = this.iBeforePrinter.countFieldsToPrint(period, stopAt, locale);
            if (sum < stopAt) {
                sum += this.iAfterPrinter.countFieldsToPrint(period, stopAt, locale);
            }
            return sum;
        }

        @Override
        public int calculatePrintedLength(ReadablePeriod period, Locale locale) {
            PeriodPrinter before = this.iBeforePrinter;
            PeriodPrinter after = this.iAfterPrinter;
            int sum = before.calculatePrintedLength(period, locale) + after.calculatePrintedLength(period, locale);
            if (this.iUseBefore) {
                if (before.countFieldsToPrint(period, 1, locale) > 0) {
                    if (this.iUseAfter) {
                        int afterCount = after.countFieldsToPrint(period, 2, locale);
                        if (afterCount > 0) {
                            sum += (afterCount > 1 ? this.iText : this.iFinalText).length();
                        }
                    } else {
                        sum += this.iText.length();
                    }
                }
            } else if (this.iUseAfter && after.countFieldsToPrint(period, 1, locale) > 0) {
                sum += this.iText.length();
            }
            return sum;
        }

        @Override
        public void printTo(StringBuffer buf, ReadablePeriod period, Locale locale) {
            PeriodPrinter before = this.iBeforePrinter;
            PeriodPrinter after = this.iAfterPrinter;
            before.printTo(buf, period, locale);
            if (this.iUseBefore) {
                if (before.countFieldsToPrint(period, 1, locale) > 0) {
                    if (this.iUseAfter) {
                        int afterCount = after.countFieldsToPrint(period, 2, locale);
                        if (afterCount > 0) {
                            buf.append(afterCount > 1 ? this.iText : this.iFinalText);
                        }
                    } else {
                        buf.append(this.iText);
                    }
                }
            } else if (this.iUseAfter && after.countFieldsToPrint(period, 1, locale) > 0) {
                buf.append(this.iText);
            }
            after.printTo(buf, period, locale);
        }

        @Override
        public void printTo(Writer out, ReadablePeriod period, Locale locale) throws IOException {
            PeriodPrinter before = this.iBeforePrinter;
            PeriodPrinter after = this.iAfterPrinter;
            before.printTo(out, period, locale);
            if (this.iUseBefore) {
                if (before.countFieldsToPrint(period, 1, locale) > 0) {
                    if (this.iUseAfter) {
                        int afterCount = after.countFieldsToPrint(period, 2, locale);
                        if (afterCount > 0) {
                            out.write(afterCount > 1 ? this.iText : this.iFinalText);
                        }
                    } else {
                        out.write(this.iText);
                    }
                }
            } else if (this.iUseAfter && after.countFieldsToPrint(period, 1, locale) > 0) {
                out.write(this.iText);
            }
            after.printTo(out, period, locale);
        }

        @Override
        public int parseInto(ReadWritablePeriod period, String periodStr, int position, Locale locale) {
            int oldPos = position;
            if ((position = this.iBeforeParser.parseInto(period, periodStr, position, locale)) < 0) {
                return position;
            }
            boolean found = false;
            int parsedFormLength = -1;
            if (position > oldPos) {
                for (String parsedForm : this.iParsedForms) {
                    if (parsedForm != null && parsedForm.length() != 0 && !periodStr.regionMatches(true, position, parsedForm, 0, parsedForm.length())) continue;
                    parsedFormLength = parsedForm == null ? 0 : parsedForm.length();
                    position += parsedFormLength;
                    found = true;
                    break;
                }
            }
            oldPos = position;
            if ((position = this.iAfterParser.parseInto(period, periodStr, position, locale)) < 0) {
                return position;
            }
            if (found && position == oldPos && parsedFormLength > 0) {
                return ~oldPos;
            }
            if (position > oldPos && !found && !this.iUseBefore) {
                return ~oldPos;
            }
            return position;
        }

        Separator finish(PeriodPrinter afterPrinter, PeriodParser afterParser) {
            this.iAfterPrinter = afterPrinter;
            this.iAfterParser = afterParser;
            return this;
        }
    }

    static class Literal
    implements PeriodPrinter,
    PeriodParser {
        static final Literal EMPTY = new Literal("");
        private final String iText;

        Literal(String text) {
            this.iText = text;
        }

        @Override
        public int countFieldsToPrint(ReadablePeriod period, int stopAt, Locale locale) {
            return 0;
        }

        @Override
        public int calculatePrintedLength(ReadablePeriod period, Locale locale) {
            return this.iText.length();
        }

        @Override
        public void printTo(StringBuffer buf, ReadablePeriod period, Locale locale) {
            buf.append(this.iText);
        }

        @Override
        public void printTo(Writer out, ReadablePeriod period, Locale locale) throws IOException {
            out.write(this.iText);
        }

        @Override
        public int parseInto(ReadWritablePeriod period, String periodStr, int position, Locale locale) {
            if (periodStr.regionMatches(true, position, this.iText, 0, this.iText.length())) {
                return position + this.iText.length();
            }
            return ~position;
        }
    }

    static class FieldFormatter
    implements PeriodPrinter,
    PeriodParser {
        private final int iMinPrintedDigits;
        private final int iPrintZeroSetting;
        private final int iMaxParsedDigits;
        private final boolean iRejectSignedValues;
        private final int iFieldType;
        private final FieldFormatter[] iFieldFormatters;
        private final PeriodFieldAffix iPrefix;
        private final PeriodFieldAffix iSuffix;

        FieldFormatter(int minPrintedDigits, int printZeroSetting, int maxParsedDigits, boolean rejectSignedValues, int fieldType, FieldFormatter[] fieldFormatters, PeriodFieldAffix prefix, PeriodFieldAffix suffix) {
            this.iMinPrintedDigits = minPrintedDigits;
            this.iPrintZeroSetting = printZeroSetting;
            this.iMaxParsedDigits = maxParsedDigits;
            this.iRejectSignedValues = rejectSignedValues;
            this.iFieldType = fieldType;
            this.iFieldFormatters = fieldFormatters;
            this.iPrefix = prefix;
            this.iSuffix = suffix;
        }

        FieldFormatter(FieldFormatter field, PeriodFieldAffix suffix) {
            this.iMinPrintedDigits = field.iMinPrintedDigits;
            this.iPrintZeroSetting = field.iPrintZeroSetting;
            this.iMaxParsedDigits = field.iMaxParsedDigits;
            this.iRejectSignedValues = field.iRejectSignedValues;
            this.iFieldType = field.iFieldType;
            this.iFieldFormatters = field.iFieldFormatters;
            this.iPrefix = field.iPrefix;
            if (field.iSuffix != null) {
                suffix = new CompositeAffix(field.iSuffix, suffix);
            }
            this.iSuffix = suffix;
        }

        public void finish(FieldFormatter[] fieldFormatters) {
            HashSet<PeriodFieldAffix> prefixesToIgnore = new HashSet<PeriodFieldAffix>();
            HashSet<PeriodFieldAffix> suffixesToIgnore = new HashSet<PeriodFieldAffix>();
            for (FieldFormatter fieldFormatter : fieldFormatters) {
                if (fieldFormatter == null || this.equals(fieldFormatter)) continue;
                prefixesToIgnore.add(fieldFormatter.iPrefix);
                suffixesToIgnore.add(fieldFormatter.iSuffix);
            }
            if (this.iPrefix != null) {
                this.iPrefix.finish(prefixesToIgnore);
            }
            if (this.iSuffix != null) {
                this.iSuffix.finish(suffixesToIgnore);
            }
        }

        @Override
        public int countFieldsToPrint(ReadablePeriod period, int stopAt, Locale locale) {
            if (stopAt <= 0) {
                return 0;
            }
            if (this.iPrintZeroSetting == 4 || this.getFieldValue(period) != Long.MAX_VALUE) {
                return 1;
            }
            return 0;
        }

        @Override
        public int calculatePrintedLength(ReadablePeriod period, Locale locale) {
            long valueLong = this.getFieldValue(period);
            if (valueLong == Long.MAX_VALUE) {
                return 0;
            }
            int sum = Math.max(FormatUtils.calculateDigitCount(valueLong), this.iMinPrintedDigits);
            if (this.iFieldType >= 8) {
                sum = valueLong < 0L ? Math.max(sum, 5) : Math.max(sum, 4);
                ++sum;
                if (this.iFieldType == 9 && Math.abs(valueLong) % 1000L == 0L) {
                    sum -= 4;
                }
                valueLong /= 1000L;
            }
            int value = (int)valueLong;
            if (this.iPrefix != null) {
                sum += this.iPrefix.calculatePrintedLength(value);
            }
            if (this.iSuffix != null) {
                sum += this.iSuffix.calculatePrintedLength(value);
            }
            return sum;
        }

        @Override
        public void printTo(StringBuffer buf, ReadablePeriod period, Locale locale) {
            long valueLong = this.getFieldValue(period);
            if (valueLong == Long.MAX_VALUE) {
                return;
            }
            int value = (int)valueLong;
            if (this.iFieldType >= 8) {
                value = (int)(valueLong / 1000L);
            }
            if (this.iPrefix != null) {
                this.iPrefix.printTo(buf, value);
            }
            int bufLen = buf.length();
            int minDigits = this.iMinPrintedDigits;
            if (minDigits <= 1) {
                FormatUtils.appendUnpaddedInteger(buf, value);
            } else {
                FormatUtils.appendPaddedInteger(buf, value, minDigits);
            }
            if (this.iFieldType >= 8) {
                int dp = (int)(Math.abs(valueLong) % 1000L);
                if (this.iFieldType == 8 || dp > 0) {
                    if (valueLong < 0L && valueLong > -1000L) {
                        buf.insert(bufLen, '-');
                    }
                    buf.append('.');
                    FormatUtils.appendPaddedInteger(buf, dp, 3);
                }
            }
            if (this.iSuffix != null) {
                this.iSuffix.printTo(buf, value);
            }
        }

        @Override
        public void printTo(Writer out, ReadablePeriod period, Locale locale) throws IOException {
            int minDigits;
            long valueLong = this.getFieldValue(period);
            if (valueLong == Long.MAX_VALUE) {
                return;
            }
            int value = (int)valueLong;
            if (this.iFieldType >= 8) {
                value = (int)(valueLong / 1000L);
            }
            if (this.iPrefix != null) {
                this.iPrefix.printTo(out, value);
            }
            if ((minDigits = this.iMinPrintedDigits) <= 1) {
                FormatUtils.writeUnpaddedInteger(out, value);
            } else {
                FormatUtils.writePaddedInteger(out, value, minDigits);
            }
            if (this.iFieldType >= 8) {
                int dp = (int)(Math.abs(valueLong) % 1000L);
                if (this.iFieldType == 8 || dp > 0) {
                    out.write(46);
                    FormatUtils.writePaddedInteger(out, dp, 3);
                }
            }
            if (this.iSuffix != null) {
                this.iSuffix.printTo(out, value);
            }
        }

        @Override
        public int parseInto(ReadWritablePeriod period, String text, int position, Locale locale) {
            boolean mustParse;
            boolean bl = mustParse = this.iPrintZeroSetting == 4;
            if (position >= text.length()) {
                return mustParse ? ~position : position;
            }
            if (this.iPrefix != null) {
                if ((position = this.iPrefix.parse(text, position)) >= 0) {
                    mustParse = true;
                } else {
                    if (!mustParse) {
                        return ~position;
                    }
                    return position;
                }
            }
            int suffixPos = -1;
            if (this.iSuffix != null && !mustParse) {
                suffixPos = this.iSuffix.scan(text, position);
                if (suffixPos >= 0) {
                    mustParse = true;
                } else {
                    if (!mustParse) {
                        return ~suffixPos;
                    }
                    return suffixPos;
                }
            }
            if (!mustParse && !this.isSupported(period.getPeriodType(), this.iFieldType)) {
                return position;
            }
            int limit = suffixPos > 0 ? Math.min(this.iMaxParsedDigits, suffixPos - position) : Math.min(this.iMaxParsedDigits, text.length() - position);
            int length = 0;
            int fractPos = -1;
            boolean hasDigits = false;
            while (length < limit) {
                char c = text.charAt(position + length);
                if (!(length != 0 || c != '-' && c != '+' || this.iRejectSignedValues)) {
                    boolean negative;
                    boolean bl2 = negative = c == '-';
                    if (length + 1 >= limit || (c = text.charAt(position + length + 1)) < '0' || c > '9') break;
                    if (negative) {
                        ++length;
                    } else {
                        ++position;
                    }
                    limit = Math.min(limit + 1, text.length() - position);
                    continue;
                }
                if (c >= '0' && c <= '9') {
                    hasDigits = true;
                } else {
                    if (c != '.' && c != ',' || this.iFieldType != 8 && this.iFieldType != 9 || fractPos >= 0) break;
                    fractPos = position + length + 1;
                    limit = Math.min(limit + 1, text.length() - position);
                }
                ++length;
            }
            if (!hasDigits) {
                return ~position;
            }
            if (suffixPos >= 0 && position + length != suffixPos) {
                return position;
            }
            if (this.iFieldType != 8 && this.iFieldType != 9) {
                this.setFieldValue(period, this.iFieldType, this.parseInt(text, position, length));
            } else if (fractPos < 0) {
                this.setFieldValue(period, 6, this.parseInt(text, position, length));
                this.setFieldValue(period, 7, 0);
            } else {
                int fractValue;
                int wholeValue = this.parseInt(text, position, fractPos - position - 1);
                this.setFieldValue(period, 6, wholeValue);
                int fractLen = position + length - fractPos;
                if (fractLen <= 0) {
                    fractValue = 0;
                } else {
                    if (fractLen >= 3) {
                        fractValue = this.parseInt(text, fractPos, 3);
                    } else {
                        fractValue = this.parseInt(text, fractPos, fractLen);
                        fractValue = fractLen == 1 ? (fractValue *= 100) : (fractValue *= 10);
                    }
                    if (wholeValue < 0) {
                        fractValue = -fractValue;
                    }
                }
                this.setFieldValue(period, 7, fractValue);
            }
            if ((position += length) >= 0 && this.iSuffix != null) {
                position = this.iSuffix.parse(text, position);
            }
            return position;
        }

        private int parseInt(String text, int position, int length) {
            boolean negative;
            if (length >= 10) {
                return Integer.parseInt(text.substring(position, position + length));
            }
            if (length <= 0) {
                return 0;
            }
            int value = text.charAt(position++);
            --length;
            if (value == 45) {
                if (--length < 0) {
                    return 0;
                }
                negative = true;
                value = text.charAt(position++);
            } else {
                negative = false;
            }
            value -= 48;
            while (length-- > 0) {
                value = (value << 3) + (value << 1) + text.charAt(position++) - 48;
            }
            return negative ? -value : value;
        }

        long getFieldValue(ReadablePeriod period) {
            long value;
            PeriodType type = this.iPrintZeroSetting == 4 ? null : period.getPeriodType();
            if (type != null && !this.isSupported(type, this.iFieldType)) {
                return Long.MAX_VALUE;
            }
            switch (this.iFieldType) {
                default: {
                    return Long.MAX_VALUE;
                }
                case 0: {
                    value = period.get(DurationFieldType.years());
                    break;
                }
                case 1: {
                    value = period.get(DurationFieldType.months());
                    break;
                }
                case 2: {
                    value = period.get(DurationFieldType.weeks());
                    break;
                }
                case 3: {
                    value = period.get(DurationFieldType.days());
                    break;
                }
                case 4: {
                    value = period.get(DurationFieldType.hours());
                    break;
                }
                case 5: {
                    value = period.get(DurationFieldType.minutes());
                    break;
                }
                case 6: {
                    value = period.get(DurationFieldType.seconds());
                    break;
                }
                case 7: {
                    value = period.get(DurationFieldType.millis());
                    break;
                }
                case 8: 
                case 9: {
                    int seconds = period.get(DurationFieldType.seconds());
                    int millis = period.get(DurationFieldType.millis());
                    value = (long)seconds * 1000L + (long)millis;
                }
            }
            if (value == 0L) {
                switch (this.iPrintZeroSetting) {
                    case 5: {
                        return Long.MAX_VALUE;
                    }
                    case 2: {
                        int i;
                        if (this.isZero(period) && this.iFieldFormatters[this.iFieldType] == this) {
                            for (i = this.iFieldType + 1; i <= 9; ++i) {
                                if (!this.isSupported(type, i) || this.iFieldFormatters[i] == null) continue;
                                return Long.MAX_VALUE;
                            }
                            break;
                        }
                        return Long.MAX_VALUE;
                    }
                    case 1: {
                        int i;
                        if (this.isZero(period) && this.iFieldFormatters[this.iFieldType] == this) {
                            i = Math.min(this.iFieldType, 8);
                            --i;
                            while (i >= 0 && i <= 9) {
                                if (this.isSupported(type, i) && this.iFieldFormatters[i] != null) {
                                    return Long.MAX_VALUE;
                                }
                                --i;
                            }
                            break;
                        }
                        return Long.MAX_VALUE;
                    }
                }
            }
            return value;
        }

        boolean isZero(ReadablePeriod period) {
            int isize = period.size();
            for (int i = 0; i < isize; ++i) {
                if (period.getValue(i) == 0) continue;
                return false;
            }
            return true;
        }

        boolean isSupported(PeriodType type, int field) {
            switch (field) {
                default: {
                    return false;
                }
                case 0: {
                    return type.isSupported(DurationFieldType.years());
                }
                case 1: {
                    return type.isSupported(DurationFieldType.months());
                }
                case 2: {
                    return type.isSupported(DurationFieldType.weeks());
                }
                case 3: {
                    return type.isSupported(DurationFieldType.days());
                }
                case 4: {
                    return type.isSupported(DurationFieldType.hours());
                }
                case 5: {
                    return type.isSupported(DurationFieldType.minutes());
                }
                case 6: {
                    return type.isSupported(DurationFieldType.seconds());
                }
                case 7: {
                    return type.isSupported(DurationFieldType.millis());
                }
                case 8: 
                case 9: 
            }
            return type.isSupported(DurationFieldType.seconds()) || type.isSupported(DurationFieldType.millis());
        }

        void setFieldValue(ReadWritablePeriod period, int field, int value) {
            switch (field) {
                default: {
                    break;
                }
                case 0: {
                    period.setYears(value);
                    break;
                }
                case 1: {
                    period.setMonths(value);
                    break;
                }
                case 2: {
                    period.setWeeks(value);
                    break;
                }
                case 3: {
                    period.setDays(value);
                    break;
                }
                case 4: {
                    period.setHours(value);
                    break;
                }
                case 5: {
                    period.setMinutes(value);
                    break;
                }
                case 6: {
                    period.setSeconds(value);
                    break;
                }
                case 7: {
                    period.setMillis(value);
                }
            }
        }

        int getFieldType() {
            return this.iFieldType;
        }
    }

    static class CompositeAffix
    extends IgnorableAffix {
        private final PeriodFieldAffix iLeft;
        private final PeriodFieldAffix iRight;
        private final String[] iLeftRightCombinations;

        CompositeAffix(PeriodFieldAffix left, PeriodFieldAffix right) {
            this.iLeft = left;
            this.iRight = right;
            HashSet<String> result = new HashSet<String>();
            for (String leftText : this.iLeft.getAffixes()) {
                for (String rightText : this.iRight.getAffixes()) {
                    result.add(leftText + rightText);
                }
            }
            this.iLeftRightCombinations = result.toArray(new String[result.size()]);
        }

        @Override
        public int calculatePrintedLength(int value) {
            return this.iLeft.calculatePrintedLength(value) + this.iRight.calculatePrintedLength(value);
        }

        @Override
        public void printTo(StringBuffer buf, int value) {
            this.iLeft.printTo(buf, value);
            this.iRight.printTo(buf, value);
        }

        @Override
        public void printTo(Writer out, int value) throws IOException {
            this.iLeft.printTo(out, value);
            this.iRight.printTo(out, value);
        }

        @Override
        public int parse(String periodStr, int position) {
            int pos = this.iLeft.parse(periodStr, position);
            if (pos >= 0 && (pos = this.iRight.parse(periodStr, pos)) >= 0 && this.matchesOtherAffix(this.parse(periodStr, pos) - pos, periodStr, position)) {
                return ~position;
            }
            return pos;
        }

        @Override
        public int scan(String periodStr, int position) {
            int rightPosition;
            int leftPosition = this.iLeft.scan(periodStr, position);
            if (!(leftPosition < 0 || (rightPosition = this.iRight.scan(periodStr, this.iLeft.parse(periodStr, leftPosition))) >= 0 && this.matchesOtherAffix(this.iRight.parse(periodStr, rightPosition) - leftPosition, periodStr, position))) {
                if (leftPosition > 0) {
                    return leftPosition;
                }
                return rightPosition;
            }
            return ~position;
        }

        @Override
        public String[] getAffixes() {
            return (String[])this.iLeftRightCombinations.clone();
        }
    }

    static class RegExAffix
    extends IgnorableAffix {
        private static final Comparator<String> LENGTH_DESC_COMPARATOR = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        };
        private final String[] iSuffixes;
        private final Pattern[] iPatterns;
        private final String[] iSuffixesSortedDescByLength;

        RegExAffix(String[] regExes, String[] texts) {
            this.iSuffixes = (String[])texts.clone();
            this.iPatterns = new Pattern[regExes.length];
            for (int i = 0; i < regExes.length; ++i) {
                Pattern pattern = (Pattern)PATTERNS.get(regExes[i]);
                if (pattern == null) {
                    pattern = Pattern.compile(regExes[i]);
                    PATTERNS.putIfAbsent(regExes[i], pattern);
                }
                this.iPatterns[i] = pattern;
            }
            this.iSuffixesSortedDescByLength = (String[])this.iSuffixes.clone();
            Arrays.sort(this.iSuffixesSortedDescByLength, LENGTH_DESC_COMPARATOR);
        }

        private int selectSuffixIndex(int value) {
            String valueString = String.valueOf(value);
            for (int i = 0; i < this.iPatterns.length; ++i) {
                if (!this.iPatterns[i].matcher(valueString).matches()) continue;
                return i;
            }
            return this.iPatterns.length - 1;
        }

        @Override
        public int calculatePrintedLength(int value) {
            return this.iSuffixes[this.selectSuffixIndex(value)].length();
        }

        @Override
        public void printTo(StringBuffer buf, int value) {
            buf.append(this.iSuffixes[this.selectSuffixIndex(value)]);
        }

        @Override
        public void printTo(Writer out, int value) throws IOException {
            out.write(this.iSuffixes[this.selectSuffixIndex(value)]);
        }

        @Override
        public int parse(String periodStr, int position) {
            for (String text : this.iSuffixesSortedDescByLength) {
                if (!periodStr.regionMatches(true, position, text, 0, text.length()) || this.matchesOtherAffix(text.length(), periodStr, position)) continue;
                return position + text.length();
            }
            return ~position;
        }

        @Override
        public int scan(String periodStr, int position) {
            int sourceLength = periodStr.length();
            for (int pos = position; pos < sourceLength; ++pos) {
                for (String text : this.iSuffixesSortedDescByLength) {
                    if (!periodStr.regionMatches(true, pos, text, 0, text.length()) || this.matchesOtherAffix(text.length(), periodStr, pos)) continue;
                    return pos;
                }
            }
            return ~position;
        }

        @Override
        public String[] getAffixes() {
            return (String[])this.iSuffixes.clone();
        }
    }

    static class PluralAffix
    extends IgnorableAffix {
        private final String iSingularText;
        private final String iPluralText;

        PluralAffix(String singularText, String pluralText) {
            this.iSingularText = singularText;
            this.iPluralText = pluralText;
        }

        @Override
        public int calculatePrintedLength(int value) {
            return (value == 1 ? this.iSingularText : this.iPluralText).length();
        }

        @Override
        public void printTo(StringBuffer buf, int value) {
            buf.append(value == 1 ? this.iSingularText : this.iPluralText);
        }

        @Override
        public void printTo(Writer out, int value) throws IOException {
            out.write(value == 1 ? this.iSingularText : this.iPluralText);
        }

        @Override
        public int parse(String periodStr, int position) {
            String text1 = this.iPluralText;
            String text2 = this.iSingularText;
            if (text1.length() < text2.length()) {
                String temp = text1;
                text1 = text2;
                text2 = temp;
            }
            if (periodStr.regionMatches(true, position, text1, 0, text1.length()) && !this.matchesOtherAffix(text1.length(), periodStr, position)) {
                return position + text1.length();
            }
            if (periodStr.regionMatches(true, position, text2, 0, text2.length()) && !this.matchesOtherAffix(text2.length(), periodStr, position)) {
                return position + text2.length();
            }
            return ~position;
        }

        @Override
        public int scan(String periodStr, int position) {
            String text1 = this.iPluralText;
            String text2 = this.iSingularText;
            if (text1.length() < text2.length()) {
                String temp = text1;
                text1 = text2;
                text2 = temp;
            }
            int textLength1 = text1.length();
            int textLength2 = text2.length();
            int sourceLength = periodStr.length();
            for (int pos = position; pos < sourceLength; ++pos) {
                if (periodStr.regionMatches(true, pos, text1, 0, textLength1) && !this.matchesOtherAffix(text1.length(), periodStr, pos)) {
                    return pos;
                }
                if (!periodStr.regionMatches(true, pos, text2, 0, textLength2) || this.matchesOtherAffix(text2.length(), periodStr, pos)) continue;
                return pos;
            }
            return ~position;
        }

        @Override
        public String[] getAffixes() {
            return new String[]{this.iSingularText, this.iPluralText};
        }
    }

    static class SimpleAffix
    extends IgnorableAffix {
        private final String iText;

        SimpleAffix(String text) {
            this.iText = text;
        }

        @Override
        public int calculatePrintedLength(int value) {
            return this.iText.length();
        }

        @Override
        public void printTo(StringBuffer buf, int value) {
            buf.append(this.iText);
        }

        @Override
        public void printTo(Writer out, int value) throws IOException {
            out.write(this.iText);
        }

        @Override
        public int parse(String periodStr, int position) {
            String text = this.iText;
            int textLength = text.length();
            if (periodStr.regionMatches(true, position, text, 0, textLength) && !this.matchesOtherAffix(textLength, periodStr, position)) {
                return position + textLength;
            }
            return ~position;
        }

        @Override
        public int scan(String periodStr, int position) {
            String text = this.iText;
            int textLength = text.length();
            int sourceLength = periodStr.length();
            block3: for (int pos = position; pos < sourceLength; ++pos) {
                if (periodStr.regionMatches(true, pos, text, 0, textLength) && !this.matchesOtherAffix(textLength, periodStr, pos)) {
                    return pos;
                }
                switch (periodStr.charAt(pos)) {
                    case '+': 
                    case ',': 
                    case '-': 
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        continue block3;
                    }
                }
            }
            return ~position;
        }

        @Override
        public String[] getAffixes() {
            return new String[]{this.iText};
        }
    }

    static abstract class IgnorableAffix
    implements PeriodFieldAffix {
        private volatile String[] iOtherAffixes;

        IgnorableAffix() {
        }

        @Override
        public void finish(Set<PeriodFieldAffix> periodFieldAffixesToIgnore) {
            if (this.iOtherAffixes == null) {
                int shortestAffixLength = Integer.MAX_VALUE;
                for (String affix : this.getAffixes()) {
                    if (affix.length() >= shortestAffixLength) continue;
                    shortestAffixLength = affix.length();
                }
                HashSet<String> affixesToIgnore = new HashSet<String>();
                for (PeriodFieldAffix periodFieldAffixToIgnore : periodFieldAffixesToIgnore) {
                    if (periodFieldAffixToIgnore == null) continue;
                    for (String affixToIgnore : periodFieldAffixToIgnore.getAffixes()) {
                        if (affixToIgnore.length() <= shortestAffixLength) continue;
                        affixesToIgnore.add(affixToIgnore);
                    }
                }
                this.iOtherAffixes = affixesToIgnore.toArray(new String[affixesToIgnore.size()]);
            }
        }

        protected boolean matchesOtherAffix(int textLength, String periodStr, int position) {
            if (this.iOtherAffixes != null) {
                for (String affixToIgnore : this.iOtherAffixes) {
                    int textToIgnoreLength = affixToIgnore.length();
                    if (textLength >= textToIgnoreLength || !periodStr.regionMatches(true, position, affixToIgnore, 0, textToIgnoreLength)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    static interface PeriodFieldAffix {
        public int calculatePrintedLength(int var1);

        public void printTo(StringBuffer var1, int var2);

        public void printTo(Writer var1, int var2) throws IOException;

        public int parse(String var1, int var2);

        public int scan(String var1, int var2);

        public String[] getAffixes();

        public void finish(Set<PeriodFieldAffix> var1);
    }
}

