/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.config;

import java.net.URI;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import net.devh.boot.grpc.client.config.NegotiationType;
import org.springframework.boot.convert.DurationUnit;

public class GrpcChannelProperties {
    private URI address = null;
    private Boolean enableKeepAlive;
    private static final boolean DEFAULT_ENABLE_KEEP_ALIVE = false;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration keepAliveTime;
    private static final Duration DEFAULT_KEEP_ALIVE_TIME = Duration.of(60L, ChronoUnit.SECONDS);
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration keepAliveTimeout;
    private static final Duration DEFAULT_KEEP_ALIVE_TIMEOUT = Duration.of(20L, ChronoUnit.SECONDS);
    private Boolean keepAliveWithoutCalls;
    private static final boolean DEFAULT_KEEP_ALIVE_WITHOUT_CALLS = false;
    private Integer maxInboundMessageSize = null;
    private Boolean fullStreamDecompression;
    private static final boolean DEFAULT_FULL_STREAM_DECOMPRESSION = false;
    private NegotiationType negotiationType;
    private static final NegotiationType DEFAULT_NEGOTIATION_TYPE = NegotiationType.TLS;
    private final Security security = new Security();

    public URI getAddress() {
        return this.address;
    }

    public void setAddress(URI address) {
        this.address = address;
    }

    public void setAddress(String address) {
        this.address = address == null ? null : URI.create(address);
    }

    @Deprecated
    public void setHost(String host) {
        throw new UnsupportedOperationException("Use the 'address' attribute with 'static://host1:port1,...,hostn:portn' instead");
    }

    @Deprecated
    public void setHost(List<String> hosts) {
        throw new UnsupportedOperationException("Use the 'address' attribute with 'static://host1:port1,...,hostn:portn' instead");
    }

    @Deprecated
    public void setPort(String port) {
        throw new UnsupportedOperationException("Use the 'address' attribute with 'static://host1:port1,...,hostn:portn' instead");
    }

    @Deprecated
    public void setPort(List<String> ports) {
        throw new UnsupportedOperationException("Use the 'address' attribute with 'static://host1:port1,...,hostn:portn' instead");
    }

    public boolean isEnableKeepAlive() {
        return this.enableKeepAlive == null ? false : this.enableKeepAlive;
    }

    public void setEnableKeepAlive(Boolean enableKeepAlive) {
        this.enableKeepAlive = enableKeepAlive;
    }

    public Duration getKeepAliveTime() {
        return this.keepAliveTime == null ? DEFAULT_KEEP_ALIVE_TIME : this.keepAliveTime;
    }

    public void setKeepAliveTime(Duration keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public Duration getKeepAliveTimeout() {
        return this.keepAliveTimeout == null ? DEFAULT_KEEP_ALIVE_TIMEOUT : this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(Duration keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public boolean isKeepAliveWithoutCalls() {
        return this.keepAliveWithoutCalls == null ? false : this.keepAliveWithoutCalls;
    }

    public void setKeepAliveWithoutCalls(Boolean keepAliveWithoutCalls) {
        this.keepAliveWithoutCalls = keepAliveWithoutCalls;
    }

    public Integer getMaxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    public void setMaxInboundMessageSize(Integer maxInboundMessageSize) {
        if (maxInboundMessageSize == null || maxInboundMessageSize >= 0) {
            this.maxInboundMessageSize = maxInboundMessageSize;
        } else if (maxInboundMessageSize == -1) {
            this.maxInboundMessageSize = Integer.MAX_VALUE;
        } else {
            throw new IllegalArgumentException("Unsupported maxInboundMessageSize: " + maxInboundMessageSize);
        }
    }

    public boolean isFullStreamDecompression() {
        return this.fullStreamDecompression == null ? false : this.fullStreamDecompression;
    }

    public void setFullStreamDecompression(Boolean fullStreamDecompression) {
        this.fullStreamDecompression = fullStreamDecompression;
    }

    public NegotiationType getNegotiationType() {
        return this.negotiationType == null ? DEFAULT_NEGOTIATION_TYPE : this.negotiationType;
    }

    public void setNegotiationType(NegotiationType negotiationType) {
        this.negotiationType = negotiationType;
    }

    public Security getSecurity() {
        return this.security;
    }

    public void copyDefaultsFrom(GrpcChannelProperties config) {
        if (this == config) {
            return;
        }
        if (this.address == null) {
            this.address = config.address;
        }
        if (this.enableKeepAlive == null) {
            this.enableKeepAlive = config.enableKeepAlive;
        }
        if (this.keepAliveTime == null) {
            this.keepAliveTime = config.keepAliveTime;
        }
        if (this.keepAliveTimeout == null) {
            this.keepAliveTimeout = config.keepAliveTimeout;
        }
        if (this.keepAliveWithoutCalls == null) {
            this.keepAliveWithoutCalls = config.keepAliveWithoutCalls;
        }
        if (this.maxInboundMessageSize == null) {
            this.maxInboundMessageSize = config.maxInboundMessageSize;
        }
        if (this.fullStreamDecompression == null) {
            this.fullStreamDecompression = config.fullStreamDecompression;
        }
        if (this.negotiationType == null) {
            this.negotiationType = config.negotiationType;
        }
        this.security.copyDefaultsFrom(config.security);
    }

    public String toString() {
        return "GrpcChannelProperties(address=" + this.getAddress() + ", enableKeepAlive=" + this.enableKeepAlive + ", keepAliveTime=" + this.getKeepAliveTime() + ", keepAliveTimeout=" + this.getKeepAliveTimeout() + ", keepAliveWithoutCalls=" + this.keepAliveWithoutCalls + ", maxInboundMessageSize=" + this.getMaxInboundMessageSize() + ", fullStreamDecompression=" + this.fullStreamDecompression + ", negotiationType=" + (Object)((Object)this.getNegotiationType()) + ", security=" + this.getSecurity() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GrpcChannelProperties)) {
            return false;
        }
        GrpcChannelProperties other = (GrpcChannelProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        URI this$address = this.getAddress();
        URI other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        Boolean this$enableKeepAlive = this.enableKeepAlive;
        Boolean other$enableKeepAlive = other.enableKeepAlive;
        if (this$enableKeepAlive == null ? other$enableKeepAlive != null : !((Object)this$enableKeepAlive).equals(other$enableKeepAlive)) {
            return false;
        }
        Duration this$keepAliveTime = this.getKeepAliveTime();
        Duration other$keepAliveTime = other.getKeepAliveTime();
        if (this$keepAliveTime == null ? other$keepAliveTime != null : !((Object)this$keepAliveTime).equals(other$keepAliveTime)) {
            return false;
        }
        Duration this$keepAliveTimeout = this.getKeepAliveTimeout();
        Duration other$keepAliveTimeout = other.getKeepAliveTimeout();
        if (this$keepAliveTimeout == null ? other$keepAliveTimeout != null : !((Object)this$keepAliveTimeout).equals(other$keepAliveTimeout)) {
            return false;
        }
        Boolean this$keepAliveWithoutCalls = this.keepAliveWithoutCalls;
        Boolean other$keepAliveWithoutCalls = other.keepAliveWithoutCalls;
        if (this$keepAliveWithoutCalls == null ? other$keepAliveWithoutCalls != null : !((Object)this$keepAliveWithoutCalls).equals(other$keepAliveWithoutCalls)) {
            return false;
        }
        Integer this$maxInboundMessageSize = this.getMaxInboundMessageSize();
        Integer other$maxInboundMessageSize = other.getMaxInboundMessageSize();
        if (this$maxInboundMessageSize == null ? other$maxInboundMessageSize != null : !((Object)this$maxInboundMessageSize).equals(other$maxInboundMessageSize)) {
            return false;
        }
        Boolean this$fullStreamDecompression = this.fullStreamDecompression;
        Boolean other$fullStreamDecompression = other.fullStreamDecompression;
        if (this$fullStreamDecompression == null ? other$fullStreamDecompression != null : !((Object)this$fullStreamDecompression).equals(other$fullStreamDecompression)) {
            return false;
        }
        NegotiationType this$negotiationType = this.getNegotiationType();
        NegotiationType other$negotiationType = other.getNegotiationType();
        if (this$negotiationType == null ? other$negotiationType != null : !((Object)((Object)this$negotiationType)).equals((Object)other$negotiationType)) {
            return false;
        }
        Security this$security = this.getSecurity();
        Security other$security = other.getSecurity();
        return !(this$security == null ? other$security != null : !((Object)this$security).equals(other$security));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GrpcChannelProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        Boolean $enableKeepAlive = this.enableKeepAlive;
        result = result * 59 + ($enableKeepAlive == null ? 43 : ((Object)$enableKeepAlive).hashCode());
        Duration $keepAliveTime = this.getKeepAliveTime();
        result = result * 59 + ($keepAliveTime == null ? 43 : ((Object)$keepAliveTime).hashCode());
        Duration $keepAliveTimeout = this.getKeepAliveTimeout();
        result = result * 59 + ($keepAliveTimeout == null ? 43 : ((Object)$keepAliveTimeout).hashCode());
        Boolean $keepAliveWithoutCalls = this.keepAliveWithoutCalls;
        result = result * 59 + ($keepAliveWithoutCalls == null ? 43 : ((Object)$keepAliveWithoutCalls).hashCode());
        Integer $maxInboundMessageSize = this.getMaxInboundMessageSize();
        result = result * 59 + ($maxInboundMessageSize == null ? 43 : ((Object)$maxInboundMessageSize).hashCode());
        Boolean $fullStreamDecompression = this.fullStreamDecompression;
        result = result * 59 + ($fullStreamDecompression == null ? 43 : ((Object)$fullStreamDecompression).hashCode());
        NegotiationType $negotiationType = this.getNegotiationType();
        result = result * 59 + ($negotiationType == null ? 43 : ((Object)((Object)$negotiationType)).hashCode());
        Security $security = this.getSecurity();
        result = result * 59 + ($security == null ? 43 : ((Object)$security).hashCode());
        return result;
    }

    public static class Security {
        private Boolean clientAuthEnabled;
        private static final boolean DEFAULT_CLIENT_AUTH_ENABLED = false;
        private String certificateChainPath = null;
        private String privateKeyPath = null;
        private String trustCertCollectionPath = null;
        private String authorityOverride = null;

        public boolean isClientAuthEnabled() {
            return this.clientAuthEnabled == null ? false : this.clientAuthEnabled;
        }

        public void setClientAuthEnabled(Boolean clientAuthEnabled) {
            this.clientAuthEnabled = clientAuthEnabled;
        }

        public String getCertificateChainPath() {
            return this.certificateChainPath;
        }

        public void setCertificateChainPath(String certificateChainPath) {
            this.certificateChainPath = certificateChainPath;
        }

        public String getPrivateKeyPath() {
            return this.privateKeyPath;
        }

        public void setPrivateKeyPath(String privateKeyPath) {
            this.privateKeyPath = privateKeyPath;
        }

        public String getTrustCertCollectionPath() {
            return this.trustCertCollectionPath;
        }

        public void setTrustCertCollectionPath(String trustCertCollectionPath) {
            this.trustCertCollectionPath = trustCertCollectionPath;
        }

        public String getAuthorityOverride() {
            return this.authorityOverride;
        }

        public void setAuthorityOverride(String authorityOverride) {
            this.authorityOverride = authorityOverride;
        }

        public void copyDefaultsFrom(Security config) {
            if (this == config) {
                return;
            }
            if (this.clientAuthEnabled == null) {
                this.clientAuthEnabled = config.clientAuthEnabled;
            }
            if (this.certificateChainPath == null) {
                this.certificateChainPath = config.certificateChainPath;
            }
            if (this.privateKeyPath == null) {
                this.privateKeyPath = config.privateKeyPath;
            }
            if (this.trustCertCollectionPath == null) {
                this.trustCertCollectionPath = config.trustCertCollectionPath;
            }
            if (this.authorityOverride == null) {
                this.authorityOverride = config.authorityOverride;
            }
        }

        public String toString() {
            return "GrpcChannelProperties.Security(clientAuthEnabled=" + this.clientAuthEnabled + ", certificateChainPath=" + this.getCertificateChainPath() + ", privateKeyPath=" + this.getPrivateKeyPath() + ", trustCertCollectionPath=" + this.getTrustCertCollectionPath() + ", authorityOverride=" + this.getAuthorityOverride() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Security)) {
                return false;
            }
            Security other = (Security)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$clientAuthEnabled = this.clientAuthEnabled;
            Boolean other$clientAuthEnabled = other.clientAuthEnabled;
            if (this$clientAuthEnabled == null ? other$clientAuthEnabled != null : !((Object)this$clientAuthEnabled).equals(other$clientAuthEnabled)) {
                return false;
            }
            String this$certificateChainPath = this.getCertificateChainPath();
            String other$certificateChainPath = other.getCertificateChainPath();
            if (this$certificateChainPath == null ? other$certificateChainPath != null : !this$certificateChainPath.equals(other$certificateChainPath)) {
                return false;
            }
            String this$privateKeyPath = this.getPrivateKeyPath();
            String other$privateKeyPath = other.getPrivateKeyPath();
            if (this$privateKeyPath == null ? other$privateKeyPath != null : !this$privateKeyPath.equals(other$privateKeyPath)) {
                return false;
            }
            String this$trustCertCollectionPath = this.getTrustCertCollectionPath();
            String other$trustCertCollectionPath = other.getTrustCertCollectionPath();
            if (this$trustCertCollectionPath == null ? other$trustCertCollectionPath != null : !this$trustCertCollectionPath.equals(other$trustCertCollectionPath)) {
                return false;
            }
            String this$authorityOverride = this.getAuthorityOverride();
            String other$authorityOverride = other.getAuthorityOverride();
            return !(this$authorityOverride == null ? other$authorityOverride != null : !this$authorityOverride.equals(other$authorityOverride));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Security;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $clientAuthEnabled = this.clientAuthEnabled;
            result = result * 59 + ($clientAuthEnabled == null ? 43 : ((Object)$clientAuthEnabled).hashCode());
            String $certificateChainPath = this.getCertificateChainPath();
            result = result * 59 + ($certificateChainPath == null ? 43 : $certificateChainPath.hashCode());
            String $privateKeyPath = this.getPrivateKeyPath();
            result = result * 59 + ($privateKeyPath == null ? 43 : $privateKeyPath.hashCode());
            String $trustCertCollectionPath = this.getTrustCertCollectionPath();
            result = result * 59 + ($trustCertCollectionPath == null ? 43 : $trustCertCollectionPath.hashCode());
            String $authorityOverride = this.getAuthorityOverride();
            result = result * 59 + ($authorityOverride == null ? 43 : $authorityOverride.hashCode());
            return result;
        }
    }
}

