/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.nameresolver;

import com.google.common.collect.ImmutableList;
import io.grpc.Attributes;
import io.grpc.NameResolver;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeNameResolverFactory
extends NameResolver.Factory {
    private static final Logger log = LoggerFactory.getLogger(CompositeNameResolverFactory.class);
    private final List<NameResolver.Factory> factories;
    private final String defaultScheme;

    public CompositeNameResolverFactory(String defaultScheme, List<NameResolver.Factory> factories) {
        this.factories = ImmutableList.copyOf((Collection)Objects.requireNonNull(factories, "factories"));
        this.defaultScheme = Objects.requireNonNull(defaultScheme, "defaultScheme");
    }

    @Nullable
    public NameResolver newNameResolver(URI targetUri, Attributes params) {
        log.debug("Trying to create new name resolver for: {}", (Object)targetUri);
        for (NameResolver.Factory factory : this.factories) {
            log.debug("- Attempting with: {}", (Object)factory);
            NameResolver resolver = factory.newNameResolver(targetUri, params);
            if (resolver == null) continue;
            return resolver;
        }
        log.info("Could not find name resolver for {}", (Object)targetUri);
        return null;
    }

    public String getDefaultScheme() {
        return this.defaultScheme;
    }

    public String toString() {
        return "CompositeNameResolverFactory [defaultScheme=" + this.defaultScheme + ", factories=" + this.factories + "]";
    }
}

