/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser.parser;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.dongliu.apk.parser.bean.DexClass;
import net.dongliu.apk.parser.exception.ParserException;
import net.dongliu.apk.parser.parser.StringPoolEntry;
import net.dongliu.apk.parser.struct.StringPool;
import net.dongliu.apk.parser.struct.dex.DexClassStruct;
import net.dongliu.apk.parser.struct.dex.DexHeader;
import net.dongliu.apk.parser.utils.Buffers;

public class DexParser {
    private ByteBuffer buffer;
    private ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    private static final int NO_INDEX = -1;
    private DexClass[] dexClasses;

    public DexParser(ByteBuffer buffer) {
        this.buffer = buffer.duplicate();
        this.buffer.order(this.byteOrder);
    }

    public void parse() {
        int i;
        String magic = new String(Buffers.readBytes(this.buffer, 8));
        if (!magic.startsWith("dex\n")) {
            return;
        }
        int version = Integer.parseInt(magic.substring(4, 7));
        if (version < 35) {
            throw new ParserException("Dex file version: " + version + " is not supported");
        }
        DexHeader header = this.readDexHeader();
        header.setVersion(version);
        long[] stringOffsets = this.readStringPool(header.getStringIdsOff(), header.getStringIdsSize());
        int[] typeIds = this.readTypes(header.getTypeIdsOff(), header.getTypeIdsSize());
        DexClassStruct[] dexClassStructs = this.readClass(header.getClassDefsOff(), header.getClassDefsSize());
        StringPool stringpool = this.readStrings(stringOffsets);
        String[] types = new String[typeIds.length];
        for (i = 0; i < typeIds.length; ++i) {
            types[i] = stringpool.get(typeIds[i]);
        }
        this.dexClasses = new DexClass[dexClassStructs.length];
        for (i = 0; i < this.dexClasses.length; ++i) {
            this.dexClasses[i] = new DexClass();
        }
        for (i = 0; i < dexClassStructs.length; ++i) {
            DexClassStruct dexClassStruct = dexClassStructs[i];
            DexClass dexClass = this.dexClasses[i];
            dexClass.setClassType(types[dexClassStruct.getClassIdx()]);
            if (dexClassStruct.getSuperclassIdx() != -1) {
                dexClass.setSuperClass(types[dexClassStruct.getSuperclassIdx()]);
            }
            dexClass.setAccessFlags(dexClassStruct.getAccessFlags());
        }
    }

    private DexClassStruct[] readClass(long classDefsOff, int classDefsSize) {
        this.buffer.position((int)classDefsOff);
        DexClassStruct[] dexClassStructs = new DexClassStruct[classDefsSize];
        for (int i = 0; i < classDefsSize; ++i) {
            DexClassStruct dexClassStruct = new DexClassStruct();
            dexClassStruct.setClassIdx(this.buffer.getInt());
            dexClassStruct.setAccessFlags(this.buffer.getInt());
            dexClassStruct.setSuperclassIdx(this.buffer.getInt());
            dexClassStruct.setInterfacesOff(Buffers.readUInt(this.buffer));
            dexClassStruct.setSourceFileIdx(this.buffer.getInt());
            dexClassStruct.setAnnotationsOff(Buffers.readUInt(this.buffer));
            dexClassStruct.setClassDataOff(Buffers.readUInt(this.buffer));
            dexClassStruct.setStaticValuesOff(Buffers.readUInt(this.buffer));
            dexClassStructs[i] = dexClassStruct;
        }
        return dexClassStructs;
    }

    private int[] readTypes(long typeIdsOff, int typeIdsSize) {
        this.buffer.position((int)typeIdsOff);
        int[] typeIds = new int[typeIdsSize];
        for (int i = 0; i < typeIdsSize; ++i) {
            typeIds[i] = (int)Buffers.readUInt(this.buffer);
        }
        return typeIds;
    }

    private StringPool readStrings(long[] offsets) {
        StringPoolEntry[] entries = new StringPoolEntry[offsets.length];
        for (int i = 0; i < offsets.length; ++i) {
            entries[i] = new StringPoolEntry(i, offsets[i]);
        }
        String lastStr = null;
        long lastOffset = -1L;
        StringPool stringpool = new StringPool(offsets.length);
        for (StringPoolEntry entry : entries) {
            String str;
            if (entry.getOffset() == lastOffset) {
                stringpool.set(entry.getIdx(), lastStr);
                continue;
            }
            this.buffer.position((int)entry.getOffset());
            lastOffset = entry.getOffset();
            lastStr = str = this.readString();
            stringpool.set(entry.getIdx(), str);
        }
        return stringpool;
    }

    private long[] readStringPool(long stringIdsOff, int stringIdsSize) {
        this.buffer.position((int)stringIdsOff);
        long[] offsets = new long[stringIdsSize];
        for (int i = 0; i < stringIdsSize; ++i) {
            offsets[i] = Buffers.readUInt(this.buffer);
        }
        return offsets;
    }

    private String readString() {
        int strLen = this.readVarInts();
        return this.readString(strLen);
    }

    private String readString(int strLen) {
        char[] chars = new char[strLen];
        for (int i = 0; i < strLen; ++i) {
            short b;
            short a = Buffers.readUByte(this.buffer);
            if ((a & 0x80) == 0) {
                chars[i] = (char)a;
            } else if ((a & 0xE0) == 192) {
                b = Buffers.readUByte(this.buffer);
                chars[i] = (char)((a & 0x1F) << 6 | b & 0x3F);
            } else if ((a & 0xF0) == 224) {
                b = Buffers.readUByte(this.buffer);
                short c = Buffers.readUByte(this.buffer);
                chars[i] = (char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F);
            } else if ((a & 0xF0) == 240) {
                // empty if block
            }
            if (chars[i] != '\u0000') continue;
        }
        return new String(chars);
    }

    private int readVarInts() {
        short s;
        int i = 0;
        int count = 0;
        do {
            if (count > 4) {
                throw new ParserException("read varints error.");
            }
            s = Buffers.readUByte(this.buffer);
            i |= (s & 0x7F) << count * 7;
            ++count;
        } while ((s & 0x80) != 0);
        return i;
    }

    private DexHeader readDexHeader() {
        this.buffer.getInt();
        Buffers.readBytes(this.buffer, 20);
        DexHeader header = new DexHeader();
        header.setFileSize(Buffers.readUInt(this.buffer));
        header.setHeaderSize(Buffers.readUInt(this.buffer));
        Buffers.readUInt(this.buffer);
        header.setLinkSize(Buffers.readUInt(this.buffer));
        header.setLinkOff(Buffers.readUInt(this.buffer));
        header.setMapOff(Buffers.readUInt(this.buffer));
        header.setStringIdsSize(this.buffer.getInt());
        header.setStringIdsOff(Buffers.readUInt(this.buffer));
        header.setTypeIdsSize(this.buffer.getInt());
        header.setTypeIdsOff(Buffers.readUInt(this.buffer));
        header.setProtoIdsSize(this.buffer.getInt());
        header.setProtoIdsOff(Buffers.readUInt(this.buffer));
        header.setFieldIdsSize(this.buffer.getInt());
        header.setFieldIdsOff(Buffers.readUInt(this.buffer));
        header.setMethodIdsSize(this.buffer.getInt());
        header.setMethodIdsOff(Buffers.readUInt(this.buffer));
        header.setClassDefsSize(this.buffer.getInt());
        header.setClassDefsOff(Buffers.readUInt(this.buffer));
        header.setDataSize(this.buffer.getInt());
        header.setDataOff(Buffers.readUInt(this.buffer));
        this.buffer.position((int)header.getHeaderSize());
        return header;
    }

    public DexClass[] getDexClasses() {
        return this.dexClasses;
    }
}

