/*
 * Decompiled with CFR 0.152.
 */
package net.ericaro.neoitertools;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import net.ericaro.neoitertools.Generator;
import net.ericaro.neoitertools.Index;
import net.ericaro.neoitertools.Lambda;
import net.ericaro.neoitertools.Operator;
import net.ericaro.neoitertools.Pair;
import net.ericaro.neoitertools.Yield;
import net.ericaro.neoitertools.generators.ChainGenerator;
import net.ericaro.neoitertools.generators.CharSequenceGenerator;
import net.ericaro.neoitertools.generators.CycleGenerator;
import net.ericaro.neoitertools.generators.DropWhileGenerator;
import net.ericaro.neoitertools.generators.EmptyGenerator;
import net.ericaro.neoitertools.generators.EnumerateGenerator;
import net.ericaro.neoitertools.generators.FilterGenerator;
import net.ericaro.neoitertools.generators.GeneratorIterator;
import net.ericaro.neoitertools.generators.GenericArrayGenerator;
import net.ericaro.neoitertools.generators.GroupByGenerator;
import net.ericaro.neoitertools.generators.IteratorGenerator;
import net.ericaro.neoitertools.generators.MapGenerator;
import net.ericaro.neoitertools.generators.RangeGenerator;
import net.ericaro.neoitertools.generators.RepeatGenerator;
import net.ericaro.neoitertools.generators.SliceGenerator;
import net.ericaro.neoitertools.generators.TakeWhileGenerator;
import net.ericaro.neoitertools.generators.TeeGeneratorFactory;
import net.ericaro.neoitertools.generators.YieldGenerator;
import net.ericaro.neoitertools.generators.YieldThread;
import net.ericaro.neoitertools.generators.ZipGenerator;
import net.ericaro.neoitertools.generators.ZipPairGenerator;
import net.ericaro.neoitertools.generators.combinatorics.Combinatorics;
import net.ericaro.neoitertools.generators.primitives.BooleanGenerator;
import net.ericaro.neoitertools.generators.primitives.ByteGenerator;
import net.ericaro.neoitertools.generators.primitives.CharacterGenerator;
import net.ericaro.neoitertools.generators.primitives.DoubleGenerator;
import net.ericaro.neoitertools.generators.primitives.FloatGenerator;
import net.ericaro.neoitertools.generators.primitives.IntegerGenerator;
import net.ericaro.neoitertools.generators.primitives.LongGenerator;
import net.ericaro.neoitertools.generators.primitives.ShortGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Itertools {
    public static <T> boolean all(Generator<T> generator, Lambda<? super T, Boolean> predicate) {
        try {
            while (predicate.map(generator.next()).booleanValue()) {
            }
            return false;
        }
        catch (NoSuchElementException e) {
            return true;
        }
    }

    public static <T> boolean any(Generator<T> generator, Lambda<? super T, Boolean> predicate) {
        try {
            while (!predicate.map(generator.next()).booleanValue()) {
            }
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public static <T> Generator<T> chain(Generator<Generator<T>> generators) {
        return new ChainGenerator<T>(generators);
    }

    public static <T> Generator<T> chain(Generator<T> ... generators) {
        return Itertools.chain(Itertools.iter(generators));
    }

    public static <T> Generator<List<T>> combinations(Generator<T> generator, int r) {
        List<T> list = Itertools.list(generator);
        return Combinatorics.applied(list, Combinatorics.combinations(list.size(), r));
    }

    public static Generator<Integer> count() {
        return Itertools.count(0);
    }

    public static Generator<Integer> count(int n) {
        return new RangeGenerator(n, Integer.MAX_VALUE);
    }

    public static <T> Generator<T> cycle(Generator<T> generator) {
        return new CycleGenerator<T>(generator);
    }

    public static <T> Generator<T> dropwhile(Lambda<T, Boolean> predicate, Generator<T> generator) {
        return new DropWhileGenerator<T>(predicate, generator);
    }

    public static <T> Generator<Index<T>> enumerate(Generator<T> generator) {
        return new EnumerateGenerator<T>(generator);
    }

    public static <T> Generator<T> filter(Lambda<T, Boolean> predicate, Generator<T> generator) {
        return new FilterGenerator<T>(predicate, generator);
    }

    public static <T> Generator<T> filterfalse(Lambda<T, Boolean> predicate, Generator<T> generator) {
        return new FilterGenerator<T>(predicate, generator, true);
    }

    public static <T, K> Generator<Pair<K, Generator<T>>> groupby(Generator<T> generator, Lambda<T, K> key) {
        return new GroupByGenerator<K, T>(generator, key);
    }

    public static <T> Lambda<T, T> identity() {
        return new Lambda<T, T>(){

            @Override
            public T map(T arg) {
                return arg;
            }
        };
    }

    public static <T> Iterable<T> in(final Generator<T> generator) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new GeneratorIterator(generator);
            }
        };
    }

    public static Generator<Boolean> iter(boolean[] array) {
        return new BooleanGenerator(array);
    }

    public static Generator<Byte> iter(byte[] array) {
        return new ByteGenerator(array);
    }

    public static Generator<Character> iter(char[] array) {
        return new CharacterGenerator(array);
    }

    public static Generator<Character> iter(CharSequence seq) {
        return new CharSequenceGenerator(seq);
    }

    public static Generator<Double> iter(double[] array) {
        return new DoubleGenerator(array);
    }

    public static Generator<Float> iter(float[] array) {
        return new FloatGenerator(array);
    }

    public static Generator<Integer> iter(int[] array) {
        return new IntegerGenerator(array);
    }

    public static Generator<Long> iter(long[] array) {
        return new LongGenerator(array);
    }

    public static Generator<Short> iter(short[] array) {
        return new ShortGenerator(array);
    }

    public static <T> Generator<T> iter(T[] t) {
        return new GenericArrayGenerator<T>(t);
    }

    public static <T> Generator<T> iter(Iterable<T> iterable) {
        return Itertools.iter(iterable.iterator());
    }

    public static <T> Generator<T> iter(Iterator<T> iterator) {
        return new IteratorGenerator<T>(iterator);
    }

    public static <T> Generator<T> iter(Yield<Void, T> yield) {
        return new YieldGenerator<T>(yield);
    }

    public static <T> List<T> list(Generator<T> generator) {
        LinkedList<T> list = new LinkedList<T>();
        try {
            while (true) {
                list.add(generator.next());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return list;
        }
    }

    public static <T> List<T> list(Generator<T> generator, int max) {
        LinkedList<T> list = new LinkedList<T>();
        try {
            for (int i = 0; i < max; ++i) {
                list.add(generator.next());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return list;
    }

    public static <T, K> Generator<K> map(Lambda<? super T, K> mapper, Generator<T> sequence) {
        return new MapGenerator<T, K>(mapper, sequence);
    }

    public static <T> Generator<List<T>> permutations(Generator<T> generator) {
        List<T> list = Itertools.list(generator);
        return Combinatorics.applied(list, Combinatorics.permutations(list.size()));
    }

    public static <T> Generator<List<T>> permutations(Generator<T> generator, int r) {
        List<T> list = Itertools.list(generator);
        return Combinatorics.applied(list, Combinatorics.sublists(list.size(), r));
    }

    public static <T> Generator<List<T>> product(Generator<Generator<T>> generators) {
        return Itertools.product(generators, 1);
    }

    public static <T> Generator<List<T>> product(Generator<Generator<T>> generators, int repeat) {
        if (repeat == 0) {
            return new EmptyGenerator<List<T>>();
        }
        LinkedList list = new LinkedList();
        for (Generator<T> g : Itertools.in(generators)) {
            list.add(Itertools.list(g));
        }
        int[] lengths = new int[list.size() * repeat];
        for (int i = 0; i < lengths.length; ++i) {
            lengths[i] = ((List)list.get(i % list.size())).size();
        }
        return Combinatorics.selected(list, Combinatorics.product(lengths));
    }

    public static Generator<Integer> range(int end) {
        return Itertools.range(0, end, 1);
    }

    public static Generator<Integer> range(int start, int end) {
        return Itertools.range(start, end, 1);
    }

    public static Generator<Integer> range(int start, int end, int step) throws InvalidParameterException {
        return new RangeGenerator(start, end, step);
    }

    public static <T> T reduce(Operator<T> operator, Generator<T> generator) {
        return Itertools.reduce(operator, generator, null);
    }

    public static <T> T reduce(Operator<T> operator, Generator<T> generator, T initializer) {
        try {
            if (initializer == null) {
                initializer = generator.next();
            }
        }
        catch (NoSuchElementException e) {
            return initializer;
        }
        try {
            while (true) {
                initializer = operator.operate(initializer, generator.next());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return initializer;
        }
    }

    public static <T> Generator<T> repeat(T object) {
        return new RepeatGenerator<T>(object);
    }

    public static <T> Generator<T> repeat(T object, int times) {
        return new RepeatGenerator<T>(object, times);
    }

    public static <T> Generator<T> reversed(Generator<T> generator) {
        List<T> list = Itertools.list(generator);
        Collections.reverse(list);
        return Itertools.iter(list);
    }

    public static <T> Generator<T> slice(Generator<T> generator, int stop) {
        return new SliceGenerator<T>(generator, 0, stop, 1);
    }

    public static <T> Generator<T> slice(Generator<T> generator, int start, int stop) {
        return Itertools.slice(generator, start, stop, 1);
    }

    public static <T> Generator<T> slice(Generator<T> generator, int start, int stop, int step) {
        return new SliceGenerator<T>(generator, start, stop, step);
    }

    public static <T extends Comparable<? super T>> Generator<T> sorted(Generator<T> generator) {
        List<T> list = Itertools.list(generator);
        Collections.sort(list);
        return Itertools.iter(list);
    }

    public static <T, K> Generator<T> sorted(Generator<T> generator, final Comparator<? super K> cmp, final Lambda<? super T, K> key, final boolean reverse) {
        Lambda valueToKeyValue = new Lambda<T, Pair<K, T>>(){

            @Override
            public Pair<K, T> map(T arg) {
                return new Pair(key.map(arg), arg);
            }
        };
        Lambda keyValueToValue = new Lambda<Pair<K, T>, T>(){

            @Override
            public T map(Pair<K, T> arg) {
                return arg.f1;
            }
        };
        Comparator keyComparator = new Comparator<Pair<K, T>>(){

            @Override
            public int compare(Pair<K, T> o1, Pair<K, T> o2) {
                return (reverse ? -1 : 1) * cmp.compare(o1.f0, o2.f0);
            }
        };
        List<K> list = Itertools.list(Itertools.map(valueToKeyValue, generator));
        Collections.sort(list, keyComparator);
        return Itertools.map(keyValueToValue, Itertools.iter(list));
    }

    public static <T> Generator<T> sorted(Generator<T> generator, Comparator<? super T> cmp) {
        List<T> list = Itertools.list(generator);
        Collections.sort(list, cmp);
        return Itertools.iter(list);
    }

    public static <T, K extends Comparable<? super K>> Generator<T> sorted(Generator<T> generator, Lambda<T, K> key, boolean reverse) {
        return Itertools.sorted(generator, new Comparator<K>(){

            @Override
            public int compare(K o1, K o2) {
                return o1.compareTo(o2);
            }
        }, key, reverse);
    }

    public static String string(Generator<Character> chars) {
        return Itertools.stringBuilder(chars).toString();
    }

    public static StringBuilder stringBuilder(Generator<Character> chars) {
        StringBuilder sb = new StringBuilder();
        try {
            while (true) {
                sb.append(chars.next().charValue());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return sb;
        }
    }

    public static <T> Generator<T> takewhile(Generator<T> generator, Lambda<? super T, Boolean> predicate) {
        return new TakeWhileGenerator<T>(predicate, generator);
    }

    public static <T> List<Generator<T>> tee(Generator<T> generator, int n) {
        ArrayList<Generator<T>> list = new ArrayList<Generator<T>>(n);
        TeeGeneratorFactory<T> factory = new TeeGeneratorFactory<T>(generator);
        for (int i = 0; i < n; ++i) {
            list.add(factory.newInstance());
        }
        return list;
    }

    public static <T> List<T> tuple(Generator<T> generator) {
        return Collections.unmodifiableList(Itertools.list(generator));
    }

    public static <R, T> R yield(T t) {
        YieldThread thread = (YieldThread)Thread.currentThread();
        return (R)thread.yield(t);
    }

    public static <T> Generator<List<T>> zip(Generator<Generator<T>> generators) {
        List<Generator<T>> generatorList = Itertools.list(generators);
        return new ZipGenerator<T>(generatorList);
    }

    public static <T1, T2> Generator<Pair<T1, T2>> zip(Generator<T1> generator1, Generator<T2> generator2) {
        return new ZipPairGenerator<T1, T2>(generator1, generator2);
    }
}

