/*
 * Decompiled with CFR 0.152.
 */
package net.ericaro.neoitertools.generators;

import java.util.NoSuchElementException;
import net.ericaro.neoitertools.Generator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SliceGenerator<T>
implements Generator<T> {
    private final int step;
    private final Generator<T> source;
    private final int stop;
    int i;
    T next;

    public SliceGenerator(Generator<T> sequence, int start, int stop, int step) {
        this.source = sequence;
        this.step = step;
        this.stop = stop;
        this.i = 0;
        try {
            while (this.i < start) {
                sequence.next();
                ++this.i;
            }
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
    }

    @Override
    public T next() {
        if (this.i >= this.stop) {
            throw new NoSuchElementException();
        }
        T current = this.source.next();
        int k = this.i++;
        try {
            while (this.i < k + this.step && this.i < this.stop) {
                ++this.i;
                this.next = this.source.next();
            }
        }
        catch (NoSuchElementException e) {
            this.i = this.stop;
        }
        return current;
    }
}

