/*
 * Decompiled with CFR 0.152.
 */
package net.hserver.apm.plugin.filter;

import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMethod;
import net.hserver.apm.common.entity.RequestInfo;
import top.hserver.core.interfaces.ResponseAdapter;
import top.hserver.core.ioc.annotation.Bean;
import top.hserver.core.queue.HServerQueue;
import top.hserver.core.server.context.ConstConfig;
import top.hserver.core.server.context.HServerContextHolder;
import top.hserver.core.server.context.Webkit;

@Bean
public class ApmRespFilter
implements ResponseAdapter {
    public String result(String s) {
        return s;
    }

    public FullHttpResponse response(FullHttpResponse fullHttpResponse) {
        HttpMethod requestType;
        Webkit webKit = HServerContextHolder.getWebKit();
        if (webKit != null && ((requestType = webKit.httpRequest.getRequestType()) == HttpMethod.GET || requestType == HttpMethod.POST || requestType == HttpMethod.PUT || requestType == HttpMethod.DELETE)) {
            RequestInfo requestInfo = new RequestInfo();
            requestInfo.setAppName(ConstConfig.APP_NAME);
            requestInfo.setIp(webKit.httpRequest.getIpAddress());
            requestInfo.setChainId(webKit.httpRequest.getRequestId());
            requestInfo.setHeader(webKit.httpRequest.getHeaders().toString());
            requestInfo.setMethod(webKit.httpRequest.getRequestType().name());
            if (webKit.httpRequest.getMultipartFile().size() == 0) {
                requestInfo.setRaw(webKit.httpRequest.getRawData());
            } else {
                requestInfo.setRaw("\u4e0a\u4f20\u6587\u4ef6\u6570\u636e\u4e0d\u8bb0\u5f55");
            }
            requestInfo.setParameter(webKit.httpRequest.getRequestParams().toString());
            requestInfo.setUri(webKit.httpRequest.getNettyUri());
            requestInfo.setTime(Long.valueOf(System.currentTimeMillis()));
            requestInfo.setStatusCode(Integer.valueOf(fullHttpResponse.status().code()));
            requestInfo.setMs(Integer.valueOf((int)(System.currentTimeMillis() - webKit.httpRequest.getCreateTime())));
            HServerQueue.sendQueue((String)"APM_SEND", (Object[])new Object[]{"APM-DATA-REQUEST-INFO", requestInfo});
        }
        return fullHttpResponse;
    }
}

