/*
 * Decompiled with CFR 0.152.
 */
package net.hserver.apm.plugin.task;

import java.util.Properties;
import net.hserver.apm.common.DataConfig;
import net.hserver.apm.common.entity.ServerInfo;
import top.hserver.core.ioc.annotation.Bean;
import top.hserver.core.ioc.annotation.Task;
import top.hserver.core.queue.HServerQueue;
import top.hserver.core.server.HumClient;
import top.hserver.core.server.context.ConstConfig;
import top.hserver.core.server.context.HumMessage;
import top.hserver.core.server.util.IpUtil;
import top.hserver.core.server.util.RequestIdGen;

@Bean
public class DataTask {
    public static final int TIME = 60000;
    public static Long requestNum = 0L;

    @Task(name="checkConnect", time="300000")
    public void connect() {
        HumClient.sendMessage((HumMessage)new HumMessage("APM-CONNECT", (Object)ConstConfig.APP_NAME));
    }

    @Task(name="upload", time="60000")
    public void upload() {
        if (DataConfig.hum != null && DataConfig.hum.isLive()) {
            ServerInfo serverInfo = new ServerInfo();
            serverInfo.setAppName(ConstConfig.APP_NAME);
            serverInfo.setIp(IpUtil.getLocalIP());
            long requestCount = RequestIdGen.getRequestCount();
            serverInfo.setRequestTotal(Long.valueOf(requestCount));
            serverInfo.setRequestSize(Long.valueOf(requestCount - requestNum));
            serverInfo.setThreadNum(Integer.valueOf(Thread.currentThread().getThreadGroup().getParent().activeCount()));
            serverInfo.setMemoryTotal(Integer.valueOf((int)(Runtime.getRuntime().totalMemory() / 1024L / 1024L)));
            serverInfo.setMemoryFree(Integer.valueOf((int)(Runtime.getRuntime().freeMemory() / 1024L / 1024L)));
            Properties properties = System.getProperties();
            serverInfo.setSystemName(properties.getProperty("os.name") + "-" + properties.getProperty("os.version") + "-" + properties.getProperty("os.arch"));
            serverInfo.setTime(Long.valueOf(System.currentTimeMillis()));
            HServerQueue.sendQueue((String)"APM_SEND", (Object[])new Object[]{"APM-DATA-INFO", serverInfo});
            requestNum = requestCount;
        }
    }
}

