/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.jmx;

import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import javax.management.ObjectName;
import net.java.truecommons.cio.IoBuffer;
import net.java.truevfs.comp.inst.InstrumentingBuffer;
import net.java.truevfs.comp.jmx.JmxBufferView;
import net.java.truevfs.comp.jmx.JmxComponent;
import net.java.truevfs.comp.jmx.JmxMediator;

@ThreadSafe
public class JmxBuffer<M extends JmxMediator<M>>
extends InstrumentingBuffer<M>
implements JmxComponent {
    public JmxBuffer(M mediator, IoBuffer entry) {
        super(mediator, entry);
    }

    private ObjectName objectName() {
        return ((JmxMediator)this.mediator).nameBuilder(IoBuffer.class).put("name", ObjectName.quote(this.getName())).get();
    }

    protected Object newView() {
        return new JmxBufferView<IoBuffer>((IoBuffer)this.entry);
    }

    @Override
    public void activate() {
        ((JmxMediator)this.mediator).register(this.objectName(), this.newView());
    }

    public void release() throws IOException {
        try {
            ((IoBuffer)this.entry).release();
        }
        finally {
            ((JmxMediator)this.mediator).deregister(this.objectName());
        }
    }
}

