/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.jmx;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.StandardMBean;
import net.java.truecommons.cio.Entry;
import net.java.truecommons.services.Container;
import net.java.truecommons.shed.BitField;
import net.java.truecommons.shed.Filter;
import net.java.truevfs.comp.jmx.JmxModelMXBean;
import net.java.truevfs.kernel.spec.FsAbstractNode;
import net.java.truevfs.kernel.spec.FsAccessOptions;
import net.java.truevfs.kernel.spec.FsCompositeDriver;
import net.java.truevfs.kernel.spec.FsControllerFilter;
import net.java.truevfs.kernel.spec.FsModel;
import net.java.truevfs.kernel.spec.FsMountPoint;
import net.java.truevfs.kernel.spec.FsNode;
import net.java.truevfs.kernel.spec.FsNodeName;
import net.java.truevfs.kernel.spec.FsSimpleCompositeDriver;
import net.java.truevfs.kernel.spec.FsSync;
import net.java.truevfs.kernel.spec.FsSyncException;
import net.java.truevfs.kernel.spec.FsSyncWarningException;
import net.java.truevfs.kernel.spec.sl.FsDriverMapLocator;
import net.java.truevfs.kernel.spec.sl.FsManagerLocator;

@ThreadSafe
public class JmxModelView<M extends FsModel>
extends StandardMBean
implements JmxModelMXBean {
    private static final FsCompositeDriver DRIVER = new FsSimpleCompositeDriver((Container)FsDriverMapLocator.SINGLETON);
    protected final M model;

    public JmxModelView(M model) {
        this(JmxModelMXBean.class, model);
    }

    protected JmxModelView(Class<? extends JmxModelMXBean> type, M model) {
        super(type, true);
        this.model = (FsModel)Objects.requireNonNull(model);
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        return "A file system model.";
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info) {
        switch (info.getName()) {
            case "Mounted": {
                return "Whether or not this file system is mounted.";
            }
            case "MountPoint": {
                return "The mount point URI of this file system.";
            }
            case "MountPointOfParent": {
                return "The mount point URI of the parent file system.";
            }
            case "SizeOfData": {
                return "The data size of this file system.";
            }
            case "SizeOfStorage": {
                return "The storage size of this file system.";
            }
            case "TimeCreatedDate": {
                return "The time this file system has been created.";
            }
            case "TimeCreatedMillis": {
                return "The time this file system has been created in milliseconds.";
            }
            case "TimeReadDate": {
                return "The last time this file system has been read or accessed.";
            }
            case "TimeReadMillis": {
                return "The last time this file system has been read or accessed in milliseconds.";
            }
            case "TimeWrittenDate": {
                return "The last time this file system has been written.";
            }
            case "TimeWrittenMillis": {
                return "The last time this file system has been written in milliseconds.";
            }
        }
        return null;
    }

    @Override
    protected String getDescription(MBeanOperationInfo info) {
        switch (info.getName()) {
            case "sync": {
                return "Synchronizes this file system and all enclosed file systems and eventually unmounts them.";
            }
        }
        return null;
    }

    @Override
    public boolean isMounted() {
        return this.model.isMounted();
    }

    @Override
    public String getMountPoint() {
        return this.model.getMountPoint().toString();
    }

    @Override
    public String getMountPointOfParent() {
        FsModel parent = this.model.getParent();
        return null != parent ? parent.getMountPoint().toString() : null;
    }

    @Override
    public long getSizeOfData() {
        return this.sizeOf(Entry.Size.DATA);
    }

    @Override
    public long getSizeOfStorage() {
        return this.sizeOf(Entry.Size.STORAGE);
    }

    private long sizeOf(Entry.Size type) {
        return this.node().getSize(type);
    }

    @Override
    public String getTimeCreatedDate() {
        long time = this.node().getTime(Entry.Access.CREATE);
        return -1L == time ? null : new Date(time).toString();
    }

    @Override
    public Long getTimeCreatedMillis() {
        long time = this.node().getTime(Entry.Access.CREATE);
        return -1L == time ? null : Long.valueOf(time);
    }

    @Override
    public String getTimeReadDate() {
        long time = this.node().getTime(Entry.Access.READ);
        return -1L == time ? null : new Date(time).toString();
    }

    @Override
    public Long getTimeReadMillis() {
        long time = this.node().getTime(Entry.Access.READ);
        return -1L == time ? null : Long.valueOf(time);
    }

    @Override
    public String getTimeWrittenDate() {
        long time = this.node().getTime(Entry.Access.WRITE);
        return -1L == time ? null : new Date(time).toString();
    }

    @Override
    public Long getTimeWrittenMillis() {
        long time = this.node().getTime(Entry.Access.WRITE);
        return -1L == time ? null : Long.valueOf(time);
    }

    protected FsNode node() {
        FsNode node;
        FsNodeName en;
        FsMountPoint mp;
        FsMountPoint mmp = this.model.getMountPoint();
        FsMountPoint pmp = mmp.getParent();
        if (null != pmp) {
            mp = pmp;
            en = mmp.getPath().getNodeName();
        } else {
            mp = mmp;
            en = FsNodeName.ROOT;
        }
        try {
            node = FsManagerLocator.SINGLETON.get().controller(DRIVER, mp).node(FsAccessOptions.NONE, en);
        }
        catch (IOException ex) {
            node = null;
        }
        if (null != node) {
            return node;
        }
        class DummyNode
        extends FsAbstractNode {
            DummyNode() {
            }

            public String getName() {
                return en.toString();
            }

            public BitField<Entry.Type> getTypes() {
                return Entry.NO_TYPES;
            }

            public Set<String> getMembers() {
                return Collections.emptySet();
            }

            public long getSize(Entry.Size type) {
                return -1L;
            }

            public long getTime(Entry.Access type) {
                return -1L;
            }

            @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
            public Boolean isPermitted(Entry.Access type, Entry.Entity entity) {
                return null;
            }
        }
        return new DummyNode();
    }

    @Override
    public void sync() throws FsSyncWarningException, FsSyncException {
        new FsSync().filter((Filter)FsControllerFilter.forPrefix((FsMountPoint)this.model.getMountPoint())).run();
    }
}

