/*
 * Decompiled with CFR 0.152.
 */
package net.openid.appauth.browser;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.openid.appauth.browser.BrowserDescriptor;
import net.openid.appauth.browser.BrowserMatcher;

public final class BrowserSelector {
    private static final String SCHEME_HTTP = "http";
    private static final String SCHEME_HTTPS = "https";
    @VisibleForTesting
    static final String ACTION_CUSTOM_TABS_CONNECTION = "android.support.customtabs.action.CustomTabsService";
    @VisibleForTesting
    static final Intent BROWSER_INTENT = new Intent("android.intent.action.VIEW", Uri.parse((String)"http://www.example.com"));

    @SuppressLint(value={"PackageManagerGetSignatures"})
    @NonNull
    public static List<BrowserDescriptor> getAllBrowsers(Context context) {
        ResolveInfo resolvedDefaultActivity;
        PackageManager pm = context.getPackageManager();
        ArrayList<BrowserDescriptor> browsers = new ArrayList<BrowserDescriptor>();
        String defaultBrowserPackage = null;
        int queryFlag = 64;
        if (Build.VERSION.SDK_INT >= 23) {
            queryFlag |= 0x20000;
        }
        if ((resolvedDefaultActivity = pm.resolveActivity(BROWSER_INTENT, 0)) != null) {
            defaultBrowserPackage = resolvedDefaultActivity.activityInfo.packageName;
        }
        List resolvedActivityList = pm.queryIntentActivities(BROWSER_INTENT, queryFlag);
        for (ResolveInfo info : resolvedActivityList) {
            if (!BrowserSelector.isFullBrowser(info)) continue;
            try {
                int defaultBrowserIndex = 0;
                PackageInfo packageInfo = pm.getPackageInfo(info.activityInfo.packageName, 64);
                if (BrowserSelector.hasWarmupService(pm, info.activityInfo.packageName)) {
                    BrowserDescriptor customTabBrowserDescriptor = new BrowserDescriptor(packageInfo, true);
                    if (info.activityInfo.packageName.equals(defaultBrowserPackage)) {
                        browsers.add(defaultBrowserIndex, customTabBrowserDescriptor);
                        ++defaultBrowserIndex;
                    } else {
                        browsers.add(customTabBrowserDescriptor);
                    }
                }
                BrowserDescriptor fullBrowserDescriptor = new BrowserDescriptor(packageInfo, false);
                if (info.activityInfo.packageName.equals(defaultBrowserPackage)) {
                    browsers.add(defaultBrowserIndex, fullBrowserDescriptor);
                    continue;
                }
                browsers.add(fullBrowserDescriptor);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        return browsers;
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    @Nullable
    public static BrowserDescriptor select(Context context, BrowserMatcher browserMatcher) {
        List<BrowserDescriptor> allBrowsers = BrowserSelector.getAllBrowsers(context);
        BrowserDescriptor bestMatch = null;
        for (BrowserDescriptor browser : allBrowsers) {
            if (!browserMatcher.matches(browser)) continue;
            if (browser.useCustomTab.booleanValue()) {
                return browser;
            }
            if (bestMatch != null) continue;
            bestMatch = browser;
        }
        return bestMatch;
    }

    private static boolean hasWarmupService(PackageManager pm, String packageName) {
        Intent serviceIntent = new Intent();
        serviceIntent.setAction(ACTION_CUSTOM_TABS_CONNECTION);
        serviceIntent.setPackage(packageName);
        return pm.resolveService(serviceIntent, 0) != null;
    }

    private static boolean isFullBrowser(ResolveInfo resolveInfo) {
        if (!resolveInfo.filter.hasAction("android.intent.action.VIEW") || !resolveInfo.filter.hasCategory("android.intent.category.BROWSABLE") || resolveInfo.filter.schemesIterator() == null) {
            return false;
        }
        if (resolveInfo.filter.authoritiesIterator() != null) {
            return false;
        }
        boolean supportsHttp = false;
        boolean supportsHttps = false;
        Iterator schemeIter = resolveInfo.filter.schemesIterator();
        while (schemeIter.hasNext()) {
            String scheme = (String)schemeIter.next();
            if (!(supportsHttp |= SCHEME_HTTP.equals(scheme)) || !(supportsHttps |= SCHEME_HTTPS.equals(scheme))) continue;
            return true;
        }
        return false;
    }
}

