/*
 * Decompiled with CFR 0.152.
 */
package net.vsame.url2sql.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import net.vsame.url2sql.helper.Url2SqlContext;
import net.vsame.url2sql.helper.WebHelper;
import net.vsame.url2sql.url.impl.UrlConfig;
import net.vsame.url2sql.url.impl.UrlMapping;

public abstract class CacheHelper {
    private static ConcurrentHashMap<String, UrlConfig[]> cleanUrlConfigMap = new ConcurrentHashMap();

    public abstract String getSessionId();

    public abstract void saveCache(String var1, String var2, Long var3);

    public abstract String readCache(String var1);

    public abstract void delCacheBefore(List<String> var1);

    public String getCacheName() {
        return "redis";
    }

    public String getCleanCacheKey(UrlConfig urlConfig) {
        EnumCacheType type = urlConfig.getCacheType();
        if (type == EnumCacheType.NONE) {
            return null;
        }
        String userStr = "?" + type.toString();
        if (type == EnumCacheType.USER) {
            userStr = userStr + "=" + this.getSessionId();
        }
        return urlConfig.getUrl().substring(1) + userStr;
    }

    public String getCacheKey() {
        Url2SqlContext context = WebHelper.getContext();
        String cleanKey = this.getCleanCacheKey(context.getUrlConfig());
        if (cleanKey == null) {
            return null;
        }
        return cleanKey + "&" + CacheHelper.dictSort(context.getParams());
    }

    private static String dictSort(Map<String, String[]> params) {
        ArrayList<String> list = new ArrayList<String>(params.size() * 3 / 2);
        for (Map.Entry<String, String[]> e : params.entrySet()) {
            if (e.getKey().startsWith("application.") || e.getKey().startsWith("actionScope.")) continue;
            for (String str : e.getValue()) {
                list.add(e.getKey() + "=" + CacheHelper.encodeUrl(str));
            }
        }
        String[] array = list.toArray(new String[0]);
        Arrays.sort(array, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        StringBuffer sb = new StringBuffer();
        for (String str : array) {
            sb.append(str).append("&");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private static String encodeUrl(String input) {
        try {
            return URLEncoder.encode(input, "UTF-8").replace("+", "%20").replace("*", "%2A");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void setCache(String cacheKey) {
        Url2SqlContext context = WebHelper.getContext();
        UrlConfig urlConfig = context.getUrlConfig();
        EnumCacheType type = urlConfig.getCacheType();
        if (type == EnumCacheType.NONE) {
            return;
        }
        Map<String, Object> datas = WebHelper.getContext().getDatas();
        HashMap<String, Object> map = new HashMap<String, Object>(datas.size());
        map.putAll(datas);
        map.put("$cacheTime", System.currentTimeMillis());
        String json = JSON.toJSONString(map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat, SerializerFeature.DisableCircularReferenceDetect});
        this.saveCache(cacheKey, json, urlConfig.getCacheTime());
    }

    public JSONObject getCache(String cacheKey) {
        String json = this.readCache(cacheKey);
        if (json == null) {
            return null;
        }
        return JSON.parseObject((String)json);
    }

    public void cleanCache() {
        Url2SqlContext context = WebHelper.getContext();
        UrlConfig urlConfig = context.getUrlConfig();
        List<String> list = urlConfig.getCleanPathCaches();
        if (list == null || list.size() == 0) {
            return;
        }
        UrlConfig[] matchesConfig = this.matchesUrlConfig(urlConfig.getUrl(), list);
        if (matchesConfig.length == 0) {
            return;
        }
        ArrayList<String> cleanPaths = new ArrayList<String>();
        for (UrlConfig uc : matchesConfig) {
            cleanPaths.add(this.getCleanCacheKey(uc));
        }
        this.delCacheBefore(cleanPaths);
    }

    private UrlConfig[] matchesUrlConfig(String path, List<String> list) {
        UrlConfig[] array = cleanUrlConfigMap.get(path);
        if (array != null) {
            return array;
        }
        Map<String, UrlConfig> map = UrlMapping.getMapping().getUrlSqlMap();
        ArrayList<UrlConfig> retList = new ArrayList<UrlConfig>();
        for (String regex : list) {
            Pattern pattern = Pattern.compile(regex);
            for (Map.Entry<String, UrlConfig> e : map.entrySet()) {
                UrlConfig uc = e.getValue();
                if (uc.getCacheType() == EnumCacheType.NONE || !pattern.matcher(uc.getUrl().substring(1)).matches()) continue;
                retList.add(uc);
            }
        }
        array = retList.toArray(new UrlConfig[0]);
        cleanUrlConfigMap.put(path, array);
        return array;
    }

    public static enum EnumCacheType {
        USER,
        GLOBAL,
        NONE;

    }
}

