/*
 * Decompiled with CFR 0.152.
 */
package net.vsame.url2sql.url.impl;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.vsame.url2sql.helper.CacheHelper;

public class UrlConfig {
    private String url;
    private Method method;
    private String js;
    private Map<String, String> vars = new LinkedHashMap<String, String>();
    private String v;
    private CacheHelper.EnumCacheType cacheType = CacheHelper.EnumCacheType.NONE;
    private Long cacheTime;
    private List<String> cleanPathCaches;
    private String status;
    private String desc;

    public static Method string2Method(String method) {
        int index = method.lastIndexOf(".");
        String className = method.substring(0, index);
        String methodName = method.substring(index + 1);
        try {
            Class<?> clazz = Class.forName(className);
            return clazz.getMethod(methodName, new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        this.url = url;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setMethod(String method) {
        this.method = UrlConfig.string2Method(method);
    }

    public String getJs() {
        return this.js;
    }

    public void setJs(String js) {
        this.js = js;
    }

    public Map<String, String> getVars() {
        return this.vars;
    }

    public String getVar(String key) {
        String retVal = this.vars.get(key);
        if (retVal == null) {
            throw new RuntimeException(key + " is null");
        }
        return retVal;
    }

    public void setVars(Map<String, String> vars) {
        this.vars = vars;
    }

    public String getV() {
        return this.v;
    }

    public void setV(String v) {
        this.v = v;
    }

    public CacheHelper.EnumCacheType getCacheType() {
        return this.cacheType;
    }

    public void setCacheType(CacheHelper.EnumCacheType cacheType) {
        if (cacheType == null) {
            cacheType = CacheHelper.EnumCacheType.NONE;
        }
        this.cacheType = cacheType;
    }

    public Long getCacheTime() {
        return this.cacheTime;
    }

    public void setCacheTime(Long cacheTime) {
        this.cacheTime = cacheTime;
    }

    public List<String> getCleanPathCaches() {
        return this.cleanPathCaches;
    }

    public void setCleanPathCaches(List<String> cleanPathCaches) {
        this.cleanPathCaches = cleanPathCaches;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = null;
        if (status == null) {
            return;
        }
        if ("".equals(status = status.trim())) {
            return;
        }
        this.status = "false".equals(status) ? "disabled!" : status;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static void main(String[] args) throws Exception {
        Method method = UrlConfig.class.getMethod("getV", new Class[0]);
        System.out.println(method.getDeclaringClass());
        UrlConfig u = new UrlConfig();
        u.setMethod("net.vsame.url2sql.url.UrlConfig.getV");
        System.out.println(u.getMethod());
    }

    public String toString() {
        return "UrlConfig [url=" + this.url + ", method=" + this.method + ", js=" + this.js + ", vars=" + this.vars + ", v=" + this.v + ", cacheScript=" + (Object)((Object)this.cacheType) + ", cleanCache=" + this.cleanPathCaches + ", status=" + this.status + ", desc=" + this.desc + "]";
    }
}

