/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.function.Supplier;
import org.apache.activemq.artemis.core.server.impl.jdbc.JdbcLeaseLock;
import org.apache.activemq.artemis.core.server.impl.jdbc.LeaseLock;
import org.apache.activemq.artemis.core.server.impl.jdbc.SharedStateManager;
import org.apache.activemq.artemis.jdbc.store.drivers.AbstractJDBCDriver;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCConnectionProvider;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.apache.activemq.artemis.utils.UUID;
import org.jboss.logging.Logger;

final class JdbcSharedStateManager
extends AbstractJDBCDriver
implements SharedStateManager {
    private static final Logger logger = Logger.getLogger(JdbcSharedStateManager.class);
    private static final int MAX_SETUP_ATTEMPTS = 20;
    private final String holderId;
    private final long lockExpirationMillis;
    private final long queryTimeoutMillis;
    private JdbcLeaseLock liveLock;
    private JdbcLeaseLock backupLock;
    private String readNodeId;
    private String writeNodeId;
    private String initializeNodeId;
    private String readState;
    private String writeState;

    public static JdbcSharedStateManager usingConnectionProvider(String holderId, long locksExpirationMillis, JDBCConnectionProvider connectionProvider, SQLProvider provider) {
        return JdbcSharedStateManager.usingConnectionProvider(holderId, locksExpirationMillis, -1L, connectionProvider, provider);
    }

    public static JdbcSharedStateManager usingConnectionProvider(String holderId, long locksExpirationMillis, long queryTimeoutMillis, JDBCConnectionProvider connectionProvider, SQLProvider provider) {
        JdbcSharedStateManager sharedStateManager = new JdbcSharedStateManager(holderId, locksExpirationMillis, queryTimeoutMillis);
        sharedStateManager.setJdbcConnectionProvider(connectionProvider);
        sharedStateManager.setSqlProvider(provider);
        try {
            sharedStateManager.start();
            return sharedStateManager;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void createSchema() {
        try {
            this.createTable(new String[]{this.sqlProvider.createNodeManagerStoreTableSQL(), this.sqlProvider.createNodeIdSQL(), this.sqlProvider.createStateSQL(), this.sqlProvider.createLiveLockSQL(), this.sqlProvider.createBackupLockSQL()});
        }
        catch (SQLException e) {
            logger.debug((Object)"Error while creating the schema of the JDBC shared state manager", (Throwable)e);
        }
    }

    static JdbcLeaseLock createLiveLock(String holderId, JDBCConnectionProvider connectionProvider, SQLProvider sqlProvider, long expirationMillis) {
        return JdbcSharedStateManager.createLiveLock(holderId, connectionProvider, sqlProvider, expirationMillis, -1L);
    }

    static JdbcLeaseLock createLiveLock(String holderId, JDBCConnectionProvider connectionProvider, SQLProvider sqlProvider, long expirationMillis, long queryTimeoutMillis) {
        return new JdbcLeaseLock(holderId, connectionProvider, sqlProvider.tryAcquireLiveLockSQL(), sqlProvider.tryReleaseLiveLockSQL(), sqlProvider.renewLiveLockSQL(), sqlProvider.isLiveLockedSQL(), sqlProvider.currentTimestampSQL(), expirationMillis, queryTimeoutMillis, "LIVE");
    }

    static JdbcLeaseLock createBackupLock(String holderId, JDBCConnectionProvider connectionProvider, SQLProvider sqlProvider, long expirationMillis, long queryTimeoutMillis) {
        return new JdbcLeaseLock(holderId, connectionProvider, sqlProvider.tryAcquireBackupLockSQL(), sqlProvider.tryReleaseBackupLockSQL(), sqlProvider.renewBackupLockSQL(), sqlProvider.isBackupLockedSQL(), sqlProvider.currentTimestampSQL(), expirationMillis, queryTimeoutMillis, "BACKUP");
    }

    protected void prepareStatements() {
        this.liveLock = JdbcSharedStateManager.createLiveLock(this.holderId, this.connectionProvider, this.sqlProvider, this.lockExpirationMillis, this.queryTimeoutMillis);
        this.backupLock = JdbcSharedStateManager.createBackupLock(this.holderId, this.connectionProvider, this.sqlProvider, this.lockExpirationMillis, this.queryTimeoutMillis);
        this.readNodeId = this.sqlProvider.readNodeIdSQL();
        this.writeNodeId = this.sqlProvider.writeNodeIdSQL();
        this.initializeNodeId = this.sqlProvider.initializeNodeIdSQL();
        this.writeState = this.sqlProvider.writeStateSQL();
        this.readState = this.sqlProvider.readStateSQL();
    }

    private JdbcSharedStateManager(String holderId, long lockExpirationMillis, long queryTimeoutMillis) {
        this.holderId = holderId;
        this.lockExpirationMillis = lockExpirationMillis;
        this.queryTimeoutMillis = queryTimeoutMillis;
    }

    @Override
    public LeaseLock liveLock() {
        return this.liveLock;
    }

    @Override
    public LeaseLock backupLock() {
        return this.backupLock;
    }

    /*
     * Exception decompiling
     */
    private UUID rawReadNodeId(Connection connection) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 37[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public UUID readNodeId() {
        try {
            Throwable throwable = null;
            try (Connection connection = this.connectionProvider.getConnection();){
                UUID uUID;
                connection.setTransactionIsolation(2);
                boolean autoCommit = connection.getAutoCommit();
                connection.setAutoCommit(true);
                try {
                    uUID = this.rawReadNodeId(connection);
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            connection.setAutoCommit(autoCommit);
                            throw throwable2;
                        }
                        catch (SQLException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                connection.setAutoCommit(autoCommit);
                return uUID;
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeNodeId(UUID nodeId) {
        try (Connection connection = this.connectionProvider.getConnection();){
            try {
                connection.setTransactionIsolation(2);
                boolean autoCommit = connection.getAutoCommit();
                connection.setAutoCommit(true);
                try {
                    this.rawWriteNodeId(connection, nodeId);
                }
                finally {
                    connection.setAutoCommit(autoCommit);
                }
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    private void rawWriteNodeId(Connection connection, UUID nodeId) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.writeNodeId);){
            preparedStatement.setString(1, nodeId.toString());
            if (preparedStatement.executeUpdate() != 1) {
                throw new IllegalStateException("can't write NodeId on the JDBC Node Manager Store!");
            }
        }
    }

    private boolean rawInitializeNodeId(Connection connection, UUID nodeId) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.initializeNodeId);){
            preparedStatement.setString(1, nodeId.toString());
            int rows = preparedStatement.executeUpdate();
            assert (rows <= 1);
            boolean bl = rows > 0;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public UUID setup(Supplier<? extends UUID> nodeIdFactory) {
        SQLException lastError = null;
        try (Connection connection = this.connectionProvider.getConnection();){
            UUID newNodeId = nodeIdFactory.get();
            for (int attempts = 0; attempts < 20; ++attempts) {
                lastError = null;
                try {
                    UUID nodeId = this.initializeOrReadNodeId(connection, newNodeId);
                    if (nodeId == null) continue;
                    UUID uUID = nodeId;
                    return uUID;
                }
                catch (SQLException e) {
                    logger.debug((Object)"Error while attempting to setup the NodeId", (Throwable)e);
                    lastError = e;
                }
            }
        }
        catch (SQLException e) {
            lastError = e;
        }
        if (lastError != null) {
            logger.error((Object)"Unable to setup a NodeId on the JDBC shared state", (Throwable)lastError);
            throw new IllegalStateException("FAILED TO SETUP the JDBC Shared State NodeId");
        }
        logger.error((Object)"Unable to setup a NodeId on the JDBC shared state");
        throw new IllegalStateException("FAILED TO SETUP the JDBC Shared State NodeId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UUID initializeOrReadNodeId(Connection connection, UUID newNodeId) throws SQLException {
        Connection connection2 = connection;
        synchronized (connection2) {
            connection.setTransactionIsolation(8);
            boolean autoCommit = connection.getAutoCommit();
            connection.setAutoCommit(false);
            try {
                UUID nodeId = this.rawInitializeNodeId(connection, newNodeId) ? newNodeId : this.rawReadNodeId(connection);
                if (nodeId != null) {
                    connection.commit();
                    UUID uUID = nodeId;
                    return uUID;
                }
                connection.rollback();
                logger.debugf("Rollback after failed to update NodeId to %s and haven't found any NodeId", (Object)newNodeId);
                UUID uUID = null;
                return uUID;
            }
            catch (SQLException e) {
                connection.rollback();
                logger.debugf((Throwable)e, "Rollback while trying to update NodeId to %s", (Object)newNodeId);
                UUID uUID2 = null;
                return uUID2;
            }
            finally {
                connection.setAutoCommit(autoCommit);
            }
        }
    }

    private static SharedStateManager.State decodeState(String s) {
        if (s == null) {
            return SharedStateManager.State.NOT_STARTED;
        }
        switch (s) {
            case "L": {
                return SharedStateManager.State.LIVE;
            }
            case "F": {
                return SharedStateManager.State.FAILING_BACK;
            }
            case "P": {
                return SharedStateManager.State.PAUSED;
            }
            case "N": {
                return SharedStateManager.State.NOT_STARTED;
            }
        }
        throw new IllegalStateException("unknown state [" + s + "]");
    }

    private static String encodeState(SharedStateManager.State state) {
        switch (state) {
            case LIVE: {
                return "L";
            }
            case FAILING_BACK: {
                return "F";
            }
            case PAUSED: {
                return "P";
            }
            case NOT_STARTED: {
                return "N";
            }
        }
        throw new IllegalStateException("unknown state [" + (Object)((Object)state) + "]");
    }

    /*
     * Exception decompiling
     */
    @Override
    public SharedStateManager.State readState() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void writeState(SharedStateManager.State state) {
        String encodedState = JdbcSharedStateManager.encodeState(state);
        try (Connection connection = this.connectionProvider.getConnection();){
            connection.setTransactionIsolation(2);
            boolean autoCommit = connection.getAutoCommit();
            connection.setAutoCommit(false);
            try (PreparedStatement preparedStatement = connection.prepareStatement(this.writeState);){
                preparedStatement.setString(1, encodedState);
                if (preparedStatement.executeUpdate() != 1) {
                    throw new IllegalStateException("can't write state to the JDBC Node Manager Store!");
                }
                connection.commit();
            }
            catch (SQLException ie) {
                connection.rollback();
                connection.setAutoCommit(true);
                throw new IllegalStateException(ie);
            }
            finally {
                connection.setAutoCommit(autoCommit);
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public void stop() throws SQLException {
        this.liveLock.close();
        this.backupLock.close();
        super.stop();
    }

    @Override
    public void close() throws SQLException {
        this.stop();
    }
}

