/** This class is auto generated by org.apache.activemq.artemis.logs.annotation.processor.LogAnnotationProcessor
    and it inherits whatever license is declared at org.apache.activemq.artemis.core.server.ActiveMQServerLogger */

package org.apache.activemq.artemis.core.server;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

// @org.apache.activemq.artemis.logs.annotation.LogBundle(regexID="22[0-9]{4}", projectCode="AMQ")
public class ActiveMQServerLogger_impl implements ActiveMQServerLogger
{
   private final Logger logger;

   private static void _copyStackTraceMinusOne(final Throwable e) {
      final StackTraceElement[] st = e.getStackTrace();
      e.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
   }

   public ActiveMQServerLogger_impl(Logger logger ) {
      this.logger = logger;
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=223000, value=\"Received Interrupt Exception whilst waiting for component to shutdown: {}\", level=DEBUG)
   @Override
   public void interruptWhilstStoppingComponent(java.lang.String componentClassName) {
      if (logger.isDebugEnabled()) {
         logger.debug("AMQ223000: Received Interrupt Exception whilst waiting for component to shutdown: {}", componentClassName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=223001, value=\"Ignored quorum vote due to quorum reached or vote casted: {}\", level=DEBUG)
   @Override
   public void ignoredQuorumVote(org.apache.activemq.artemis.core.server.cluster.qourum.ServerConnectVote vote) {
      if (logger.isDebugEnabled()) {
         logger.debug("AMQ223001: Ignored quorum vote due to quorum reached or vote casted: {}", vote);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221000, value=\"{} Message Broker is starting with configuration {}\", level=INFO)
   @Override
   public void serverStarting(java.lang.String type, org.apache.activemq.artemis.core.config.Configuration configuration) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221000: {} Message Broker is starting with configuration {}", type, configuration);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221001, value=\"Apache ActiveMQ Artemis Message Broker version {} [{}, nodeID={}] {}\", level=INFO)
   @Override
   public void serverStarted(java.lang.String fullVersion, java.lang.String name, org.apache.activemq.artemis.api.core.SimpleString nodeId, java.lang.String identity) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221001: Apache ActiveMQ Artemis Message Broker version {} [{}, nodeID={}] {}", fullVersion, name, nodeId, identity);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221002, value=\"Apache ActiveMQ Artemis Message Broker version {} [{}] stopped, uptime {}\", level=INFO)
   @Override
   public void serverStopped(java.lang.String version, org.apache.activemq.artemis.api.core.SimpleString nodeId, java.lang.String uptime) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221002: Apache ActiveMQ Artemis Message Broker version {} [{}] stopped, uptime {}", version, nodeId, uptime);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221003, value=\"Deploying {} queue {} on address {}\", level=INFO)
   @Override
   public void deployQueue(java.lang.String routingType, java.lang.String queueName, java.lang.String addressName) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221003: Deploying {} queue {} on address {}", routingType, queueName, addressName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221004, value=\"{}\", level=INFO)
   @Override
   public void dumpServerInfo(java.lang.String serverInfo) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221004: {}", serverInfo);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221005, value=\"Deleting pending large message as it was not completed: {}\", level=INFO)
   @Override
   public void deletingPendingMessage(org.apache.activemq.artemis.api.core.Pair<java.lang.Long,java.lang.Long> msgToDelete) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221005: Deleting pending large message as it was not completed: {}", msgToDelete);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221006, value=\"Waiting to obtain live lock\", level=INFO)
   @Override
   public void awaitingLiveLock() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221006: Waiting to obtain live lock");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221007, value=\"Server is now live\", level=INFO)
   @Override
   public void serverIsLive() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221007: Server is now live");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221008, value=\"live server wants to restart, restarting server in backup\", level=INFO)
   @Override
   public void awaitFailBack() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221008: live server wants to restart, restarting server in backup");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221109, value=\"Apache ActiveMQ Artemis Backup Server version {} [{}] started, waiting live to fail before it gets active\", level=INFO)
   @Override
   public void backupServerStarted(java.lang.String version, org.apache.activemq.artemis.api.core.SimpleString nodeID) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221109: Apache ActiveMQ Artemis Backup Server version {} [{}] started, waiting live to fail before it gets active", version, nodeID);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221010, value=\"Backup Server is now live\", level=INFO)
   @Override
   public void backupServerIsLive() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221010: Backup Server is now live");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221011, value=\"Server {} is now live\", level=INFO)
   @Override
   public void serverIsLive(java.lang.String identity) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221011: Server {} is now live", identity);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221012, value=\"Using AIO Journal\", level=INFO)
   @Override
   public void journalUseAIO() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221012: Using AIO Journal");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221013, value=\"Using NIO Journal\", level=INFO)
   @Override
   public void journalUseNIO() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221013: Using NIO Journal");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221014, value=\"{}% loaded\", level=INFO)
   @Override
   public void percentLoaded(java.lang.Long percent) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221014: {}% loaded", percent);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221015, value=\"Can not find queue {} while reloading ACKNOWLEDGE_CURSOR, deleting record now\", level=INFO)
   @Override
   public void journalCannotFindQueueReloading(java.lang.Long queueID) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221015: Can not find queue {} while reloading ACKNOWLEDGE_CURSOR, deleting record now", queueID);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221016, value=\"Can not find queue {} while reloading PAGE_CURSOR_COUNTER_VALUE, deleting record now\", level=INFO)
   @Override
   public void journalCannotFindQueueReloadingPage(java.lang.Long queueID) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221016: Can not find queue {} while reloading PAGE_CURSOR_COUNTER_VALUE, deleting record now", queueID);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221017, value=\"Can not find queue {} while reloading PAGE_CURSOR_COUNTER_INC, deleting record now\", level=INFO)
   @Override
   public void journalCannotFindQueueReloadingPageCursor(java.lang.Long queueID) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221017: Can not find queue {} while reloading PAGE_CURSOR_COUNTER_INC, deleting record now", queueID);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221018, value=\"Large message: {} did not have any associated reference, file will be deleted\", level=INFO)
   @Override
   public void largeMessageWithNoRef(java.lang.Long messageID) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221018: Large message: {} did not have any associated reference, file will be deleted", messageID);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221019, value=\"Deleting unreferenced message id={} from the journal\", level=INFO)
   @Override
   public void journalUnreferencedMessage(java.lang.Long messageID) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221019: Deleting unreferenced message id={} from the journal", messageID);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221020, value=\"Started {} Acceptor at {}:{} for protocols [{}]\", level=INFO)
   @Override
   public void startedAcceptor(java.lang.String acceptorType, java.lang.String host, int port, java.lang.String enabledProtocols) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221020: Started {} Acceptor at {}:{} for protocols [{}]", acceptorType, host, port, enabledProtocols);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221021, value=\"failed to remove connection\", level=INFO)
   @Override
   public void errorRemovingConnection() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221021: failed to remove connection");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221022, value=\"unable to start connector service: {}\", level=INFO)
   @Override
   public void errorStartingConnectorService(java.lang.String name, java.lang.Throwable e) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221022: unable to start connector service: {}", name, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221023, value=\"unable to stop connector service: {}\", level=INFO)
   @Override
   public void errorStoppingConnectorService(java.lang.String name, java.lang.Throwable e) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221023: unable to stop connector service: {}", name, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221024, value=\"Backup server {} is synchronized with live server, nodeID={}.\", level=INFO)
   @Override
   public void backupServerSynchronized(org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl server, java.lang.String liveID) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221024: Backup server {} is synchronized with live server, nodeID={}.", server, liveID);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221025, value=\"Replication: sending {} (size={}) to replica.\", level=INFO)
   @Override
   public void replicaSyncFile(org.apache.activemq.artemis.core.io.SequentialFile jf, java.lang.Long size) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221025: Replication: sending {} (size={}) to replica.", jf, size);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221026, value=\"Bridge {} connected to forwardingAddress={}. {} does not have any bindings. Messages will be ignored until a binding is created.\", level=INFO)
   @Override
   public void bridgeNoBindings(org.apache.activemq.artemis.api.core.SimpleString name, org.apache.activemq.artemis.api.core.SimpleString forwardingAddress, org.apache.activemq.artemis.api.core.SimpleString address) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221026: Bridge {} connected to forwardingAddress={}. {} does not have any bindings. Messages will be ignored until a binding is created.", name, forwardingAddress, address);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221027, value=\"Bridge {} is connected\", level=INFO)
   @Override
   public void bridgeConnected(org.apache.activemq.artemis.core.server.cluster.impl.BridgeImpl name) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221027: Bridge {} is connected", name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221028, value=\"Bridge is stopping, will not retry\", level=INFO)
   @Override
   public void bridgeStopping() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221028: Bridge is stopping, will not retry");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221029, value=\"stopped bridge {}\", level=INFO)
   @Override
   public void bridgeStopped(java.lang.String name) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221029: stopped bridge {}", name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221030, value=\"paused bridge {}\", level=INFO)
   @Override
   public void bridgePaused(java.lang.String name) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221030: paused bridge {}", name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221031, value=\"backup announced\", level=INFO)
   @Override
   public void backupAnnounced() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221031: backup announced");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221032, value=\"Waiting to become backup node\", level=INFO)
   @Override
   public void waitingToBecomeBackup() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221032: Waiting to become backup node");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221033, value=\"** got backup lock\", level=INFO)
   @Override
   public void gotBackupLock() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221033: ** got backup lock");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221034, value=\"Waiting {} to obtain live lock\", level=INFO)
   @Override
   public void waitingToObtainLiveLock(java.lang.String timeoutMessage) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221034: Waiting {} to obtain live lock", timeoutMessage);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221035, value=\"Live Server Obtained live lock\", level=INFO)
   @Override
   public void obtainedLiveLock() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221035: Live Server Obtained live lock");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221036, value=\"Message with duplicate ID {} was already set at {}. Move from {} being ignored and message removed from {}\", level=INFO)
   @Override
   public void messageWithDuplicateID(java.lang.Object duplicateProperty, org.apache.activemq.artemis.api.core.SimpleString toAddress, org.apache.activemq.artemis.api.core.SimpleString address, org.apache.activemq.artemis.api.core.SimpleString simpleString) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221036: Message with duplicate ID {} was already set at {}. Move from {} being ignored and message removed from {}", duplicateProperty, toAddress, address, simpleString);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221037, value=\"{} to become 'live'\", level=INFO)
   @Override
   public void becomingLive(org.apache.activemq.artemis.core.server.ActiveMQServer server) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221037: {} to become 'live'", server);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221038, value=\"Configuration option '{}' is deprecated. Consult the manual for details.\", level=INFO)
   @Override
   public void deprecatedConfigurationOption(java.lang.String deprecatedOption) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221038: Configuration option '{}' is deprecated. Consult the manual for details.", deprecatedOption);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221039, value=\"Restarting as Replicating backup server after live restart\", level=INFO)
   @Override
   public void restartingReplicatedBackupAfterFailback() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221039: Restarting as Replicating backup server after live restart");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221040, value=\"Remote group coordinators has not started.\", level=INFO)
   @Override
   public void remoteGroupCoordinatorsNotStarted() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221040: Remote group coordinators has not started.");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221041, value=\"Cannot find queue {} while reloading PAGE_CURSOR_COMPLETE, deleting record now\", level=INFO)
   @Override
   public void cantFindQueueOnPageComplete(long queueID) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221041: Cannot find queue {} while reloading PAGE_CURSOR_COMPLETE, deleting record now", queueID);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221042, value=\"Bridge {} timed out waiting for the completion of {} messages, we will just shutdown the bridge after 10 seconds wait\", level=INFO)
   @Override
   public void timedOutWaitingCompletions(java.lang.String bridgeName, long numberOfMessages) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221042: Bridge {} timed out waiting for the completion of {} messages, we will just shutdown the bridge after 10 seconds wait", bridgeName, numberOfMessages);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221043, value=\"Protocol module found: [{}]. Adding protocol support for: {}\", level=INFO)
   @Override
   public void addingProtocolSupport(java.lang.String moduleName, java.lang.String protocolKey) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221043: Protocol module found: [{}]. Adding protocol support for: {}", moduleName, protocolKey);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221045, value=\"libaio is not available, switching the configuration into NIO\", level=INFO)
   @Override
   public void switchingNIO() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221045: libaio is not available, switching the configuration into NIO");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221046, value=\"Unblocking message production on address '{}'; {}\", level=INFO)
   @Override
   public void unblockingMessageProduction(org.apache.activemq.artemis.api.core.SimpleString addressName, java.lang.String sizeInfo) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221046: Unblocking message production on address '{}'; {}", addressName, sizeInfo);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221047, value=\"Backup Server has scaled down to live server\", level=INFO)
   @Override
   public void backupServerScaledDown() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221047: Backup Server has scaled down to live server");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221048, value=\"Consumer {}:{} attached to queue '{}' from {} identified as 'slow.' Expected consumption rate: {} msgs/second; actual consumption rate: {} msgs/second.\", level=INFO)
   @Override
   public void slowConsumerDetected(java.lang.String sessionID, long consumerID, java.lang.String queueName, java.lang.String remoteAddress, float slowConsumerThreshold, float consumerRate) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221048: Consumer {}:{} attached to queue '{}' from {} identified as 'slow.' Expected consumption rate: {} msgs/second; actual consumption rate: {} msgs/second.", sessionID, consumerID, queueName, remoteAddress, slowConsumerThreshold, consumerRate);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221049, value=\"Activating Replica for node: {}\", level=INFO)
   @Override
   public void activatingReplica(org.apache.activemq.artemis.api.core.SimpleString nodeID) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221049: Activating Replica for node: {}", nodeID);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221050, value=\"Activating Shared Store Slave\", level=INFO)
   @Override
   public void activatingSharedStoreSlave() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221050: Activating Shared Store Slave");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221051, value=\"Populating security roles from LDAP at: {}\", level=INFO)
   @Override
   public void populatingSecurityRolesFromLDAP(java.lang.String url) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221051: Populating security roles from LDAP at: {}", url);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221052, value=\"Deploying topic {}\", level=INFO)
   @Override
   public void deployTopic(org.apache.activemq.artemis.api.core.SimpleString topicName) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221052: Deploying topic {}", topicName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221053, value=\"Disallowing use of vulnerable protocol '{}' on acceptor '{}'. See http://www.oracle.com/technetwork/topics/security/poodlecve-2014-3566-2339408.html for more details.\", level=INFO)
   @Override
   public void disallowedProtocol(java.lang.String protocol, java.lang.String acceptorName) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221053: Disallowing use of vulnerable protocol '{}' on acceptor '{}'. See http://www.oracle.com/technetwork/topics/security/poodlecve-2014-3566-2339408.html for more details.", protocol, acceptorName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221054, value=\"libaio was found but the filesystem does not support AIO. Switching the configuration into NIO. Journal path: {}\", level=INFO)
   @Override
   public void switchingNIOonPath(java.lang.String journalPath) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221054: libaio was found but the filesystem does not support AIO. Switching the configuration into NIO. Journal path: {}", journalPath);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221055, value=\"There were too many old replicated folders upon startup, removing {}\", level=INFO)
   @Override
   public void removingBackupData(java.lang.String path) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221055: There were too many old replicated folders upon startup, removing {}", path);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221056, value=\"Reloading configuration: {}\", level=INFO)
   @Override
   public void reloadingConfiguration(java.lang.String module) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221056: Reloading configuration: {}", module);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221057, value=\"Global Max Size is being adjusted to 1/2 of the JVM max size (-Xmx). being defined as {}\", level=INFO)
   @Override
   public void usingDefaultPaging(long bytes) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221057: Global Max Size is being adjusted to 1/2 of the JVM max size (-Xmx). being defined as {}", bytes);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221058, value=\"resetting Journal File size from {} to {} to fit with alignment of {}\", level=INFO)
   @Override
   public void invalidJournalFileSize(int journalFileSize, int fileSize, int alignment) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221058: resetting Journal File size from {} to {} to fit with alignment of {}", journalFileSize, fileSize, alignment);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221059, value=\"Deleting old data directory {} as the max folders is set to 0\", level=INFO)
   @Override
   public void backupDeletingData(java.lang.String oldPath) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221059: Deleting old data directory {} as the max folders is set to 0", oldPath);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221060, value=\"Sending quorum vote request to {}: {}\", level=INFO)
   @Override
   public void sendingQuorumVoteRequest(java.lang.String remoteAddress, java.lang.String vote) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221060: Sending quorum vote request to {}: {}", remoteAddress, vote);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221061, value=\"Received quorum vote response from {}: {}\", level=INFO)
   @Override
   public void receivedQuorumVoteResponse(java.lang.String remoteAddress, java.lang.String vote) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221061: Received quorum vote response from {}: {}", remoteAddress, vote);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221062, value=\"Received quorum vote request: {}\", level=INFO)
   @Override
   public void receivedQuorumVoteRequest(java.lang.String vote) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221062: Received quorum vote request: {}", vote);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221063, value=\"Sending quorum vote response: {}\", level=INFO)
   @Override
   public void sendingQuorumVoteResponse(java.lang.String vote) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221063: Sending quorum vote response: {}", vote);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221064, value=\"Node {} found in cluster topology\", level=INFO)
   @Override
   public void nodeFoundInClusterTopology(java.lang.String nodeId) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221064: Node {} found in cluster topology", nodeId);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221065, value=\"Node {} not found in cluster topology\", level=INFO)
   @Override
   public void nodeNotFoundInClusterTopology(java.lang.String nodeId) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221065: Node {} not found in cluster topology", nodeId);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221066, value=\"Initiating quorum vote: {}\", level=INFO)
   @Override
   public void initiatingQuorumVote(org.apache.activemq.artemis.api.core.SimpleString vote) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221066: Initiating quorum vote: {}", vote);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221067, value=\"Waiting {} {} for quorum vote results.\", level=INFO)
   @Override
   public void waitingForQuorumVoteResults(int timeout, java.lang.String unit) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221067: Waiting {} {} for quorum vote results.", timeout, unit);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221068, value=\"Received all quorum votes.\", level=INFO)
   @Override
   public void receivedAllQuorumVotes() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221068: Received all quorum votes.");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221069, value=\"Timeout waiting for quorum vote responses.\", level=INFO)
   @Override
   public void timeoutWaitingForQuorumVoteResponses() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221069: Timeout waiting for quorum vote responses.");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221070, value=\"Restarting as backup based on quorum vote results.\", level=INFO)
   @Override
   public void restartingAsBackupBasedOnQuorumVoteResults() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221070: Restarting as backup based on quorum vote results.");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221071, value=\"Failing over based on quorum vote results.\", level=INFO)
   @Override
   public void failingOverBasedOnQuorumVoteResults() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221071: Failing over based on quorum vote results.");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221072, value=\"Can't find roles for the subject.\", level=INFO)
   @Override
   public void failedToFindRolesForTheSubject(java.lang.Exception e) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221072: Can't find roles for the subject.", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221073, value=\"Can't add role principal.\", level=INFO)
   @Override
   public void failedAddRolePrincipal(java.lang.Exception e) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221073: Can't add role principal.", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221074, value=\"Debug started : size = {} bytes, messages = {}\", level=INFO)
   @Override
   public void debugStarted(java.lang.Long globalSizeBytes, java.lang.Long numberOfMessages) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221074: Debug started : size = {} bytes, messages = {}", globalSizeBytes, numberOfMessages);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221075, value=\"Usage of wildcardRoutingEnabled configuration property is deprecated, please use wildCardConfiguration.enabled instead\", level=INFO)
   @Override
   public void deprecatedWildcardRoutingEnabled() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221075: Usage of wildcardRoutingEnabled configuration property is deprecated, please use wildCardConfiguration.enabled instead");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221076, value=\"{}\", level=INFO)
   @Override
   public void onDestroyConnectionWithSessionMetadata(java.lang.String msg) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221076: {}", msg);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221077, value=\"There is no queue with ID {}, deleting record {}\", level=INFO)
   @Override
   public void infoNoQueueWithID(java.lang.Long id, java.lang.Long record) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221077: There is no queue with ID {}, deleting record {}", id, record);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221078, value=\"Scaled down {} messages total.\", level=INFO)
   @Override
   public void infoScaledDownMessages(java.lang.Long num) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221078: Scaled down {} messages total.", num);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221079, value=\"Ignoring prepare on xid as already called : {}\", level=INFO)
   @Override
   public void ignoringPrepareOnXidAlreadyCalled(java.lang.String xid) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221079: Ignoring prepare on xid as already called : {}", xid);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221080, value=\"Deploying address {} supporting {}\", level=INFO)
   @Override
   public void deployAddress(java.lang.String addressName, java.lang.String routingTypes) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221080: Deploying address {} supporting {}", addressName, routingTypes);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221081, value=\"There is no address with ID {}, deleting record {}\", level=INFO)
   @Override
   public void infoNoAddressWithID(java.lang.Long id, java.lang.Long record) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221081: There is no address with ID {}, deleting record {}", id, record);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221082, value=\"Initializing metrics plugin {} with properties: {}\", level=INFO)
   @Override
   public void initializingMetricsPlugin(java.lang.String clazz, java.lang.String properties) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221082: Initializing metrics plugin {} with properties: {}", clazz, properties);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221083, value=\"ignoring quorum vote as max cluster size is {}.\", level=INFO)
   @Override
   public void ignoringQuorumVote(int maxClusterSize) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221083: ignoring quorum vote as max cluster size is {}.", maxClusterSize);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221084, value=\"Requested {} quorum votes\", level=INFO)
   @Override
   public void requestedQuorumVotes(int vote) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221084: Requested {} quorum votes", vote);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221085, value=\"Route {} to {}\", level=INFO)
   @Override
   public void routeClientConnection(org.apache.activemq.artemis.spi.core.remoting.Connection connection, org.apache.activemq.artemis.core.server.routing.targets.Target target) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221085: Route {} to {}", connection, target);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=221086, value=\"Cannot route {}\", level=INFO)
   @Override
   public void cannotRouteClientConnection(org.apache.activemq.artemis.spi.core.remoting.Connection connection) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ221086: Cannot route {}", connection);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222000, value=\"ActiveMQServer is being finalized and has not been stopped. Please remember to stop the server before letting it go out of scope\", level=WARN)
   @Override
   public void serverFinalisedWIthoutBeingSTopped() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222000: ActiveMQServer is being finalized and has not been stopped. Please remember to stop the server before letting it go out of scope");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222001, value=\"Error closing sessions while stopping server\", level=WARN)
   @Override
   public void errorClosingSessionsWhileStoppingServer(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222001: Error closing sessions while stopping server", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222002, value=\"Timed out waiting for pool to terminate {}. Interrupting all its threads!\", level=WARN)
   @Override
   public void timedOutStoppingThreadpool(java.util.concurrent.ExecutorService service) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222002: Timed out waiting for pool to terminate {}. Interrupting all its threads!", service);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222004, value=\"Must specify an address for each divert. This one will not be deployed.\", level=WARN)
   @Override
   public void divertWithNoAddress() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222004: Must specify an address for each divert. This one will not be deployed.");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222005, value=\"Must specify a forwarding address for each divert. This one will not be deployed.\", level=WARN)
   @Override
   public void divertWithNoForwardingAddress() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222005: Must specify a forwarding address for each divert. This one will not be deployed.");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222006, value=\"Binding already exists with name {}, divert will not be deployed\", level=WARN)
   @Override
   public void divertBindingAlreadyExists(org.apache.activemq.artemis.api.core.SimpleString bindingName) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222006: Binding already exists with name {}, divert will not be deployed", bindingName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222007, value=\"Security risk! Apache ActiveMQ Artemis is running with the default cluster admin user and default password. Please see the cluster chapter in the ActiveMQ Artemis User Guide for instructions on how to change this.\", level=WARN)
   @Override
   public void clusterSecurityRisk() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222007: Security risk! Apache ActiveMQ Artemis is running with the default cluster admin user and default password. Please see the cluster chapter in the ActiveMQ Artemis User Guide for instructions on how to change this.");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222008, value=\"unable to restart server, please kill and restart manually\", level=WARN)
   @Override
   public void serverRestartWarning(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222008: unable to restart server, please kill and restart manually", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222009, value=\"Unable to announce backup for replication. Trying to stop the server.\", level=WARN)
   @Override
   public void replicationStartProblem(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222009: Unable to announce backup for replication. Trying to stop the server.", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222010, value=\"Critical IO Error, shutting down the server. file={}, message={}\", level=ERROR)
   @Override
   public void ioCriticalIOError(java.lang.String message, java.lang.String file, java.lang.Throwable code) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ222010: Critical IO Error, shutting down the server. file={}, message={}", message, file, code);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222011, value=\"Error stopping server\", level=WARN)
   @Override
   public void errorStoppingServer(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222011: Error stopping server", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222012, value=\"Timed out waiting for backup activation to exit\", level=WARN)
   @Override
   public void backupActivationProblem() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222012: Timed out waiting for backup activation to exit");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222013, value=\"Error when trying to start replication\", level=WARN)
   @Override
   public void errorStartingReplication(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222013: Error when trying to start replication", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222014, value=\"Error when trying to stop replication\", level=WARN)
   @Override
   public void errorStoppingReplication(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222014: Error when trying to stop replication", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222016, value=\"Cannot deploy a connector with no name specified.\", level=WARN)
   @Override
   public void connectorWithNoName() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222016: Cannot deploy a connector with no name specified.");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222017, value=\"There is already a connector with name {} deployed. This one will not be deployed.\", level=WARN)
   @Override
   public void connectorAlreadyDeployed(java.lang.String name) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222017: There is already a connector with name {} deployed. This one will not be deployed.", name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222018, value=\"AIO was not located on this platform, it will fall back to using pure Java NIO. If your platform is Linux, install LibAIO to enable the AIO journal\", level=WARN)
   @Override
   public void AIONotFound() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222018: AIO was not located on this platform, it will fall back to using pure Java NIO. If your platform is Linux, install LibAIO to enable the AIO journal");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222019, value=\"There is already a discovery group with name {} deployed. This one will not be deployed.\", level=WARN)
   @Override
   public void discoveryGroupAlreadyDeployed(java.lang.String name) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222019: There is already a discovery group with name {} deployed. This one will not be deployed.", name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222020, value=\"error scanning for URL's\", level=WARN)
   @Override
   public void errorScanningURLs(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222020: error scanning for URL's", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222021, value=\"problem undeploying {}\", level=WARN)
   @Override
   public void problemUndeployingNode(org.w3c.dom.Node node, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222021: problem undeploying {}", node, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222022, value=\"Timed out waiting for paging cursor to stop {}\", level=WARN)
   @Override
   public void timedOutStoppingPagingCursor(java.util.concurrent.Executor executor) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222022: Timed out waiting for paging cursor to stop {}", executor);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222023, value=\"problem cleaning page address {}\", level=WARN)
   @Override
   public void problemCleaningPageAddress(org.apache.activemq.artemis.api.core.SimpleString address, java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222023: problem cleaning page address {}", address, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222024, value=\"Could not complete operations on IO context {}\", level=WARN)
   @Override
   public void problemCompletingOperations(org.apache.activemq.artemis.core.persistence.OperationContext e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222024: Could not complete operations on IO context {}", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222025, value=\"Problem cleaning page subscription counter\", level=WARN)
   @Override
   public void problemCleaningPagesubscriptionCounter(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222025: Problem cleaning page subscription counter", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222026, value=\"Error on cleaning up cursor pages\", level=WARN)
   @Override
   public void problemCleaningCursorPages(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222026: Error on cleaning up cursor pages", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222027, value=\"Timed out flushing executors for paging cursor to stop {}\", level=WARN)
   @Override
   public void timedOutFlushingExecutorsPagingCursor(org.apache.activemq.artemis.core.paging.cursor.PageSubscription pageSubscription) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222027: Timed out flushing executors for paging cursor to stop {}", pageSubscription);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222028, value=\"Could not find page cache for page {}, on queue {}/{} removing it from the journal\", level=WARN)
   @Override
   public void pageNotFound(org.apache.activemq.artemis.core.paging.cursor.PagePosition pos, long queueID, java.lang.String queue) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222028: Could not find page cache for page {}, on queue {}/{} removing it from the journal", pos, queueID, queue);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222029, value=\"Could not locate page transaction {}, ignoring message on position {} on address={} queue={}\", level=WARN)
   @Override
   public void pageSubscriptionCouldntLoad(long transactionID, org.apache.activemq.artemis.core.paging.cursor.PagePosition position, org.apache.activemq.artemis.api.core.SimpleString address, org.apache.activemq.artemis.api.core.SimpleString name) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222029: Could not locate page transaction {}, ignoring message on position {} on address={} queue={}", transactionID, position, address, name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222030, value=\"File {} being renamed to {}.invalidPage as it was loaded partially. Please verify your data.\", level=WARN)
   @Override
   public void pageInvalid(java.lang.String fileName, java.lang.String name) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222030: File {} being renamed to {}.invalidPage as it was loaded partially. Please verify your data.", fileName, name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222031, value=\"Error while deleting page file\", level=WARN)
   @Override
   public void pageDeleteError(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222031: Error while deleting page file", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222032, value=\"page finalise error\", level=WARN)
   @Override
   public void pageFinaliseError(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222032: page finalise error", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222033, value=\"Page file {} had incomplete records at position {} at record number {}\", level=WARN)
   @Override
   public void pageSuspectFile(java.lang.String fileName, int position, int msgNumber) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222033: Page file {} had incomplete records at position {} at record number {}", fileName, position, msgNumber);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222034, value=\"Can not delete page transaction id={}\", level=WARN)
   @Override
   public void pageTxDeleteError(long recordID, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222034: Can not delete page transaction id={}", recordID, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222035, value=\"Directory {} did not have an identification file {}\", level=WARN)
   @Override
   public void pageStoreFactoryNoIdFile(java.lang.String s, java.lang.String addressFile) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222035: Directory {} did not have an identification file {}", s, addressFile);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222036, value=\"Timed out on waiting PagingStore {} to shutdown\", level=WARN)
   @Override
   public void pageStoreTimeout(org.apache.activemq.artemis.api.core.SimpleString address) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222036: Timed out on waiting PagingStore {} to shutdown", address);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222037, value=\"IO Error, impossible to start paging\", level=WARN)
   @Override
   public void pageStoreStartIOError(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222037: IO Error, impossible to start paging", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222038, value=\"Starting paging on address '{}'; {}\", level=INFO)
   @Override
   public void pageStoreStart(org.apache.activemq.artemis.api.core.SimpleString storeName, java.lang.String sizeInfo) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ222038: Starting paging on address '{}'; {}", storeName, sizeInfo);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222039, value=\"Messages sent to address '{}' are being dropped; {}\", level=WARN)
   @Override
   public void pageStoreDropMessages(org.apache.activemq.artemis.api.core.SimpleString storeName, java.lang.String sizeInfo) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222039: Messages sent to address '{}' are being dropped; {}", storeName, sizeInfo);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222040, value=\"Server is stopped\", level=WARN)
   @Override
   public void serverIsStopped() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222040: Server is stopped");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222041, value=\"Cannot find queue {} to update delivery count\", level=WARN)
   @Override
   public void journalCannotFindQueueDelCount(java.lang.Long queueID) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222041: Cannot find queue {} to update delivery count", queueID);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222042, value=\"Cannot find message {} to update delivery count\", level=WARN)
   @Override
   public void journalCannotFindMessageDelCount(java.lang.Long msg) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222042: Cannot find message {} to update delivery count", msg);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222043, value=\"Message for queue {} which does not exist. This message will be ignored.\", level=WARN)
   @Override
   public void journalCannotFindQueueForMessage(java.lang.Long queueID) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222043: Message for queue {} which does not exist. This message will be ignored.", queueID);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222044, value=\"It was not possible to delete message {}\", level=WARN)
   @Override
   public void journalErrorDeletingMessage(java.lang.Long messageID, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222044: It was not possible to delete message {}", messageID, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222045, value=\"Message in prepared tx for queue {} which does not exist. This message will be ignored.\", level=WARN)
   @Override
   public void journalMessageInPreparedTX(java.lang.Long queueID) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222045: Message in prepared tx for queue {} which does not exist. This message will be ignored.", queueID);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222046, value=\"Failed to remove reference for {}\", level=WARN)
   @Override
   public void journalErrorRemovingRef(java.lang.Long messageID) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222046: Failed to remove reference for {}", messageID);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222047, value=\"Can not find queue {} while reloading ACKNOWLEDGE_CURSOR\", level=WARN)
   @Override
   public void journalCannotFindQueueReloadingACK(java.lang.Long queueID) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222047: Can not find queue {} while reloading ACKNOWLEDGE_CURSOR", queueID);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222049, value=\"InternalError: Record type {} not recognized. Maybe you are using journal files created on a different version\", level=WARN)
   @Override
   public void journalInvalidRecordType(java.lang.Byte recordType) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222049: InternalError: Record type {} not recognized. Maybe you are using journal files created on a different version", recordType);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222050, value=\"Can not locate recordType={} on loadPreparedTransaction//deleteRecords\", level=WARN)
   @Override
   public void journalInvalidRecordTypeOnPreparedTX(java.lang.Byte recordType) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222050: Can not locate recordType={} on loadPreparedTransaction//deleteRecords", recordType);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222051, value=\"Journal Error\", level=WARN)
   @Override
   public void journalError(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222051: Journal Error", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222052, value=\"error incrementing delay detection\", level=WARN)
   @Override
   public void errorIncrementDelayDeletionCount(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222052: error incrementing delay detection", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222053, value=\"Error on copying large message {} for DLA or Expiry\", level=WARN)
   @Override
   public void lareMessageErrorCopying(org.apache.activemq.artemis.core.server.LargeServerMessage largeServerMessage, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222053: Error on copying large message {} for DLA or Expiry", largeServerMessage, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222054, value=\"Error on executing IOCallback\", level=WARN)
   @Override
   public void errorExecutingAIOCallback(java.lang.Throwable t) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222054: Error on executing IOCallback", t);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222055, value=\"Error on deleting duplicate cache\", level=WARN)
   @Override
   public void errorDeletingDuplicateCache(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222055: Error on deleting duplicate cache", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222056, value=\"Did not route to any bindings for address {} and sendToDLAOnNoRoute is true but there is no DLA configured for the address, the message will be ignored.\", level=WARN)
   @Override
   public void noDLA(org.apache.activemq.artemis.api.core.SimpleString address) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222056: Did not route to any bindings for address {} and sendToDLAOnNoRoute is true but there is no DLA configured for the address, the message will be ignored.", address);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222057, value=\"It was not possible to add references due to an IO error code {} message = {}\", level=WARN)
   @Override
   public void ioErrorAddingReferences(java.lang.Integer errorCode, java.lang.String errorMessage) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222057: It was not possible to add references due to an IO error code {} message = {}", errorCode, errorMessage);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222059, value=\"Duplicate message detected - message will not be routed. Message information:\n{}\", level=WARN)
   @Override
   public void duplicateMessageDetected(org.apache.activemq.artemis.api.core.Message message) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222059: Duplicate message detected - message will not be routed. Message information:\n{}", message);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222060, value=\"Error while confirming large message completion on rollback for recordID={}\", level=WARN)
   @Override
   public void journalErrorConfirmingLargeMessage(java.lang.Long messageID, java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222060: Error while confirming large message completion on rollback for recordID={}", messageID, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222061, value=\"Client connection failed, clearing up resources for session {}\", level=WARN)
   @Override
   public void clientConnectionFailed(java.lang.String name) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222061: Client connection failed, clearing up resources for session {}", name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222062, value=\"Cleared up resources for session {}\", level=WARN)
   @Override
   public void clearingUpSession(java.lang.String name) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222062: Cleared up resources for session {}", name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222063, value=\"Error processing IOCallback code = {} message = {}\", level=WARN)
   @Override
   public void errorProcessingIOCallback(java.lang.Integer errorCode, java.lang.String errorMessage) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222063: Error processing IOCallback code = {} message = {}", errorCode, errorMessage);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222065, value=\"Client is not being consistent on the request versioning. It just sent a version id={} while it informed {} previously\", level=DEBUG)
   @Override
   public void incompatibleVersionAfterConnect(int version, int clientVersion) {
      if (logger.isDebugEnabled()) {
         logger.debug("AMQ222065: Client is not being consistent on the request versioning. It just sent a version id={} while it informed {} previously", version, clientVersion);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222066, value=\"Reattach request from {} failed as there is no confirmationWindowSize configured, which may be ok for your system\", level=WARN)
   @Override
   public void reattachRequestFailed(java.lang.String remoteAddress) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222066: Reattach request from {} failed as there is no confirmationWindowSize configured, which may be ok for your system", remoteAddress);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222067, value=\"Connection failure has been detected: {} [code={}]\", level=WARN)
   @Override
   public void connectionFailureDetected(java.lang.String message, org.apache.activemq.artemis.api.core.ActiveMQExceptionType type) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222067: Connection failure has been detected: {} [code={}]", message, type);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222069, value=\"error cleaning up stomp connection\", level=WARN)
   @Override
   public void errorCleaningStompConn(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222069: error cleaning up stomp connection", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222070, value=\"Stomp Transactional acknowledgement is not supported\", level=WARN)
   @Override
   public void stompTXAckNorSupported() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222070: Stomp Transactional acknowledgement is not supported");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222071, value=\"Interrupted while waiting for stomp heartbeat to die\", level=WARN)
   @Override
   public void errorOnStompHeartBeat(java.lang.InterruptedException e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222071: Interrupted while waiting for stomp heartbeat to die", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222072, value=\"Timed out flushing channel on InVMConnection\", level=WARN)
   @Override
   public void timedOutFlushingInvmChannel() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222072: Timed out flushing channel on InVMConnection");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222074, value=\"channel group did not completely close\", level=WARN)
   @Override
   public void nettyChannelGroupError() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222074: channel group did not completely close");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222075, value=\"{} is still connected to {}\", level=WARN)
   @Override
   public void nettyChannelStillOpen(io.netty.channel.Channel channel, java.net.SocketAddress remoteAddress) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222075: {} is still connected to {}", channel, remoteAddress);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222076, value=\"channel group did not completely unbind\", level=WARN)
   @Override
   public void nettyChannelGroupBindError() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222076: channel group did not completely unbind");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222077, value=\"{} is still bound to {}\", level=WARN)
   @Override
   public void nettyChannelStillBound(io.netty.channel.Channel channel, java.net.SocketAddress remoteAddress) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222077: {} is still bound to {}", channel, remoteAddress);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222078, value=\"Error instantiating remoting interceptor {}\", level=WARN)
   @Override
   public void errorCreatingRemotingInterceptor(java.lang.String interceptorClass, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222078: Error instantiating remoting interceptor {}", interceptorClass, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222079, value=\"The following keys are invalid for configuring the acceptor: {} the acceptor will not be started.\", level=WARN)
   @Override
   public void invalidAcceptorKeys(java.lang.String s) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222079: The following keys are invalid for configuring the acceptor: {} the acceptor will not be started.", s);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222080, value=\"Error instantiating remoting acceptor {}\", level=WARN)
   @Override
   public void errorCreatingAcceptor(java.lang.String factoryClassName, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222080: Error instantiating remoting acceptor {}", factoryClassName, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222081, value=\"Timed out waiting for remoting thread pool to terminate\", level=WARN)
   @Override
   public void timeoutRemotingThreadPool() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222081: Timed out waiting for remoting thread pool to terminate");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222082, value=\"error on connection failure check\", level=WARN)
   @Override
   public void errorOnFailureCheck(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222082: error on connection failure check", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222083, value=\"The following keys are invalid for configuring the connector service: {} the connector will not be started.\", level=WARN)
   @Override
   public void connectorKeysInvalid(java.lang.String s) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222083: The following keys are invalid for configuring the connector service: {} the connector will not be started.", s);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222084, value=\"The following keys are required for configuring the connector service: {} the connector will not be started.\", level=WARN)
   @Override
   public void connectorKeysMissing(java.lang.String s) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222084: The following keys are required for configuring the connector service: {} the connector will not be started.", s);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222085, value=\"Packet {} can not be processed by the ReplicationEndpoint\", level=WARN)
   @Override
   public void invalidPacketForReplication(org.apache.activemq.artemis.core.protocol.core.Packet packet) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222085: Packet {} can not be processed by the ReplicationEndpoint", packet);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222086, value=\"error handling packet {} for replication\", level=WARN)
   @Override
   public void errorHandlingReplicationPacket(org.apache.activemq.artemis.core.protocol.core.Packet packet, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222086: error handling packet {} for replication", packet, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222087, value=\"Replication Error while closing the page on backup\", level=WARN)
   @Override
   public void errorClosingPageOnReplication(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222087: Replication Error while closing the page on backup", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222088, value=\"Journal comparison mismatch:\n{}\", level=WARN)
   @Override
   public void journalcomparisonMismatch(java.lang.String s) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222088: Journal comparison mismatch:\n{}", s);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222089, value=\"Replication Error deleting large message ID = {}\", level=WARN)
   @Override
   public void errorDeletingLargeMessage(long messageId, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222089: Replication Error deleting large message ID = {}", messageId, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222090, value=\"Replication Large MessageID {}  is not available on backup server. Ignoring replication message\", level=WARN)
   @Override
   public void largeMessageNotAvailable(long messageId) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222090: Replication Large MessageID {}  is not available on backup server. Ignoring replication message", messageId);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222091, value=\"The backup node has been shut-down, replication will now stop\", level=WARN)
   @Override
   public void replicationStopOnBackupShutdown() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222091: The backup node has been shut-down, replication will now stop");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222092, value=\"Connection to the backup node failed, removing replication now\", level=WARN)
   @Override
   public void replicationStopOnBackupFail(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222092: Connection to the backup node failed, removing replication now", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222093, value=\"Timed out waiting to stop Bridge\", level=WARN)
   @Override
   public void timedOutWaitingToStopBridge() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222093: Timed out waiting to stop Bridge");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222094, value=\"Bridge unable to send message {}, will try again once bridge reconnects\", level=WARN)
   @Override
   public void bridgeUnableToSendMessage(org.apache.activemq.artemis.core.server.MessageReference ref, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222094: Bridge unable to send message {}, will try again once bridge reconnects", ref, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222095, value=\"Connection failed with failedOver={}\", level=WARN)
   @Override
   public void bridgeConnectionFailed(java.lang.Boolean failedOver) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222095: Connection failed with failedOver={}", failedOver);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222096, value=\"Error on querying binding on bridge {}. Retrying in 100 milliseconds\", level=WARN)
   @Override
   public void errorQueryingBridge(java.lang.String name, java.lang.Throwable t) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222096: Error on querying binding on bridge {}. Retrying in 100 milliseconds", name, t);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222097, value=\"Address {} does not have any bindings, retry #({})\", level=WARN)
   @Override
   public void errorQueryingBridge(java.lang.String address, java.lang.Integer retryCount) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222097: Address {} does not have any bindings, retry #({})", address, retryCount);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222098, value=\"Server is starting, retry to create the session for bridge {}\", level=WARN)
   @Override
   public void errorStartingBridge(java.lang.String name) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222098: Server is starting, retry to create the session for bridge {}", name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222099, value=\"Bridge {} is unable to connect to destination. It will be disabled.\", level=WARN)
   @Override
   public void errorConnectingBridge(org.apache.activemq.artemis.core.server.cluster.Bridge bridge, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222099: Bridge {} is unable to connect to destination. It will be disabled.", bridge, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222100, value=\"ServerLocator was shutdown, can not retry on opening connection for bridge\", level=WARN)
   @Override
   public void bridgeLocatorShutdown() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222100: ServerLocator was shutdown, can not retry on opening connection for bridge");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222101, value=\"Bridge {} achieved {} maxattempts={} it will stop retrying to reconnect\", level=WARN)
   @Override
   public void bridgeAbortStart(java.lang.String name, java.lang.Integer retryCount, java.lang.Integer reconnectAttempts) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222101: Bridge {} achieved {} maxattempts={} it will stop retrying to reconnect", name, retryCount, reconnectAttempts);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222102, value=\"Unexpected exception while trying to reconnect\", level=WARN)
   @Override
   public void errorReConnecting(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222102: Unexpected exception while trying to reconnect", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222103, value=\"transaction with xid {} timed out\", level=WARN)
   @Override
   public void timedOutXID(javax.transaction.xa.Xid xid) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222103: transaction with xid {} timed out", xid);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222104, value=\"IO Error completing the transaction, code = {}, message = {}\", level=WARN)
   @Override
   public void ioErrorOnTX(java.lang.Integer errorCode, java.lang.String errorMessage) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222104: IO Error completing the transaction, code = {}, message = {}", errorCode, errorMessage);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222106, value=\"Replacing incomplete LargeMessage with ID={}\", level=WARN)
   @Override
   public void replacingIncompleteLargeMessage(java.lang.Long messageID) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222106: Replacing incomplete LargeMessage with ID={}", messageID);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222107, value=\"Cleared up resources for session {}\", level=WARN)
   @Override
   public void clientConnectionFailedClearingSession(java.lang.String name) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222107: Cleared up resources for session {}", name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222108, value=\"unable to send notification when broadcast group is stopped\", level=WARN)
   @Override
   public void broadcastGroupClosed(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222108: unable to send notification when broadcast group is stopped", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222109, value=\"Timed out waiting for write lock on consumer {} from {}. Check the Thread dump\", level=WARN)
   @Override
   public void timeoutLockingConsumer(java.lang.String consumer, java.lang.String remoteAddress) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222109: Timed out waiting for write lock on consumer {} from {}. Check the Thread dump", consumer, remoteAddress);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222110, value=\"no queue IDs defined!,  originalMessage  = {}, copiedMessage = {}, props={}\", level=WARN)
   @Override
   public void noQueueIdDefined(org.apache.activemq.artemis.api.core.Message message, org.apache.activemq.artemis.api.core.Message messageCopy, org.apache.activemq.artemis.api.core.SimpleString idsHeaderName) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222110: no queue IDs defined!,  originalMessage  = {}, copiedMessage = {}, props={}", message, messageCopy, idsHeaderName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222111, value=\"exception while invoking {} on {}\", level=TRACE)
   @Override
   public void managementOperationError(java.lang.String op, java.lang.String resourceName, java.lang.Exception e) {
      if (logger.isTraceEnabled()) {
         logger.trace("AMQ222111: exception while invoking {} on {}", op, resourceName, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222112, value=\"exception while retrieving attribute {} on {}\", level=TRACE)
   @Override
   public void managementAttributeError(java.lang.String att, java.lang.String resourceName, java.lang.Exception e) {
      if (logger.isTraceEnabled()) {
         logger.trace("AMQ222112: exception while retrieving attribute {} on {}", att, resourceName, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222113, value=\"On ManagementService stop, there are {} unexpected registered MBeans: {}\", level=WARN)
   @Override
   public void managementStopError(java.lang.Integer size, java.util.List<java.lang.String> unexpectedResourceNames) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222113: On ManagementService stop, there are {} unexpected registered MBeans: {}", size, unexpectedResourceNames);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222114, value=\"Unable to delete group binding info {}\", level=WARN)
   @Override
   public void unableToDeleteGroupBindings(org.apache.activemq.artemis.api.core.SimpleString groupId, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222114: Unable to delete group binding info {}", groupId, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222115, value=\"Error closing serverLocator={}\", level=WARN)
   @Override
   public void errorClosingServerLocator(org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal clusterLocator, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222115: Error closing serverLocator={}", clusterLocator, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222116, value=\"unable to start broadcast group {}\", level=WARN)
   @Override
   public void unableToStartBroadcastGroup(java.lang.String name, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222116: unable to start broadcast group {}", name, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222117, value=\"unable to start cluster connection {}\", level=WARN)
   @Override
   public void unableToStartClusterConnection(org.apache.activemq.artemis.api.core.SimpleString name, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222117: unable to start cluster connection {}", name, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222118, value=\"unable to start Bridge {}\", level=WARN)
   @Override
   public void unableToStartBridge(org.apache.activemq.artemis.api.core.SimpleString name, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222118: unable to start Bridge {}", name, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222119, value=\"No connector with name {}. backup cannot be announced.\", level=WARN)
   @Override
   public void announceBackupNoConnector(java.lang.String connectorName) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222119: No connector with name {}. backup cannot be announced.", connectorName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222120, value=\"no cluster connections defined, unable to announce backup\", level=WARN)
   @Override
   public void announceBackupNoClusterConnections() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222120: no cluster connections defined, unable to announce backup");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222121, value=\"Must specify a unique name for each bridge. This one will not be deployed.\", level=WARN)
   @Override
   public void bridgeNotUnique() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222121: Must specify a unique name for each bridge. This one will not be deployed.");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222122, value=\"Must specify a queue name for each bridge. This one {} will not be deployed.\", level=WARN)
   @Override
   public void bridgeNoQueue(java.lang.String name) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222122: Must specify a queue name for each bridge. This one {} will not be deployed.", name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222123, value=\"Forward address is not specified on bridge {}. Will use original message address instead\", level=WARN)
   @Override
   public void bridgeNoForwardAddress(java.lang.String bridgeName) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222123: Forward address is not specified on bridge {}. Will use original message address instead", bridgeName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222124, value=\"There is already a bridge with name {} deployed. This one will not be deployed.\", level=WARN)
   @Override
   public void bridgeAlreadyDeployed(java.lang.String name) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222124: There is already a bridge with name {} deployed. This one will not be deployed.", name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222125, value=\"No queue found with name {} bridge {} will not be deployed.\", level=WARN)
   @Override
   public void bridgeQueueNotFound(java.lang.String queueName, java.lang.String bridgeName) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222125: No queue found with name {} bridge {} will not be deployed.", queueName, bridgeName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222126, value=\"No discovery group found with name {} bridge will not be deployed.\", level=WARN)
   @Override
   public void bridgeNoDiscoveryGroup(java.lang.String name) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222126: No discovery group found with name {} bridge will not be deployed.", name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222127, value=\"Must specify a unique name for each cluster connection. This one will not be deployed.\", level=WARN)
   @Override
   public void clusterConnectionNotUnique() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222127: Must specify a unique name for each cluster connection. This one will not be deployed.");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222128, value=\"Must specify an address for each cluster connection. This one will not be deployed.\", level=WARN)
   @Override
   public void clusterConnectionNoForwardAddress() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222128: Must specify an address for each cluster connection. This one will not be deployed.");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222129, value=\"No connector with name {}. The cluster connection will not be deployed.\", level=WARN)
   @Override
   public void clusterConnectionNoConnector(java.lang.String connectorName) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222129: No connector with name {}. The cluster connection will not be deployed.", connectorName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222130, value=\"Cluster Configuration  {} already exists. The cluster connection will not be deployed.\", level=WARN)
   @Override
   public void clusterConnectionAlreadyExists(java.lang.String connectorName) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222130: Cluster Configuration  {} already exists. The cluster connection will not be deployed.", connectorName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222131, value=\"No discovery group with name {}. The cluster connection will not be deployed.\", level=WARN)
   @Override
   public void clusterConnectionNoDiscoveryGroup(java.lang.String discoveryGroupName) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222131: No discovery group with name {}. The cluster connection will not be deployed.", discoveryGroupName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222132, value=\"There is already a broadcast-group with name {} deployed. This one will not be deployed.\", level=WARN)
   @Override
   public void broadcastGroupAlreadyExists(java.lang.String name) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222132: There is already a broadcast-group with name {} deployed. This one will not be deployed.", name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222133, value=\"There is no connector deployed with name {}. The broadcast group with name {} will not be deployed.\", level=WARN)
   @Override
   public void broadcastGroupNoConnector(java.lang.String connectorName, java.lang.String bgName) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222133: There is no connector deployed with name {}. The broadcast group with name {} will not be deployed.", connectorName, bgName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222134, value=\"No connector defined with name {}. The bridge will not be deployed.\", level=WARN)
   @Override
   public void noConnector(java.lang.String name) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222134: No connector defined with name {}. The bridge will not be deployed.", name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222135, value=\"Stopping Redistributor, Timed out waiting for tasks to complete\", level=WARN)
   @Override
   public void errorStoppingRedistributor() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222135: Stopping Redistributor, Timed out waiting for tasks to complete");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222136, value=\"IO Error during redistribution, errorCode = {} message = {}\", level=WARN)
   @Override
   public void ioErrorRedistributing(java.lang.Integer errorCode, java.lang.String errorMessage) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222136: IO Error during redistribution, errorCode = {} message = {}", errorCode, errorMessage);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222137, value=\"Unable to announce backup, retrying\", level=WARN)
   @Override
   public void errorAnnouncingBackup(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222137: Unable to announce backup, retrying", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222138, value=\"Local Member is not set at on ClusterConnection {}\", level=WARN)
   @Override
   public void noLocalMemborOnClusterConnection(org.apache.activemq.artemis.core.server.cluster.impl.ClusterConnectionImpl clusterConnection) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222138: Local Member is not set at on ClusterConnection {}", clusterConnection);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222139, value=\"{}::Remote queue binding {} has already been bound in the post office. Most likely cause for this is you have a loop in your cluster due to cluster max-hops being too large or you have multiple cluster connections to the same nodes using overlapping addresses\", level=WARN)
   @Override
   public void remoteQueueAlreadyBoundOnClusterConnection(java.lang.Object messageFlowRecord, org.apache.activemq.artemis.api.core.SimpleString clusterName) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222139: {}::Remote queue binding {} has already been bound in the post office. Most likely cause for this is you have a loop in your cluster due to cluster max-hops being too large or you have multiple cluster connections to the same nodes using overlapping addresses", messageFlowRecord, clusterName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222141, value=\"Node Manager can not open file {}\", level=WARN)
   @Override
   public void nodeManagerCantOpenFile(java.io.File file, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222141: Node Manager can not open file {}", file, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222142, value=\"Error on resetting large message deliver - {}\", level=WARN)
   @Override
   public void errorResttingLargeMessage(java.lang.Object deliverer, java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222142: Error on resetting large message deliver - {}", deliverer, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222143, value=\"Timed out waiting for executor to complete\", level=WARN)
   @Override
   public void errorTransferringConsumer() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222143: Timed out waiting for executor to complete");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222144, value=\"Queue could not finish waiting executors. Try increasing the thread pool size\", level=WARN)
   @Override
   public void errorFlushingExecutorsOnQueue() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222144: Queue could not finish waiting executors. Try increasing the thread pool size");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222145, value=\"Error expiring reference {} on queue\", level=WARN)
   @Override
   public void errorExpiringReferencesOnQueue(org.apache.activemq.artemis.core.server.MessageReference ref, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222145: Error expiring reference {} on queue", ref, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222146, value=\"Message has expired. No bindings for Expiry Address {} so dropping it\", level=WARN)
   @Override
   public void errorExpiringReferencesNoBindings(org.apache.activemq.artemis.api.core.SimpleString expiryAddress) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222146: Message has expired. No bindings for Expiry Address {} so dropping it", expiryAddress);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222147, value=\"Messages are being expired on queue {}, but there is no Expiry Address configured so messages will be dropped.\", level=WARN)
   @Override
   public void errorExpiringReferencesNoAddress(org.apache.activemq.artemis.api.core.SimpleString name) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222147: Messages are being expired on queue {}, but there is no Expiry Address configured so messages will be dropped.", name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222148, value=\"Sending message {} to Dead Letter Address {}, but it has no bindings so dropping it\", level=WARN)
   @Override
   public void noBindingsOnDLA(org.apache.activemq.artemis.core.server.MessageReference ref, org.apache.activemq.artemis.api.core.SimpleString name) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222148: Sending message {} to Dead Letter Address {}, but it has no bindings so dropping it", ref, name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222149, value=\"Sending message {} to Dead Letter Address {} from {}\", level=WARN)
   @Override
   public void sendingMessageToDLA(org.apache.activemq.artemis.core.server.MessageReference ref, org.apache.activemq.artemis.api.core.SimpleString name, org.apache.activemq.artemis.api.core.SimpleString simpleString) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222149: Sending message {} to Dead Letter Address {} from {}", ref, name, simpleString);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222150, value=\"Sending message {} to Dead Letter Address, but there is no Dead Letter Address configured for queue {} so dropping it\", level=WARN)
   @Override
   public void sendingMessageToDLAnoDLA(org.apache.activemq.artemis.core.server.MessageReference ref, org.apache.activemq.artemis.api.core.SimpleString name) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222150: Sending message {} to Dead Letter Address, but there is no Dead Letter Address configured for queue {} so dropping it", ref, name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222151, value=\"removing consumer which did not handle a message, consumer={}, message={}\", level=WARN)
   @Override
   public void removingBadConsumer(org.apache.activemq.artemis.core.server.Consumer consumer, java.lang.Object reference, java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222151: removing consumer which did not handle a message, consumer={}, message={}", consumer, reference, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222152, value=\"Unable to decrement reference counting on queue\", level=WARN)
   @Override
   public void errorDecrementingRefCount(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222152: Unable to decrement reference counting on queue", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222153, value=\"Cannot locate record for message id = {} on Journal\", level=WARN)
   @Override
   public void cannotFindMessageOnJournal(java.lang.Long messageID, java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222153: Cannot locate record for message id = {} on Journal", messageID, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222154, value=\"Error checking DLQ\", level=WARN)
   @Override
   public void errorCheckingDLQ(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222154: Error checking DLQ", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222155, value=\"Failed to register as backup. Stopping the server.\", level=WARN)
   @Override
   public void errorRegisteringBackup() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222155: Failed to register as backup. Stopping the server.");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222156, value=\"Less than {}%\n{}\nYou are in danger of running out of RAM. Have you set paging parameters on your addresses? (See user manual \\"Paging\\" chapter)\", level=WARN)
   @Override
   public void memoryError(java.lang.Integer memoryWarningThreshold, java.lang.String info) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222156: Less than {}%\n{}\nYou are in danger of running out of RAM. Have you set paging parameters on your addresses? (See user manual \"Paging\" chapter)", memoryWarningThreshold, info);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222157, value=\"Error completing callback on replication manager\", level=WARN)
   @Override
   public void errorCompletingCallbackOnReplicationManager(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222157: Error completing callback on replication manager", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222158, value=\"{} activation thread did not finish.\", level=WARN)
   @Override
   public void activationDidntFinish(org.apache.activemq.artemis.core.server.ActiveMQServer server) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222158: {} activation thread did not finish.", server);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222159, value=\"unable to send notification when broadcast group is stopped\", level=WARN)
   @Override
   public void broadcastBridgeStoppedError(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222159: unable to send notification when broadcast group is stopped", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222160, value=\"unable to send notification when broadcast group is stopped\", level=WARN)
   @Override
   public void notificationBridgeStoppedError(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222160: unable to send notification when broadcast group is stopped", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222161, value=\"Group Handler timed-out waiting for sendCondition\", level=WARN)
   @Override
   public void groupHandlerSendTimeout() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222161: Group Handler timed-out waiting for sendCondition");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222162, value=\"Moving data directory {} to {}\", level=INFO)
   @Override
   public void backupMovingDataAway(java.lang.String oldPath, java.lang.String newPath) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ222162: Moving data directory {} to {}", oldPath, newPath);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222163, value=\"Server is being completely stopped, since this was a replicated backup there may be journal files that need cleaning up. The Apache ActiveMQ Artemis broker will have to be manually restarted.\", level=WARN)
   @Override
   public void stopReplicatedBackupAfterFailback() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222163: Server is being completely stopped, since this was a replicated backup there may be journal files that need cleaning up. The Apache ActiveMQ Artemis broker will have to be manually restarted.");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222164, value=\"Error when trying to start replication {}\", level=WARN)
   @Override
   public void errorStartingReplication(org.apache.activemq.artemis.core.protocol.core.impl.wireformat.BackupReplicationStartFailedMessage.BackupRegistrationProblem problem) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222164: Error when trying to start replication {}", problem);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222165, value=\"No Dead Letter Address configured for queue {} in AddressSettings\", level=WARN)
   @Override
   public void AddressSettingsNoDLA(org.apache.activemq.artemis.api.core.SimpleString name) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222165: No Dead Letter Address configured for queue {} in AddressSettings", name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222166, value=\"No Expiry Address configured for queue {} in AddressSettings\", level=WARN)
   @Override
   public void AddressSettingsNoExpiryAddress(org.apache.activemq.artemis.api.core.SimpleString name) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222166: No Expiry Address configured for queue {} in AddressSettings", name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222167, value=\"Group Binding not available so deleting {} groups from {}, groups will be bound to another node\", level=WARN)
   @Override
   public void groupingQueueRemoved(int size, org.apache.activemq.artemis.api.core.SimpleString clusterName) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222167: Group Binding not available so deleting {} groups from {}, groups will be bound to another node", size, clusterName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222168, value=\"The 'protocol' property is deprecated. If you want this Acceptor to support multiple protocols, use the 'protocols' property, e.g. with value 'CORE,AMQP,STOMP'\", level=WARN)
   @Override
   public void warnDeprecatedProtocol() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222168: The 'protocol' property is deprecated. If you want this Acceptor to support multiple protocols, use the 'protocols' property, e.g. with value 'CORE,AMQP,STOMP'");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222169, value=\"Server needs to disconnect the consumer because of ( {} ) but you have a legacy client connected and it cannot do so, these consumers may just hang\", level=WARN)
   @Override
   public void warnDisconnectOldClient(java.lang.String message) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222169: Server needs to disconnect the consumer because of ( {} ) but you have a legacy client connected and it cannot do so, these consumers may just hang", message);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222170, value=\"Bridge {} forwarding address {} has confirmation-window-size ({}) greater than address' max-size-bytes' ({})\", level=WARN)
   @Override
   public void bridgeConfirmationWindowTooSmall(java.lang.String bridgeName, java.lang.String address, int windowConfirmation, long maxSizeBytes) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222170: Bridge {} forwarding address {} has confirmation-window-size ({}) greater than address' max-size-bytes' ({})", bridgeName, address, windowConfirmation, maxSizeBytes);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222171, value=\"Bridge {} forwarding address {} could not be resolved on address-settings configuration\", level=WARN)
   @Override
   public void bridgeCantFindAddressConfig(java.lang.String bridgeName, java.lang.String forwardingAddress) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222171: Bridge {} forwarding address {} could not be resolved on address-settings configuration", bridgeName, forwardingAddress);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222172, value=\"Queue {} was busy for more than {} milliseconds. There are possibly consumers hanging on a network operation\", level=WARN)
   @Override
   public void queueBusy(java.lang.String name, long timeout) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222172: Queue {} was busy for more than {} milliseconds. There are possibly consumers hanging on a network operation", name, timeout);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222173, value=\"Queue {} is duplicated during reload. This queue will be renamed as {}\", level=WARN)
   @Override
   public void queueDuplicatedRenaming(java.lang.String name, java.lang.String newName) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222173: Queue {} is duplicated during reload. This queue will be renamed as {}", name, newName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222174, value=\"Queue {}, on address={}, is taking too long to flush deliveries. Watch out for frozen clients.\", level=WARN)
   @Override
   public void timeoutFlushInTransit(java.lang.String queueName, java.lang.String addressName) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222174: Queue {}, on address={}, is taking too long to flush deliveries. Watch out for frozen clients.", queueName, addressName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222175, value=\"Bridge {} could not find configured connectors\", level=WARN)
   @Override
   public void bridgeCantFindConnectors(java.lang.String bridgeName) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222175: Bridge {} could not find configured connectors", bridgeName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222176, value=\"A session that was already doing XA work on {} is replacing the xid by {} . This was most likely caused from a previous communication timeout\", level=WARN)
   @Override
   public void xidReplacedOnXStart(java.lang.String xidOriginalToString, java.lang.String xidReplacedToString) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222176: A session that was already doing XA work on {} is replacing the xid by {} . This was most likely caused from a previous communication timeout", xidOriginalToString, xidReplacedToString);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222177, value=\"Wrong configuration for role, {} is not a valid permission\", level=WARN)
   @Override
   public void rolePermissionConfigurationError(java.lang.String permission) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222177: Wrong configuration for role, {} is not a valid permission", permission);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222178, value=\"Error during recovery of page counters\", level=WARN)
   @Override
   public void errorRecoveringPageCounter(java.lang.Throwable error) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222178: Error during recovery of page counters", error);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222181, value=\"Unable to scaleDown messages\", level=WARN)
   @Override
   public void failedToScaleDown(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222181: Unable to scaleDown messages", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222182, value=\"Missing cluster-configuration for scale-down-clustername {}\", level=WARN)
   @Override
   public void missingClusterConfigForScaleDown(java.lang.String scaleDownCluster) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222182: Missing cluster-configuration for scale-down-clustername {}", scaleDownCluster);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222183, value=\"Blocking message production on address '{}'; {}\", level=WARN)
   @Override
   public void blockingMessageProduction(org.apache.activemq.artemis.api.core.SimpleString addressName, java.lang.String pageInfo) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222183: Blocking message production on address '{}'; {}", addressName, pageInfo);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222184, value=\"Unable to recover group bindings in SCALE_DOWN mode, only FULL backup server can do this\", level=WARN)
   @Override
   public void groupBindingsOnRecovery() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222184: Unable to recover group bindings in SCALE_DOWN mode, only FULL backup server can do this");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222185, value=\"no cluster connection for specified replication cluster\", level=WARN)
   @Override
   public void noClusterConnectionForReplicationCluster() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222185: no cluster connection for specified replication cluster");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222186, value=\"unable to authorise cluster control: {}\", level=WARN)
   @Override
   public void clusterControlAuthfailure(java.lang.String causeMessage) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222186: unable to authorise cluster control: {}", causeMessage);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222187, value=\"Failed to activate replicated backup\", level=WARN)
   @Override
   public void activateReplicatedBackupFailed(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222187: Failed to activate replicated backup", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222188, value=\"Unable to find target queue for node {}\", level=WARN)
   @Override
   public void unableToFindTargetQueue(java.lang.String targetNodeID) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222188: Unable to find target queue for node {}", targetNodeID);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222189, value=\"Failed to activate shared store slave\", level=WARN)
   @Override
   public void activateSharedStoreSlaveFailed(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222189: Failed to activate shared store slave", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222191, value=\"Could not find any configured role for user {}.\", level=WARN)
   @Override
   public void cannotFindRoleForUser(java.lang.String user) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222191: Could not find any configured role for user {}.", user);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222192, value=\"Could not delete: {}\", level=WARN)
   @Override
   public void couldNotDeleteTempFile(java.lang.String tempFileName) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222192: Could not delete: {}", tempFileName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222193, value=\"Memory Limit reached. Producer ({}) stopped to prevent flooding {} (blocking for {}s). See http://activemq.apache.org/producer-flow-control.html for more info.\", level=WARN)
   @Override
   public void memoryLimitReached(java.lang.String producerID, java.lang.String address, long duration) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222193: Memory Limit reached. Producer ({}) stopped to prevent flooding {} (blocking for {}s). See http://activemq.apache.org/producer-flow-control.html for more info.", producerID, address, duration);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222194, value=\"PageCursorInfo == null on address {}, pos = {}, queue = {}.\", level=WARN)
   @Override
   public void nullPageCursorInfo(java.lang.String address, java.lang.String position, long id) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222194: PageCursorInfo == null on address {}, pos = {}, queue = {}.", address, position, id);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222195, value=\"Large message {} wasn't found when dealing with add pending large message\", level=WARN)
   @Override
   public void largeMessageNotFound(long id) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222195: Large message {} wasn't found when dealing with add pending large message", id);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222196, value=\"Could not find binding with id={} on routeFromCluster for message={} binding = {}\", level=WARN)
   @Override
   public void bindingNotFound(long id, java.lang.String message, java.lang.String binding) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222196: Could not find binding with id={} on routeFromCluster for message={} binding = {}", id, message, binding);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222197, value=\"Internal error! Delivery logic has identified a non delivery and still handled a consumer!\", level=WARN)
   @Override
   public void nonDeliveryHandled() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222197: Internal error! Delivery logic has identified a non delivery and still handled a consumer!");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222198, value=\"Could not flush ClusterManager executor ({}) in 10 seconds, verify your thread pool size\", level=WARN)
   @Override
   public void couldNotFlushClusterManager(java.lang.String manager) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222198: Could not flush ClusterManager executor ({}) in 10 seconds, verify your thread pool size", manager);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222199, value=\"Thread dump: {}\", level=WARN)
   @Override
   public void threadDump(java.lang.String manager) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222199: Thread dump: {}", manager);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222200, value=\"Could not finish executor on {}\", level=WARN)
   @Override
   public void couldNotFinishExecutor(java.lang.String clusterConnection) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222200: Could not finish executor on {}", clusterConnection);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222201, value=\"Timed out waiting for activation to exit\", level=WARN)
   @Override
   public void activationTimeout() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222201: Timed out waiting for activation to exit");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222202, value=\"{}: <{}> should not be set to the same value as <{}>.  If a system is under high load, or there is a minor network delay, there is a high probability of a cluster split/failure due to connection timeout.\", level=WARN)
   @Override
   public void connectionTTLEqualsCheckPeriod(java.lang.String connectionName, java.lang.String ttl, java.lang.String checkPeriod) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222202: {}: <{}> should not be set to the same value as <{}>.  If a system is under high load, or there is a minor network delay, there is a high probability of a cluster split/failure due to connection timeout.", connectionName, ttl, checkPeriod);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222203, value=\"Classpath lacks a protocol-manager for protocol {}, Protocol being ignored on acceptor {}\", level=WARN)
   @Override
   public void noProtocolManagerFound(java.lang.String protocol, java.lang.String host) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222203: Classpath lacks a protocol-manager for protocol {}, Protocol being ignored on acceptor {}", protocol, host);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222204, value=\"Duplicated Acceptor {} with parameters {} classFactory={} duplicated on the configuration\", level=WARN)
   @Override
   public void duplicatedAcceptor(java.lang.String name, java.lang.String parameters, java.lang.String classFactory) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222204: Duplicated Acceptor {} with parameters {} classFactory={} duplicated on the configuration", name, parameters, classFactory);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222205, value=\"OutOfMemoryError possible! There are currently {} addresses with a total max-size-bytes of {} bytes, but the maximum memory available is {} bytes.\", level=WARN)
   @Override
   public void potentialOOME(long addressCount, long totalMaxSizeBytes, long maxMemory) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222205: OutOfMemoryError possible! There are currently {} addresses with a total max-size-bytes of {} bytes, but the maximum memory available is {} bytes.", addressCount, totalMaxSizeBytes, maxMemory);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222206, value=\"Connection limit of {} reached. Refusing connection from {}.\", level=WARN)
   @Override
   public void connectionLimitReached(long connectionsAllowed, java.lang.String address) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222206: Connection limit of {} reached. Refusing connection from {}.", connectionsAllowed, address);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222207, value=\"The backup server is not responding promptly introducing latency beyond the limit. Replication server being disconnected now.\", level=WARN)
   @Override
   public void slowReplicationResponse() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222207: The backup server is not responding promptly introducing latency beyond the limit. Replication server being disconnected now.");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222208, value=\"SSL handshake failed for client from {}: {}.\", level=WARN)
   @Override
   public void sslHandshakeFailed(java.lang.String clientAddress, java.lang.String cause) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222208: SSL handshake failed for client from {}: {}.", clientAddress, cause);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222209, value=\"Could not contact group handler coordinator after 10 retries, message being routed without grouping information\", level=WARN)
   @Override
   public void impossibleToRouteGrouped() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222209: Could not contact group handler coordinator after 10 retries, message being routed without grouping information");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222210, value=\"Free storage space is at {} of {} total. Usage rate is {} which is beyond the configured <max-disk-usage>. System will start blocking producers.\", level=WARN)
   @Override
   public void diskBeyondCapacity(java.lang.String usableSpace, java.lang.String totalSpace, java.lang.String usage) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222210: Free storage space is at {} of {} total. Usage rate is {} which is beyond the configured <max-disk-usage>. System will start blocking producers.", usableSpace, totalSpace, usage);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222211, value=\"Free storage space is at {} of {} total. Usage rate is {} which is below the configured <max-disk-usage>.\", level=INFO)
   @Override
   public void diskCapacityRestored(java.lang.String usableSpace, java.lang.String totalSpace, java.lang.String usage) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ222211: Free storage space is at {} of {} total. Usage rate is {} which is below the configured <max-disk-usage>.", usableSpace, totalSpace, usage);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222212, value=\"Disk Full! Blocking message production on address '{}'. Clients will report blocked.\", level=WARN)
   @Override
   public void blockingDiskFull(org.apache.activemq.artemis.api.core.SimpleString addressName) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222212: Disk Full! Blocking message production on address '{}'. Clients will report blocked.", addressName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222213, value=\"There was an issue on the network, server is isolated!\", level=WARN)
   @Override
   public void serverIsolatedOnNetwork() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222213: There was an issue on the network, server is isolated!");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222214, value=\"Destination {} has an inconsistent and negative address size={}.\", level=WARN)
   @Override
   public void negativeAddressSize(java.lang.String destination, long size) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222214: Destination {} has an inconsistent and negative address size={}.", destination, size);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222215, value=\"Global Address Size has negative and inconsistent value as {}\", level=WARN)
   @Override
   public void negativeGlobalAddressSize(long size) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222215: Global Address Size has negative and inconsistent value as {}", size);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222216, value=\"Security problem while authenticating: {}\", level=WARN)
   @Override
   public void securityProblemWhileAuthenticating(java.lang.String message) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222216: Security problem while authenticating: {}", message);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222217, value=\"Cannot find connector-ref {}. The cluster-connection {} will not be deployed.\", level=WARN)
   @Override
   public void connectorRefNotFound(java.lang.String connectorRef, java.lang.String clusterConnection) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222217: Cannot find connector-ref {}. The cluster-connection {} will not be deployed.", connectorRef, clusterConnection);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222218, value=\"Server disconnecting: {}\", level=WARN)
   @Override
   public void disconnectCritical(java.lang.String reason, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222218: Server disconnecting: {}", reason, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222219, value=\"File {} does not exist\", level=WARN)
   @Override
   public void fileDoesNotExist(java.lang.String path) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222219: File {} does not exist", path);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222220, value=\"   Error while cleaning paging on queue {}\", level=WARN)
   @Override
   public void errorCleaningPagingOnQueue(java.lang.String queue, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222220:    Error while cleaning paging on queue {}", queue, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222221, value=\"Error while cleaning page, during the commit\", level=WARN)
   @Override
   public void errorCleaningPagingDuringCommit(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222221: Error while cleaning page, during the commit", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222222, value=\"Error while deleting page-complete-record\", level=WARN)
   @Override
   public void errorDeletingPageCompleteRecord(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222222: Error while deleting page-complete-record", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222223, value=\"Failed to calculate message memory estimate\", level=WARN)
   @Override
   public void errorCalculateMessageMemoryEstimate(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222223: Failed to calculate message memory estimate", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222224, value=\"Failed to calculate scheduled delivery time\", level=WARN)
   @Override
   public void errorCalculateScheduledDeliveryTime(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222224: Failed to calculate scheduled delivery time", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222225, value=\"Sending unexpected exception to the client\", level=WARN)
   @Override
   public void sendingUnexpectedExceptionToClient(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222225: Sending unexpected exception to the client", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222226, value=\"Connection configuration is null for connectorName {}\", level=WARN)
   @Override
   public void connectionConfigurationIsNull(java.lang.String connectorName) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222226: Connection configuration is null for connectorName {}", connectorName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222227, value=\"Failed to process an event\", level=WARN)
   @Override
   public void failedToProcessEvent(javax.naming.NamingException e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222227: Failed to process an event", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222228, value=\"Missing replication token on queue\", level=WARN)
   @Override
   public void missingReplicationTokenOnQueue() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222228: Missing replication token on queue");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222229, value=\"Failed to perform rollback\", level=WARN)
   @Override
   public void failedToPerformRollback(java.lang.IllegalStateException e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222229: Failed to perform rollback", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222230, value=\"Failed to send notification\", level=WARN)
   @Override
   public void failedToSendNotification(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222230: Failed to send notification", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222231, value=\"Failed to flush outstanding data from the connection\", level=WARN)
   @Override
   public void failedToFlushOutstandingDataFromTheConnection(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222231: Failed to flush outstanding data from the connection", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222232, value=\"Unable to acquire lock\", level=WARN)
   @Override
   public void unableToAcquireLock(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222232: Unable to acquire lock", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222233, value=\"Unable to destroy connection with session metadata\", level=WARN)
   @Override
   public void unableDestroyConnectionWithSessionMetadata(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222233: Unable to destroy connection with session metadata", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222234, value=\"Unable to invoke a callback\", level=WARN)
   @Override
   public void unableToInvokeCallback(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222234: Unable to invoke a callback", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222235, value=\"Unable to inject a monitor\", level=WARN)
   @Override
   public void unableToInjectMonitor(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222235: Unable to inject a monitor", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222236, value=\"Unable to flush deliveries\", level=WARN)
   @Override
   public void unableToFlushDeliveries(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222236: Unable to flush deliveries", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222237, value=\"Unable to stop redistributor\", level=WARN)
   @Override
   public void unableToCancelRedistributor(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222237: Unable to stop redistributor", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222238, value=\"Unable to commit transaction\", level=WARN)
   @Override
   public void unableToCommitTransaction(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222238: Unable to commit transaction", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222239, value=\"Unable to delete Queue status\", level=WARN)
   @Override
   public void unableToDeleteQueueStatus(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222239: Unable to delete Queue status", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222240, value=\"Unable to pause a Queue\", level=WARN)
   @Override
   public void unableToPauseQueue(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222240: Unable to pause a Queue", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222241, value=\"Unable to resume a Queue\", level=WARN)
   @Override
   public void unableToResumeQueue(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222241: Unable to resume a Queue", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222242, value=\"Unable to obtain message priority, using default \", level=WARN)
   @Override
   public void unableToGetMessagePriority(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222242: Unable to obtain message priority, using default ", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222243, value=\"Unable to extract GroupID from message\", level=WARN)
   @Override
   public void unableToExtractGroupID(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222243: Unable to extract GroupID from message", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222244, value=\"Unable to check if message expired\", level=WARN)
   @Override
   public void unableToCheckIfMessageExpired(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222244: Unable to check if message expired", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222245, value=\"Unable to perform post acknowledge\", level=WARN)
   @Override
   public void unableToPerformPostAcknowledge(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222245: Unable to perform post acknowledge", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222246, value=\"Unable to rollback on close\", level=WARN)
   @Override
   public void unableToRollbackOnClose(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222246: Unable to rollback on close", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222247, value=\"Unable to close consumer\", level=WARN)
   @Override
   public void unableToCloseConsumer(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222247: Unable to close consumer", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222248, value=\"Unable to remove consumer\", level=WARN)
   @Override
   public void unableToRemoveConsumer(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222248: Unable to remove consumer", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222249, value=\"Unable to rollback on TX timed out\", level=WARN)
   @Override
   public void unableToRollbackOnTxTimedOut(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222249: Unable to rollback on TX timed out", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222250, value=\"Unable to delete heuristic completion from storage manager\", level=WARN)
   @Override
   public void unableToDeleteHeuristicCompletion(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222250: Unable to delete heuristic completion from storage manager", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222251, value=\"Unable to start replication\", level=WARN)
   @Override
   public void unableToStartReplication(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222251: Unable to start replication", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222252, value=\"Unable to calculate file size\", level=WARN)
   @Override
   public void unableToCalculateFileSize(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222252: Unable to calculate file size", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222253, value=\"Error while syncing data on largeMessageInSync:: {}\", level=WARN)
   @Override
   public void errorWhileSyncingData(java.lang.String target, java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222253: Error while syncing data on largeMessageInSync:: {}", target, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222254, value=\"Invalid record type {}\", level=WARN)
   @Override
   public void invalidRecordType(byte type, java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222254: Invalid record type {}", type, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222255, value=\"Unable to calculate file store usage\", level=WARN)
   @Override
   public void unableToCalculateFileStoreUsage(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222255: Unable to calculate file store usage", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222256, value=\"Failed to unregister acceptors\", level=WARN)
   @Override
   public void failedToUnregisterAcceptors(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222256: Failed to unregister acceptors", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222257, value=\"Failed to decrement message reference count\", level=WARN)
   @Override
   public void failedToDecrementMessageReferenceCount(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222257: Failed to decrement message reference count", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222258, value=\"Error on deleting queue {}\", level=WARN)
   @Override
   public void errorOnDeletingQueue(java.lang.String queueName, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222258: Error on deleting queue {}", queueName, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222259, value=\"Failed to flush the executor\", level=WARN)
   @Override
   public void failedToFlushExecutor(java.lang.InterruptedException e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222259: Failed to flush the executor", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222260, value=\"Failed to perform rollback\", level=WARN)
   @Override
   public void failedToRollback(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222260: Failed to perform rollback", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222261, value=\"Failed to activate a backup\", level=WARN)
   @Override
   public void failedToActivateBackup(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222261: Failed to activate a backup", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222262, value=\"Failed to stop cluster manager\", level=WARN)
   @Override
   public void failedToStopClusterManager(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222262: Failed to stop cluster manager", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222263, value=\"Failed to stop cluster connection\", level=WARN)
   @Override
   public void failedToStopClusterConnection(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222263: Failed to stop cluster connection", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222264, value=\"Failed to process message reference after rollback\", level=WARN)
   @Override
   public void failedToProcessMessageReferenceAfterRollback(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222264: Failed to process message reference after rollback", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222265, value=\"Failed to finish delivery, unable to lock delivery\", level=WARN)
   @Override
   public void failedToFinishDelivery(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222265: Failed to finish delivery, unable to lock delivery", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222266, value=\"Failed to send request to the node\", level=WARN)
   @Override
   public void failedToSendRequestToNode(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222266: Failed to send request to the node", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222267, value=\"Failed to disconnect bindings\", level=WARN)
   @Override
   public void failedToDisconnectBindings(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222267: Failed to disconnect bindings", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222268, value=\"Failed to remove a record\", level=WARN)
   @Override
   public void failedToRemoveRecord(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222268: Failed to remove a record", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222269, value=\"Please use a fixed value for \\"journal-pool-files\\". Default changed per https://issues.apache.org/jira/browse/ARTEMIS-1628\", level=WARN)
   @Override
   public void useFixedValueOnJournalPoolFiles() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222269: Please use a fixed value for \"journal-pool-files\". Default changed per https://issues.apache.org/jira/browse/ARTEMIS-1628");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222270, value=\"Unable to create management notification address: {}\", level=WARN)
   @Override
   public void unableToCreateManagementNotificationAddress(org.apache.activemq.artemis.api.core.SimpleString addressName, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222270: Unable to create management notification address: {}", addressName, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222702, value=\"Message ack in prepared tx for queue {} which does not exist. This ack will be ignored.\", level=WARN)
   @Override
   public void journalMessageAckMissingQueueInPreparedTX(java.lang.Long queueID) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222702: Message ack in prepared tx for queue {} which does not exist. This ack will be ignored.", queueID);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222703, value=\"Address \\"{}\\" is full. Bridge {} will disconnect\", level=WARN)
   @Override
   public void bridgeAddressFull(java.lang.String addressName, java.lang.String bridgeName) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222703: Address \"{}\" is full. Bridge {} will disconnect", addressName, bridgeName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222274, value=\"Failed to deploy address {}: {}\", level=WARN)
   @Override
   public void problemDeployingAddress(java.lang.String addressName, java.lang.String message) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222274: Failed to deploy address {}: {}", addressName, message);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222275, value=\"Failed to deploy queue {}: {}\", level=WARN)
   @Override
   public void problemDeployingQueue(java.lang.String queueName, java.lang.String message) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222275: Failed to deploy queue {}: {}", queueName, message);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222278, value=\"Unable to extract GroupSequence from message\", level=WARN)
   @Override
   public void unableToExtractGroupSequence(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222278: Unable to extract GroupSequence from message", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222279, value=\"Federation upstream {} policy ref {} could not be resolved in federation configuration\", level=WARN)
   @Override
   public void federationCantFindPolicyRef(java.lang.String upstreamName, java.lang.String policyRef) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222279: Federation upstream {} policy ref {} could not be resolved in federation configuration", upstreamName, policyRef);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222280, value=\"Federation upstream {} policy ref {} is of unknown type in federation configuration\", level=WARN)
   @Override
   public void federationUnknownPolicyType(java.lang.String upstreamName, java.lang.String policyRef) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222280: Federation upstream {} policy ref {} is of unknown type in federation configuration", upstreamName, policyRef);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222281, value=\"Federation upstream {} policy ref {} are too self referential, avoiding stack overflow , \", level=WARN)
   @Override
   public void federationAvoidStackOverflowPolicyRef(java.lang.String upstreamName, java.lang.String policyRef) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222281: Federation upstream {} policy ref {} are too self referential, avoiding stack overflow , ", upstreamName, policyRef);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222282, value=\"Federation downstream {} upstream transport configuration ref {} could not be resolved in federation configuration\", level=WARN)
   @Override
   public void federationCantFindUpstreamConnector(java.lang.String downstreamName, java.lang.String upstreamRef) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222282: Federation downstream {} upstream transport configuration ref {} could not be resolved in federation configuration", downstreamName, upstreamRef);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222283, value=\"Federation downstream {} has been deployed\", level=INFO)
   @Override
   public void federationDownstreamDeployed(java.lang.String downstreamName) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ222283: Federation downstream {} has been deployed", downstreamName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222284, value=\"Federation downstream {} has been undeployed\", level=INFO)
   @Override
   public void federationDownstreamUnDeployed(java.lang.String downstreamName) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ222284: Federation downstream {} has been undeployed", downstreamName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222285, value=\"File {} at {} is empty. Delete the empty file to stop this message.\", level=WARN)
   @Override
   public void emptyAddressFile(java.lang.String addressFile, java.lang.String directory) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222285: File {} at {} is empty. Delete the empty file to stop this message.", addressFile, directory);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222286, value=\"Error executing {} federation plugin method.\", level=WARN)
   @Override
   public void federationPluginExecutionError(java.lang.String pluginMethod, java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222286: Error executing {} federation plugin method.", pluginMethod, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222287, value=\"Error looking up bindings for address {}.\", level=WARN)
   @Override
   public void federationBindingsLookupError(org.apache.activemq.artemis.api.core.SimpleString address, java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222287: Error looking up bindings for address {}.", address, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222288, value=\"Page {}, message {} could not be found on offset {}, with starting message {}. This represents a logic error or inconsistency on the data, and the system will try once again from the beggining of the page file.\", level=WARN)
   @Override
   public void pageLookupError(long pageNr, int messageNr, int offset, int startNr) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222288: Page {}, message {} could not be found on offset {}, with starting message {}. This represents a logic error or inconsistency on the data, and the system will try once again from the beggining of the page file.", pageNr, messageNr, offset, startNr);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222289, value=\"Did not route to any matching bindings on dead-letter-address {} and auto-create-dead-letter-resources is true; dropping message: {}\", level=WARN)
   @Override
   public void noMatchingBindingsOnDLAWithAutoCreateDLAResources(org.apache.activemq.artemis.api.core.SimpleString address, java.lang.String message) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222289: Did not route to any matching bindings on dead-letter-address {} and auto-create-dead-letter-resources is true; dropping message: {}", address, message);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222290, value=\"Failed to find cluster-connection when handling cluster-connect packet. Ignoring: {}\", level=WARN)
   @Override
   public void failedToFindClusterConnection(java.lang.String packet) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222290: Failed to find cluster-connection when handling cluster-connect packet. Ignoring: {}", packet);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222291, value=\"The metrics-plugin element is deprecated and replaced by the metrics element\", level=WARN)
   @Override
   public void metricsPluginElementDeprecated() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222291: The metrics-plugin element is deprecated and replaced by the metrics element");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222292, value=\"The metrics-plugin element is ignored because the metrics element is defined\", level=WARN)
   @Override
   public void metricsPluginElementIgnored() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222292: The metrics-plugin element is ignored because the metrics element is defined");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222294, value=\"There is a possible split brain on nodeID {}, coming from connectors {}. Topology update ignored.\", level=WARN)
   @Override
   public void possibleSplitBrain(java.lang.String nodeID, java.lang.String connectionPairInformation) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222294: There is a possible split brain on nodeID {}, coming from connectors {}. Topology update ignored.", nodeID, connectionPairInformation);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222295, value=\"There is a possible split brain on nodeID {}. Topology update ignored\", level=WARN)
   @Override
   public void possibleSplitBrain(java.lang.String nodeID) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222295: There is a possible split brain on nodeID {}. Topology update ignored", nodeID);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222296, value=\"Unable to deploy Hawtio MBeam, console client side RBAC not available\", level=WARN)
   @Override
   public void unableToDeployHawtioMBean(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222296: Unable to deploy Hawtio MBeam, console client side RBAC not available", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222297, value=\"Unable to start Management Context, RBAC not available\", level=WARN)
   @Override
   public void unableStartManagementContext(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222297: Unable to start Management Context, RBAC not available", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222298, value=\"Failed to create bootstrap user \\"{}\\". User management may not function.\", level=WARN)
   @Override
   public void failedToCreateBootstrapCredentials(java.lang.String user, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222298: Failed to create bootstrap user \"{}\". User management may not function.", user, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222299, value=\"No bootstrap credentials found. User management may not function.\", level=WARN)
   @Override
   public void noBootstrapCredentialsFound() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222299: No bootstrap credentials found. User management may not function.");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222300, value=\"Getting SSL handler failed when serving client from {}: {}.\", level=WARN)
   @Override
   public void gettingSslHandlerFailed(java.lang.String clientAddress, java.lang.String cause) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222300: Getting SSL handler failed when serving client from {}: {}.", clientAddress, cause);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222301, value=\"Duplicate address-setting match found: {}. These settings will be ignored! Please review your broker.xml and consolidate any duplicate address-setting elements.\", level=WARN)
   @Override
   public void duplicateAddressSettingMatch(java.lang.String match) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222301: Duplicate address-setting match found: {}. These settings will be ignored! Please review your broker.xml and consolidate any duplicate address-setting elements.", match);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222302, value=\"Failed to deal with property {} when converting message from core to OpenWire: {}\", level=WARN)
   @Override
   public void failedToDealWithObjectProperty(org.apache.activemq.artemis.api.core.SimpleString property, java.lang.String exceptionMessage) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222302: Failed to deal with property {} when converting message from core to OpenWire: {}", property, exceptionMessage);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222303, value=\"Redistribution by {} of messageID = {} failed\", level=WARN)
   @Override
   public void errorRedistributing(java.lang.String queueName, long m, java.lang.Throwable t) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222303: Redistribution by {} of messageID = {} failed", queueName, m, t);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222304, value=\"Unable to load message from journal\", level=WARN)
   @Override
   public void unableToLoadMessageFromJournal(java.lang.Throwable t) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222304: Unable to load message from journal", t);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222305, value=\"Error federating message {}.\", level=WARN)
   @Override
   public void federationDispatchError(java.lang.String message, java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222305: Error federating message {}.", message, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222306, value=\"Failed to load prepared TX and it will be rolled back: {}\", level=WARN)
   @Override
   public void failedToLoadPreparedTX(java.lang.String message, java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222306: Failed to load prepared TX and it will be rolled back: {}", message, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222307, value=\"The queues element is deprecated and replaced by the addresses element\", level=WARN)
   @Override
   public void queuesElementDeprecated() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222307: The queues element is deprecated and replaced by the addresses element");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222308, value=\"Unable to listen for incoming fail-back request because {} is null. Ensure the broker has the proper cluster-connection configuration.\", level=WARN)
   @Override
   public void failBackCheckerFailure(java.lang.String component) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222308: Unable to listen for incoming fail-back request because {} is null. Ensure the broker has the proper cluster-connection configuration.", component);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222309, value=\"Trying to remove a producer with ID {} that doesnt exist from session {} on Connection {}.\", level=WARN)
   @Override
   public void producerDoesNotExist(int id, java.lang.String session, java.lang.String remoteAddress) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222309: Trying to remove a producer with ID {} that doesnt exist from session {} on Connection {}.", id, session, remoteAddress);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=222310, value=\"Trying to add a producer with ID {} that already exists to session {} on Connection {}.\", level=WARN)
   @Override
   public void producerAlreadyExists(int id, java.lang.String session, java.lang.String remoteAddress) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ222310: Trying to add a producer with ID {} that already exists to session {} on Connection {}.", id, session, remoteAddress);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224000, value=\"Failure in initialisation\", level=ERROR)
   @Override
   public void initializationError(java.lang.Throwable e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224000: Failure in initialisation", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224001, value=\"Error deploying URI {}\", level=ERROR)
   @Override
   public void errorDeployingURI(java.net.URI uri, java.lang.Throwable e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224001: Error deploying URI {}", uri, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224002, value=\"Error deploying URI\", level=ERROR)
   @Override
   public void errorDeployingURI(java.lang.Throwable e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224002: Error deploying URI", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224003, value=\"Error undeploying URI {}\", level=ERROR)
   @Override
   public void errorUnDeployingURI(java.net.URI a, java.lang.Throwable e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224003: Error undeploying URI {}", a, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224005, value=\"Unable to deploy node {}\", level=ERROR)
   @Override
   public void unableToDeployNode(org.w3c.dom.Node node, java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224005: Unable to deploy node {}", node, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224006, value=\"Invalid filter: {}\", level=ERROR)
   @Override
   public void invalidFilter(org.apache.activemq.artemis.api.core.SimpleString filter) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224006: Invalid filter: {}", filter);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224007, value=\"page subscription = {} error={}\", level=ERROR)
   @Override
   public void pageSubscriptionError(org.apache.activemq.artemis.core.io.IOCallback IOCallback, java.lang.String error) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224007: page subscription = {} error={}", IOCallback, error);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224008, value=\"Failed to store id\", level=ERROR)
   @Override
   public void batchingIdError(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224008: Failed to store id", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224009, value=\"Cannot find message {}\", level=ERROR)
   @Override
   public void cannotFindMessage(java.lang.Long id) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224009: Cannot find message {}", id);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224010, value=\"Cannot find queue messages for queueID={} on ack for messageID={}\", level=ERROR)
   @Override
   public void journalCannotFindQueue(java.lang.Long queue, java.lang.Long id) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224010: Cannot find queue messages for queueID={} on ack for messageID={}", queue, id);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224011, value=\"Cannot find queue messages {} for message {} while processing scheduled messages\", level=ERROR)
   @Override
   public void journalCannotFindQueueScheduled(java.lang.Long queue, java.lang.Long id) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224011: Cannot find queue messages {} for message {} while processing scheduled messages", queue, id);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224012, value=\"error releasing resources\", level=ERROR)
   @Override
   public void largeMessageErrorReleasingResources(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224012: error releasing resources", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224014, value=\"Failed to close session\", level=ERROR)
   @Override
   public void errorClosingSession(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224014: Failed to close session", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224015, value=\"Caught XA exception\", level=ERROR)
   @Override
   public void caughtXaException(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224015: Caught XA exception", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224016, value=\"Caught exception\", level=ERROR)
   @Override
   public void caughtException(java.lang.Throwable e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224016: Caught exception", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224017, value=\"Invalid packet {}\", level=ERROR)
   @Override
   public void invalidPacket(org.apache.activemq.artemis.core.protocol.core.Packet packet) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224017: Invalid packet {}", packet);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224018, value=\"Failed to create session\", level=ERROR)
   @Override
   public void failedToCreateSession(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224018: Failed to create session", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224019, value=\"Failed to reattach session\", level=ERROR)
   @Override
   public void failedToReattachSession(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224019: Failed to reattach session", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224020, value=\"Failed to handle create queue\", level=ERROR)
   @Override
   public void failedToHandleCreateQueue(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224020: Failed to handle create queue", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224021, value=\"Failed to decode packet\", level=ERROR)
   @Override
   public void errorDecodingPacket(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224021: Failed to decode packet", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224022, value=\"Failed to execute failure listener\", level=ERROR)
   @Override
   public void errorCallingFailureListener(java.lang.Throwable e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224022: Failed to execute failure listener", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224024, value=\"Stomp Error, tx already exist! {}\", level=ERROR)
   @Override
   public void stompErrorTXExists(java.lang.String txID) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224024: Stomp Error, tx already exist! {}", txID);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224027, value=\"Failed to write to handler on invm connector {}\", level=ERROR)
   @Override
   public void errorWritingToInvmConnector(java.lang.Runnable runnable, java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224027: Failed to write to handler on invm connector {}", runnable, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224028, value=\"Failed to stop acceptor {}\", level=ERROR)
   @Override
   public void errorStoppingAcceptor(java.lang.String name) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224028: Failed to stop acceptor {}", name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224029, value=\"large message sync: largeMessage instance is incompatible with it, ignoring data\", level=ERROR)
   @Override
   public void largeMessageIncompatible() {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224029: large message sync: largeMessage instance is incompatible with it, ignoring data");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224030, value=\"Could not cancel reference {}\", level=ERROR)
   @Override
   public void errorCancellingRefOnBridge(org.apache.activemq.artemis.core.server.MessageReference ref2, java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224030: Could not cancel reference {}", ref2, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224032, value=\"Failed to pause bridge\", level=ERROR)
   @Override
   public void errorPausingBridge(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224032: Failed to pause bridge", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224033, value=\"Failed to broadcast connector configs\", level=ERROR)
   @Override
   public void errorBroadcastingConnectorConfigs(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224033: Failed to broadcast connector configs", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224034, value=\"Failed to close consumer\", level=ERROR)
   @Override
   public void errorClosingConsumer(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224034: Failed to close consumer", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224035, value=\"Failed to close cluster connection flow record\", level=ERROR)
   @Override
   public void errorClosingFlowRecord(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224035: Failed to close cluster connection flow record", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224036, value=\"Failed to update cluster connection topology\", level=ERROR)
   @Override
   public void errorUpdatingTopology(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224036: Failed to update cluster connection topology", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224037, value=\"cluster connection Failed to handle message\", level=ERROR)
   @Override
   public void errorHandlingMessage(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224037: cluster connection Failed to handle message", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224038, value=\"Failed to ack old reference\", level=ERROR)
   @Override
   public void errorAckingOldReference(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224038: Failed to ack old reference", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224039, value=\"Failed to expire message reference\", level=ERROR)
   @Override
   public void errorExpiringRef(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224039: Failed to expire message reference", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224040, value=\"Failed to remove consumer\", level=ERROR)
   @Override
   public void errorRemovingConsumer(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224040: Failed to remove consumer", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224041, value=\"Failed to deliver\", level=ERROR)
   @Override
   public void errorDelivering(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224041: Failed to deliver", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224042, value=\"Error while restarting the backup server: {}\", level=ERROR)
   @Override
   public void errorRestartingBackupServer(org.apache.activemq.artemis.core.server.ActiveMQServer backup, java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224042: Error while restarting the backup server: {}", backup, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224043, value=\"Failed to send forced delivery message\", level=ERROR)
   @Override
   public void errorSendingForcedDelivery(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224043: Failed to send forced delivery message", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224044, value=\"error acknowledging message\", level=ERROR)
   @Override
   public void errorAckingMessage(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224044: error acknowledging message", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224045, value=\"Failed to run large message deliverer\", level=ERROR)
   @Override
   public void errorRunningLargeMessageDeliverer(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224045: Failed to run large message deliverer", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224046, value=\"Exception while browser handled from {}\", level=ERROR)
   @Override
   public void errorBrowserHandlingMessage(org.apache.activemq.artemis.core.server.MessageReference current, java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224046: Exception while browser handled from {}", current, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224047, value=\"Failed to delete large message file\", level=ERROR)
   @Override
   public void errorDeletingLargeMessageFile(java.lang.Throwable e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224047: Failed to delete large message file", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224048, value=\"Failed to remove temporary queue {}\", level=ERROR)
   @Override
   public void errorRemovingTempQueue(org.apache.activemq.artemis.api.core.SimpleString bindingName, java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224048: Failed to remove temporary queue {}", bindingName, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224049, value=\"Cannot find consumer with id {}\", level=ERROR)
   @Override
   public void cannotFindConsumer(long consumerID) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224049: Cannot find consumer with id {}", consumerID);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224050, value=\"Failed to close connection {}\", level=ERROR)
   @Override
   public void errorClosingConnection(org.apache.activemq.artemis.core.server.impl.ServerSessionImpl serverSession) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224050: Failed to close connection {}", serverSession);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224051, value=\"Failed to call notification listener\", level=ERROR)
   @Override
   public void errorCallingNotifListener(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224051: Failed to call notification listener", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224052, value=\"Unable to call Hierarchical Repository Change Listener\", level=ERROR)
   @Override
   public void errorCallingRepoListener(java.lang.Throwable e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224052: Unable to call Hierarchical Repository Change Listener", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224053, value=\"failed to timeout transaction, xid:{}\", level=ERROR)
   @Override
   public void errorTimingOutTX(javax.transaction.xa.Xid xid, java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224053: failed to timeout transaction, xid:{}", xid, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224054, value=\"exception while stopping the replication manager\", level=ERROR)
   @Override
   public void errorStoppingReplicationManager(java.lang.Throwable t) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224054: exception while stopping the replication manager", t);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224055, value=\"Bridge Failed to ack\", level=ERROR)
   @Override
   public void bridgeFailedToAck(java.lang.Throwable t) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224055: Bridge Failed to ack", t);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224056, value=\"Live server will not fail-back automatically\", level=ERROR)
   @Override
   public void autoFailBackDenied() {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224056: Live server will not fail-back automatically");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224057, value=\"Backup server that requested fail-back was not announced. Server will not stop for fail-back.\", level=ERROR)
   @Override
   public void failbackMissedBackupAnnouncement() {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224057: Backup server that requested fail-back was not announced. Server will not stop for fail-back.");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224058, value=\"Stopping ClusterManager. As it failed to authenticate with the cluster: {}\", level=ERROR)
   @Override
   public void clusterManagerAuthenticationError(java.lang.String msg) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224058: Stopping ClusterManager. As it failed to authenticate with the cluster: {}", msg);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224059, value=\"Invalid cipher suite specified. Supported cipher suites are: {}\", level=ERROR)
   @Override
   public void invalidCipherSuite(java.lang.String validSuites) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224059: Invalid cipher suite specified. Supported cipher suites are: {}", validSuites);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224060, value=\"Invalid protocol specified. Supported protocols are: {}\", level=ERROR)
   @Override
   public void invalidProtocol(java.lang.String validProtocols) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224060: Invalid protocol specified. Supported protocols are: {}", validProtocols);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224061, value=\"Setting both <{}> and <ha-policy> is invalid. Please use <ha-policy> exclusively. Ignoring value.\", level=ERROR)
   @Override
   public void incompatibleWithHAPolicy(java.lang.String parameter) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224061: Setting both <{}> and <ha-policy> is invalid. Please use <ha-policy> exclusively. Ignoring value.", parameter);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224062, value=\"Failed to send SLOW_CONSUMER notification: {}\", level=ERROR)
   @Override
   public void failedToSendSlowConsumerNotification(org.apache.activemq.artemis.core.server.management.Notification notification, java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224062: Failed to send SLOW_CONSUMER notification: {}", notification, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224063, value=\"Failed to close consumer connections for address {}\", level=ERROR)
   @Override
   public void failedToCloseConsumerConnectionsForAddress(java.lang.String address, java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224063: Failed to close consumer connections for address {}", address, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224064, value=\"Setting <{}> is invalid with this HA Policy Configuration. Please use <ha-policy> exclusively or remove. Ignoring value.\", level=ERROR)
   @Override
   public void incompatibleWithHAPolicyChosen(java.lang.String parameter) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224064: Setting <{}> is invalid with this HA Policy Configuration. Please use <ha-policy> exclusively or remove. Ignoring value.", parameter);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224065, value=\"Failed to remove auto-created {} {}\", level=ERROR)
   @Override
   public void errorRemovingAutoCreatedDestination(java.lang.String destinationType, org.apache.activemq.artemis.api.core.SimpleString bindingName, java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224065: Failed to remove auto-created {} {}", destinationType, bindingName, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224066, value=\"Error opening context for LDAP\", level=ERROR)
   @Override
   public void errorOpeningContextForLDAP(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224066: Error opening context for LDAP", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224067, value=\"Error populating security roles from LDAP\", level=ERROR)
   @Override
   public void errorPopulatingSecurityRolesFromLDAP(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224067: Error populating security roles from LDAP", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224068, value=\"Unable to stop component: {}\", level=ERROR)
   @Override
   public void errorStoppingComponent(java.lang.String componentClassName, java.lang.Throwable t) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224068: Unable to stop component: {}", componentClassName, t);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224069, value=\"Change detected in broker configuration file, but reload failed\", level=ERROR)
   @Override
   public void configurationReloadFailed(java.lang.Throwable t) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224069: Change detected in broker configuration file, but reload failed", t);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224072, value=\"Message Counter Sample Period too short: {}\", level=WARN)
   @Override
   public void invalidMessageCounterPeriod(long value) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ224072: Message Counter Sample Period too short: {}", value);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224073, value=\"Using MAPPED Journal\", level=INFO)
   @Override
   public void journalUseMAPPED() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ224073: Using MAPPED Journal");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224074, value=\"Failed to purge queue {} on no consumers\", level=ERROR)
   @Override
   public void failedToPurgeQueue(org.apache.activemq.artemis.api.core.SimpleString bindingName, java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224074: Failed to purge queue {} on no consumers", bindingName, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224075, value=\"Cannot find pageTX id = {}\", level=ERROR)
   @Override
   public void journalCannotFindPageTX(java.lang.Long id) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224075: Cannot find pageTX id = {}", id);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224079, value=\"The process for the virtual machine will be killed, as component {} is not responsive\", level=ERROR)
   @Override
   public void criticalSystemHalt(java.lang.Object component) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224079: The process for the virtual machine will be killed, as component {} is not responsive", component);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224080, value=\"The server process will now be stopped, as component {} is not responsive\", level=ERROR)
   @Override
   public void criticalSystemShutdown(java.lang.Object component) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224080: The server process will now be stopped, as component {} is not responsive", component);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224081, value=\"The component {} is not responsive\", level=WARN)
   @Override
   public void criticalSystemLog(java.lang.Object component) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ224081: The component {} is not responsive", component);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224076, value=\"Undeploying address {}\", level=INFO)
   @Override
   public void undeployAddress(org.apache.activemq.artemis.api.core.SimpleString addressName) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ224076: Undeploying address {}", addressName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224077, value=\"Undeploying queue {}\", level=INFO)
   @Override
   public void undeployQueue(org.apache.activemq.artemis.api.core.SimpleString queueName) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ224077: Undeploying queue {}", queueName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224078, value=\"The size of duplicate cache detection (<id_cache-size/>) appears to be too large {}. It should be no greater than the number of messages that can be squeezed into confirmation window buffer (<confirmation-window-size/>) {}.\", level=WARN)
   @Override
   public void duplicateCacheSizeWarning(int idCacheSize, int confirmationWindowSize) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ224078: The size of duplicate cache detection (<id_cache-size/>) appears to be too large {}. It should be no greater than the number of messages that can be squeezed into confirmation window buffer (<confirmation-window-size/>) {}.", idCacheSize, confirmationWindowSize);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224082, value=\"Failed to invoke an interceptor\", level=ERROR)
   @Override
   public void failedToInvokeAnInterceptor(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224082: Failed to invoke an interceptor", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224083, value=\"Failed to close context\", level=ERROR)
   @Override
   public void failedToCloseContext(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224083: Failed to close context", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224084, value=\"Failed to open context\", level=ERROR)
   @Override
   public void failedToOpenContext(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224084: Failed to open context", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224085, value=\"Failed to load property {}, reason: {}\", level=ERROR)
   @Override
   public void failedToLoadProperty(java.lang.String key, java.lang.String reason, java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224085: Failed to load property {}, reason: {}", key, reason, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224086, value=\"Caught unexpected exception\", level=ERROR)
   @Override
   public void caughtUnexpectedException(javax.naming.NamingException e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224086: Caught unexpected exception", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224087, value=\"Error announcing backup: backupServerLocator is null. {}\", level=ERROR)
   @Override
   public void errorAnnouncingBackup(java.lang.String backupManager) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224087: Error announcing backup: backupServerLocator is null. {}", backupManager);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224088, value=\"Timeout ({} seconds) on acceptor \\"{}\\" during protocol handshake with {} has occurred.\", level=ERROR)
   @Override
   public void handshakeTimeout(int timeout, java.lang.String acceptorName, java.lang.String remoteAddress) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224088: Timeout ({} seconds) on acceptor \"{}\" during protocol handshake with {} has occurred.", timeout, acceptorName, remoteAddress);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224089, value=\"Failed to calculate persistent size\", level=WARN)
   @Override
   public void errorCalculatePersistentSize(java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ224089: Failed to calculate persistent size", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224090, value=\"This node is not configured for Quorum Voting, all nodes must be configured for HA\", level=WARN)
   @Override
   public void noVoteHandlerConfigured() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ224090: This node is not configured for Quorum Voting, all nodes must be configured for HA");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224091, value=\"Bridge {} is unable to connect to destination. Retrying\", level=WARN)
   @Override
   public void errorConnectingBridgeRetry(org.apache.activemq.artemis.core.server.cluster.Bridge bridge) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ224091: Bridge {} is unable to connect to destination. Retrying", bridge);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224092, value=\"Despite disabled persistence, page files will be persisted.\", level=INFO)
   @Override
   public void pageWillBePersisted() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ224092: Despite disabled persistence, page files will be persisted.");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224093, value=\"Reference to message is null\", level=ERROR)
   @Override
   public void nullRefMessage() {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224093: Reference to message is null");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224094, value=\"Quorum vote result await is interrupted\", level=TRACE)
   @Override
   public void quorumVoteAwaitInterrupted() {
      if (logger.isTraceEnabled()) {
         logger.trace("AMQ224094: Quorum vote result await is interrupted");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224095, value=\"Error updating Consumer Count: {}\", level=ERROR)
   @Override
   public void consumerCountError(java.lang.String reason) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224095: Error updating Consumer Count: {}", reason);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224096, value=\"Error setting up connection from {} to {}; protocol {} not found in map: {}\", level=ERROR)
   @Override
   public void failedToFindProtocolManager(java.lang.String remoteAddress, java.lang.String localAddress, java.lang.String intendedProtocolManager, java.lang.String protocolMap) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224096: Error setting up connection from {} to {}; protocol {} not found in map: {}", remoteAddress, localAddress, intendedProtocolManager, protocolMap);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224097, value=\"Failed to start server\", level=ERROR)
   @Override
   public void failedToStartServer(java.lang.Throwable t) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224097: Failed to start server", t);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224098, value=\"Received a vote saying the backup is live with connector: {}\", level=INFO)
   @Override
   public void quorumBackupIsLive(java.lang.String liveConnector) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ224098: Received a vote saying the backup is live with connector: {}", liveConnector);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224099, value=\"Message with ID {} has a header too large. More information available on debug level for class {}\", level=WARN)
   @Override
   public void messageWithHeaderTooLarge(java.lang.Long messageID, java.lang.String loggerClass) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ224099: Message with ID {} has a header too large. More information available on debug level for class {}", messageID, loggerClass);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224100, value=\"Timed out waiting for large messages deletion with IDs {}, might not be deleted if broker crashes atm\", level=INFO)
   @Override
   public void timedOutWaitingForLargeMessagesDeletion(java.util.List<java.lang.Long> largeMessageIds) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ224100: Timed out waiting for large messages deletion with IDs {}, might not be deleted if broker crashes atm", largeMessageIds);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224101, value=\"Apache ActiveMQ Artemis is using a scheduled pool without remove on cancel policy, so a cancelled task could be not automatically removed from the work queue, it may also cause unbounded retention of cancelled tasks.\", level=WARN)
   @Override
   public void scheduledPoolWithNoRemoveOnCancelPolicy() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ224101: Apache ActiveMQ Artemis is using a scheduled pool without remove on cancel policy, so a cancelled task could be not automatically removed from the work queue, it may also cause unbounded retention of cancelled tasks.");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224102, value=\"unable to undeploy address {} : reason {}\", level=INFO)
   @Override
   public void unableToUndeployAddress(org.apache.activemq.artemis.api.core.SimpleString addressName, java.lang.String reason) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ224102: unable to undeploy address {} : reason {}", addressName, reason);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224103, value=\"unable to undeploy queue {} : reason {}\", level=INFO)
   @Override
   public void unableToUndeployQueue(org.apache.activemq.artemis.api.core.SimpleString queueName, java.lang.String reason) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ224103: unable to undeploy queue {} : reason {}", queueName, reason);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224104, value=\"Error starting the Acceptor {} {}\", level=ERROR)
   @Override
   public void errorStartingAcceptor(java.lang.String name, java.lang.Object configuration) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224104: Error starting the Acceptor {} {}", name, configuration);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224105, value=\"Connecting to cluster failed\", level=WARN)
   @Override
   public void failedConnectingToCluster(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ224105: Connecting to cluster failed", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224106, value=\"failed to remove transaction, xid:{}\", level=ERROR)
   @Override
   public void errorRemovingTX(javax.transaction.xa.Xid xid, java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224106: failed to remove transaction, xid:{}", xid, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224107, value=\"The Critical Analyzer detected slow paths on the broker.  It is recommended that you enable trace logs on org.apache.activemq.artemis.utils.critical while you troubleshoot this issue. You should disable the trace logs when you have finished troubleshooting.\", level=INFO)
   @Override
   public void enableTraceForCriticalAnalyzer() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ224107: The Critical Analyzer detected slow paths on the broker.  It is recommended that you enable trace logs on org.apache.activemq.artemis.utils.critical while you troubleshoot this issue. You should disable the trace logs when you have finished troubleshooting.");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224108, value=\"Stopped paging on address '{}'; {}\", level=INFO)
   @Override
   public void pageStoreStop(org.apache.activemq.artemis.api.core.SimpleString storeName, java.lang.String pageInfo) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ224108: Stopped paging on address '{}'; {}", storeName, pageInfo);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224109, value=\"ConnectionRouter {} not found\", level=WARN)
   @Override
   public void connectionRouterNotFound(java.lang.String name) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ224109: ConnectionRouter {} not found", name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224110, value=\"Configuration 'whitelist' is deprecated, please use the 'allowlist' configuration\", level=WARN)
   @Override
   public void useAllowList() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ224110: Configuration 'whitelist' is deprecated, please use the 'allowlist' configuration");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224111, value=\"Both 'whitelist' and 'allowlist' detected. Configuration 'whitelist' is deprecated, please use only the 'allowlist' configuration\", level=WARN)
   @Override
   public void useOnlyAllowList() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ224111: Both 'whitelist' and 'allowlist' detected. Configuration 'whitelist' is deprecated, please use only the 'allowlist' configuration");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224112, value=\"Auto removing queue {} with queueID={} on address={}\", level=INFO)
   @Override
   public void autoRemoveQueue(java.lang.String name, long queueID, java.lang.String address) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ224112: Auto removing queue {} with queueID={} on address={}", name, queueID, address);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224113, value=\"Auto removing address {}\", level=INFO)
   @Override
   public void autoRemoveAddress(java.lang.String name) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ224113: Auto removing address {}", name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224114, value=\"Address control block, blocking message production on address '{}'. Clients will not get further credit.\", level=INFO)
   @Override
   public void blockingViaControl(org.apache.activemq.artemis.api.core.SimpleString addressName) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ224114: Address control block, blocking message production on address '{}'. Clients will not get further credit.", addressName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224115, value=\"Address control unblock of address '{}'. Clients will be granted credit as normal.\", level=INFO)
   @Override
   public void unblockingViaControl(org.apache.activemq.artemis.api.core.SimpleString addressName) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ224115: Address control unblock of address '{}'. Clients will be granted credit as normal.", addressName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224116, value=\"The component {} is not responsive during start up. The Server may be taking too long to start\", level=WARN)
   @Override
   public void tooLongToStart(java.lang.Object component) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ224116: The component {} is not responsive during start up. The Server may be taking too long to start", component);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224117, value=\"\\"page-max-cache-size\\" being used on broker.xml. This configuration attribute is no longer used and it will be ignored.\", level=INFO)
   @Override
   public void pageMaxSizeUsed() {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ224117: \"page-max-cache-size\" being used on broker.xml. This configuration attribute is no longer used and it will be ignored.");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224118, value=\"The SQL Database is returning a current time too far from this system current time. Adjust clock on the SQL Database server. DatabaseTime={}, CurrentTime={}, allowed variance={}\", level=WARN)
   @Override
   public void dbReturnedTimeOffClock(long dbTime, long systemTime, long variance) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ224118: The SQL Database is returning a current time too far from this system current time. Adjust clock on the SQL Database server. DatabaseTime={}, CurrentTime={}, allowed variance={}", dbTime, systemTime, variance);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224119, value=\"Unable to refresh security settings: {}\", level=WARN)
   @Override
   public void unableToRefreshSecuritySettings(java.lang.String exceptionMessage) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ224119: Unable to refresh security settings: {}", exceptionMessage);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224120, value=\"Queue {} on Address {} has more messages than configured page limit. PageLimitMesages={} while currentValue={}\", level=WARN)
   @Override
   public void pageFull(org.apache.activemq.artemis.api.core.SimpleString queue, org.apache.activemq.artemis.api.core.SimpleString address, java.lang.Object pageLImitMessage, java.lang.Object currentValue) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ224120: Queue {} on Address {} has more messages than configured page limit. PageLimitMesages={} while currentValue={}", queue, address, pageLImitMessage, currentValue);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224121, value=\"Queue {} on Address {} is out of page limit now. We will issue a cleanup to check other queues.\", level=WARN)
   @Override
   public void pageFree(org.apache.activemq.artemis.api.core.SimpleString queue, org.apache.activemq.artemis.api.core.SimpleString address) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ224121: Queue {} on Address {} is out of page limit now. We will issue a cleanup to check other queues.", queue, address);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224122, value=\"Address {} number of messages is under page limit again, and it should be allowed to page again.\", level=INFO)
   @Override
   public void pageFree(org.apache.activemq.artemis.api.core.SimpleString address) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ224122: Address {} number of messages is under page limit again, and it should be allowed to page again.", address);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224123, value=\"Address {} has more pages than allowed. System currently has {} pages, while the estimated max number of pages is {} based on the page-limit-bytes ({}) / page-size ({})\", level=WARN)
   @Override
   public void pageFullMaxBytes(org.apache.activemq.artemis.api.core.SimpleString address, long pages, java.lang.Long maxPages, java.lang.Long limitBytes, int bytes) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ224123: Address {} has more pages than allowed. System currently has {} pages, while the estimated max number of pages is {} based on the page-limit-bytes ({}) / page-size ({})", address, pages, maxPages, limitBytes, bytes);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224124, value=\"Address {} has page-full-policy={} but neither page-limit-bytes nor page-limit-messages are set. Page full configuration being ignored on this address.\", level=WARN)
   @Override
   public void noPageLimitsSet(java.lang.Object address, java.lang.Object policy) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ224124: Address {} has page-full-policy={} but neither page-limit-bytes nor page-limit-messages are set. Page full configuration being ignored on this address.", address, policy);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224125, value=\"Address {} has page-limit-bytes={} and page-limit-messages={} but no page-full-policy set. Page full configuration being ignored on this address\", level=WARN)
   @Override
   public void noPagefullPolicySet(java.lang.Object address, java.lang.Object limitBytes, java.lang.Object limitMessages) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ224125: Address {} has page-limit-bytes={} and page-limit-messages={} but no page-full-policy set. Page full configuration being ignored on this address", address, limitBytes, limitMessages);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=224126, value=\"Failure during protocol handshake on connection to {} from {}\", level=ERROR)
   @Override
   public void failureDuringProtocolHandshake(java.net.SocketAddress localAddress, java.net.SocketAddress remoteAddress, java.lang.Throwable e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ224126: Failure during protocol handshake on connection to {} from {}", localAddress, remoteAddress, e);
      }
   }

}
