/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.settings.impl;

import java.util.regex.Pattern;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;

public class Match<T> {
    private static final String WILDCARD_REPLACEMENT = ".*";
    private static final String WORD_WILDCARD_REPLACEMENT_FORMAT = "[^%s]+";
    private static final String WILDCARD_CHILD_REPLACEMENT_FORMAT = "(%s.+)*";
    private static final String DOT = ".";
    private static final String DOT_REPLACEMENT = "\\.";
    private final String match;
    private final Pattern pattern;
    private final T value;

    public Match(String match, T value, WildcardConfiguration wildcardConfiguration) {
        this.match = match;
        this.value = value;
        this.pattern = Match.createPattern(match, wildcardConfiguration, false);
    }

    public static Pattern createPattern(String match, WildcardConfiguration wildcardConfiguration, boolean direct) {
        String actMatch = match;
        if (wildcardConfiguration.getAnyWordsString().equals(match)) {
            actMatch = WILDCARD_REPLACEMENT;
        } else {
            if (!direct) {
                actMatch = actMatch.replace(wildcardConfiguration.getDelimiterString() + wildcardConfiguration.getAnyWordsString(), wildcardConfiguration.getAnyWordsString());
            }
            actMatch = actMatch.replace(DOT, DOT_REPLACEMENT);
            actMatch = actMatch.replace(wildcardConfiguration.getSingleWordString(), String.format(WORD_WILDCARD_REPLACEMENT_FORMAT, Pattern.quote(wildcardConfiguration.getDelimiterString())));
            actMatch = direct ? actMatch.replace(wildcardConfiguration.getAnyWordsString(), WILDCARD_REPLACEMENT) : actMatch.replace(wildcardConfiguration.getAnyWordsString(), String.format(WILDCARD_CHILD_REPLACEMENT_FORMAT, Pattern.quote(wildcardConfiguration.getDelimiterString())));
        }
        return Pattern.compile(actMatch + "$");
    }

    public final String getMatch() {
        return this.match;
    }

    public final Pattern getPattern() {
        return this.pattern;
    }

    public final T getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Match that = (Match)o;
        return !(this.match == null ? that.match != null : !this.match.equals(that.match));
    }

    public int hashCode() {
        return this.match != null ? this.match.hashCode() : 0;
    }

    public static void verify(String match, WildcardConfiguration wildcardConfiguration) throws IllegalArgumentException {
        if (match == null) {
            throw ActiveMQMessageBundle.BUNDLE.nullMatch();
        }
        String anyWords = wildcardConfiguration.getAnyWordsString();
        if (match.contains(anyWords) && match.indexOf(anyWords) < match.length() - 1) {
            throw ActiveMQMessageBundle.BUNDLE.invalidMatch();
        }
    }

    public String toString() {
        return this.value.toString();
    }
}

