/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.util.HostUtils;
import org.apache.camel.util.URISupport;

public final class RestComponentHelper {
    private RestComponentHelper() {
    }

    public static Map<String, Object> addHttpRestrictParam(Map<String, Object> queryMap, String verb, boolean addOptions) {
        Object restrict = verb.toUpperCase(Locale.US);
        if (addOptions) {
            restrict = (String)restrict + ",OPTIONS";
        }
        queryMap.put("httpMethodRestrict", restrict);
        return queryMap;
    }

    public static Map<String, Object> initRestEndpointProperties(String componentName, RestConfiguration config) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if ((config.getComponent() == null || config.getComponent().equals(componentName)) && config.getEndpointProperties() != null && !config.getEndpointProperties().isEmpty()) {
            map.putAll(config.getEndpointProperties());
        }
        return map;
    }

    public static String resolveRestHostName(String host, RestConfiguration config) throws UnknownHostException {
        if (config.getHostNameResolver() == RestConfiguration.RestHostNameResolver.allLocalIp) {
            host = "0.0.0.0";
        } else if (config.getHostNameResolver() == RestConfiguration.RestHostNameResolver.localHostName) {
            host = HostUtils.getLocalHostName();
        } else if (config.getHostNameResolver() == RestConfiguration.RestHostNameResolver.localIp) {
            host = HostUtils.getLocalIp();
        }
        return host;
    }

    public static String createRestConsumerUrl(String componentName, String verb, String path, Map<String, Object> queryMap) {
        String query = URISupport.createQueryString(queryMap);
        return RestComponentHelper.applyFormatAndQuery("%s:%s:%s", query, componentName, verb, path);
    }

    public static String createRestConsumerUrl(String componentName, String path, Map<String, Object> queryMap) {
        String query = URISupport.createQueryString(queryMap);
        return RestComponentHelper.applyFormatAndQuery("%s:/%s", query, componentName, path);
    }

    public static String createRestConsumerUrl(String componentName, String scheme, String host, int port, String path, Map<String, Object> queryMap) {
        String query = URISupport.createQueryString(queryMap);
        return RestComponentHelper.applyFormatAndQuery("%s:%s://%s:%s/%s", query, componentName, scheme, host, port, path);
    }

    private static String applyFormatAndQuery(String format, String query, Object ... formatOptions) {
        StringBuilder urlBuilder = new StringBuilder(String.format(format, formatOptions));
        if (!query.isEmpty()) {
            urlBuilder.append("?");
            urlBuilder.append(query);
        }
        return urlBuilder.toString();
    }
}

