/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.ldif.anonymizer;

import java.util.Map;
import java.util.Random;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.ldif.anonymizer.AbstractAnonymizer;

public class StringAnonymizer
extends AbstractAnonymizer<String> {
    Random random = new Random(System.currentTimeMillis());

    @Override
    public Attribute anonymize(Map<Value<String>, Value<String>> valueMap, Attribute attribute) {
        DefaultAttribute result = new DefaultAttribute(attribute.getAttributeType());
        this.random.setSeed(System.nanoTime());
        for (Value value : attribute) {
            Value<String> anonymized = valueMap.get(value);
            if (anonymized != null) {
                try {
                    result.add(anonymized.getString());
                }
                catch (LdapInvalidAttributeValueException ldapInvalidAttributeValueException) {}
                continue;
            }
            if (value instanceof StringValue) {
                String strValue = value.getNormValue().toString();
                int length = strValue.length();
                char[] newValue = new char[length];
                for (int i = 0; i < length; ++i) {
                    newValue[i] = (char)(this.random.nextInt(25) + 65);
                }
                try {
                    String newValueStr = new String(newValue);
                    result.add(newValueStr);
                    StringValue anonValue = new StringValue(attribute.getAttributeType(), newValueStr);
                    valueMap.put(value, anonValue);
                }
                catch (LdapInvalidAttributeValueException ldapInvalidAttributeValueException) {}
                continue;
            }
            byte[] byteValue = value.getBytes();
            byte[] newValue = new byte[byteValue.length];
            for (int i = 0; i < byteValue.length; ++i) {
                newValue[i] = (byte)this.random.nextInt();
            }
            try {
                result.add(new byte[][]{newValue});
            }
            catch (LdapInvalidAttributeValueException ldapInvalidAttributeValueException) {}
        }
        return result;
    }
}

