/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.message.InternalLdapResult;
import org.apache.directory.shared.ldap.message.InternalReferral;
import org.apache.directory.shared.ldap.message.InternalResultResponseRequest;
import org.apache.directory.shared.ldap.message.InternalSearchRequest;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.ReferralImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.apache.directory.shared.ldap.util.LdapURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReferralAwareRequestHandler<T extends InternalResultResponseRequest>
extends LdapRequestHandler<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ReferralAwareRequestHandler.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    @Override
    public final void handle(LdapSession session, T req) throws Exception {
        LOG.debug("Handling single reply request: {}", req);
        if (req.getControls().containsKey("2.16.840.1.113730.3.4.2")) {
            LOG.debug("ManageDsaITControl detected.");
            this.handleIgnoringReferrals(session, req);
        } else {
            LOG.debug("ManageDsaITControl NOT detected.");
            switch (req.getType()) {
                case SEARCH_REQUEST: {
                    this.handleWithReferrals(session, ((InternalSearchRequest)req).getBase(), req);
                    break;
                }
                case EXTENDED_REQ: {
                    throw new IllegalStateException("Although ExtendedRequests are SingleReplyRequests they're not handled using this base class.  They have no target entry unlike the rest of the SingleReplyRequests");
                }
                default: {
                    throw new IllegalStateException("Unidentified single reply request/response type: " + req);
                }
            }
        }
    }

    public static final boolean isEntryReferral(ClonedServerEntry entry) throws Exception {
        return entry.getOriginalEntry().contains("objectClass", new String[]{"referral"});
    }

    public static final ClonedServerEntry getFarthestReferralAncestor(LdapSession session, LdapDN target) throws Exception {
        ClonedServerEntry farthestReferralAncestor = null;
        LdapDN dn = (LdapDN)target.clone();
        try {
            dn.remove(dn.size() - 1);
        }
        catch (InvalidNameException e2) {
            // empty catch block
        }
        while (!dn.isEmpty()) {
            LOG.debug("Walking ancestors of {} to find referrals.", (Object)dn);
            try {
                ClonedServerEntry entry = session.getCoreSession().lookup(dn);
                if (ReferralAwareRequestHandler.isEntryReferral(entry)) {
                    farthestReferralAncestor = entry;
                }
                dn.remove(dn.size() - 1);
            }
            catch (NameNotFoundException e) {
                LOG.debug("Entry for {} not found.", (Object)dn);
                try {
                    dn.remove(dn.size() - 1);
                }
                catch (InvalidNameException e1) {}
            }
        }
        return farthestReferralAncestor;
    }

    public InternalReferral getReferralOnAncestor(LdapSession session, LdapDN reqTargetDn, T req, ClonedServerEntry referralAncestor) throws Exception {
        LOG.debug("Inside getReferralOnAncestor()");
        ServerAttribute refAttr = (ServerAttribute)referralAncestor.getOriginalEntry().get("ref");
        ReferralImpl referral = new ReferralImpl();
        for (Value value : refAttr) {
            String ref = value.getString();
            LOG.debug("Calculating LdapURL for referrence value {}", (Object)ref);
            if (!ref.startsWith("ldap")) {
                referral.addLdapUrl(ref);
                continue;
            }
            LdapURL ldapUrl = new LdapURL();
            try {
                ldapUrl.parse(ref.toCharArray());
            }
            catch (LdapURLEncodingException e) {
                LOG.error("Bad URL ({}) for ref in {}.  Reference will be ignored.", (Object)ref, (Object)referralAncestor);
            }
            LdapDN urlDn = new LdapDN(ldapUrl.getDn().getUpName());
            urlDn.normalize(session.getCoreSession().getDirectoryService().getRegistries().getAttributeTypeRegistry().getNormalizerMapping());
            if (urlDn.getNormName().equals(referralAncestor.getDn().getNormName())) {
                StringBuilder buf = new StringBuilder();
                buf.append(ldapUrl.getScheme());
                buf.append(ldapUrl.getHost());
                if (ldapUrl.getPort() > 0) {
                    buf.append(":");
                    buf.append(ldapUrl.getPort());
                }
                referral.addLdapUrl(buf.toString());
                continue;
            }
            int diff = reqTargetDn.size() - referralAncestor.getDn().size();
            LdapDN extra = new LdapDN();
            LdapDN reqUnnormalizedDn = new LdapDN(reqTargetDn.getUpName());
            for (int jj = 0; jj < diff; ++jj) {
                extra.add(reqUnnormalizedDn.get(referralAncestor.getDn().size() + jj));
            }
            urlDn.addAll((Name)extra);
            StringBuilder buf = new StringBuilder();
            buf.append(ldapUrl.getScheme());
            buf.append(ldapUrl.getHost());
            if (ldapUrl.getPort() > 0) {
                buf.append(":");
                buf.append(ldapUrl.getPort());
            }
            buf.append("/");
            buf.append(LdapURL.urlEncode((String)urlDn.getUpName(), (boolean)false));
            referral.addLdapUrl(buf.toString());
        }
        return referral;
    }

    public InternalReferral getReferralOnAncestorForSearch(LdapSession session, InternalSearchRequest req, ClonedServerEntry referralAncestor) throws Exception {
        LOG.debug("Inside getReferralOnAncestor()");
        ServerAttribute refAttr = (ServerAttribute)referralAncestor.getOriginalEntry().get("ref");
        ReferralImpl referral = new ReferralImpl();
        for (Value value : refAttr) {
            String ref = value.getString();
            LOG.debug("Calculating LdapURL for referrence value {}", (Object)ref);
            if (!ref.startsWith("ldap")) {
                referral.addLdapUrl(ref);
                continue;
            }
            LdapURL ldapUrl = new LdapURL();
            try {
                ldapUrl.parse(ref.toCharArray());
            }
            catch (LdapURLEncodingException e) {
                LOG.error("Bad URL ({}) for ref in {}.  Reference will be ignored.", (Object)ref, (Object)referralAncestor);
            }
            LdapDN urlDn = new LdapDN(ldapUrl.getDn().getUpName());
            urlDn.normalize(session.getCoreSession().getDirectoryService().getRegistries().getAttributeTypeRegistry().getNormalizerMapping());
            if (urlDn.getNormName().equals(req.getBase().getNormName())) {
                ldapUrl.setForceScopeRendering(true);
                ldapUrl.setAttributes(req.getAttributes());
                ldapUrl.setScope(req.getScope().getJndiScope());
                referral.addLdapUrl(ldapUrl.toString());
                continue;
            }
            int diff = req.getBase().size() - referralAncestor.getDn().size();
            LdapDN extra = new LdapDN();
            LdapDN reqUnnormalizedDn = new LdapDN(req.getBase().getUpName());
            for (int jj = 0; jj < diff; ++jj) {
                extra.add(reqUnnormalizedDn.get(referralAncestor.getDn().size() + jj));
            }
            ldapUrl.getDn().addAll((Name)extra);
            ldapUrl.setForceScopeRendering(true);
            ldapUrl.setAttributes(req.getAttributes());
            ldapUrl.setScope(req.getScope().getJndiScope());
            referral.addLdapUrl(ldapUrl.toString());
        }
        return referral;
    }

    @Override
    public void handleException(LdapSession session, InternalResultResponseRequest req, Exception e) {
        InternalLdapResult result = req.getResultResponse().getLdapResult();
        ResultCodeEnum code = e instanceof LdapException ? ((LdapException)e).getResultCode() : ResultCodeEnum.getBestEstimate((Throwable)e, (MessageTypeEnum)req.getType());
        result.setResultCode(code);
        String msg = code.toString() + ": failed for " + req + ": " + e.getMessage();
        LOG.debug(msg, (Throwable)e);
        if (IS_DEBUG) {
            msg = msg + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
        }
        result.setErrorMessage(msg);
        if (e instanceof NamingException) {
            boolean setMatchedDn;
            NamingException ne = (NamingException)e;
            boolean bl = setMatchedDn = code == ResultCodeEnum.NO_SUCH_OBJECT || code == ResultCodeEnum.ALIAS_PROBLEM || code == ResultCodeEnum.INVALID_DN_SYNTAX || code == ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM;
            if (ne.getResolvedName() != null && setMatchedDn) {
                result.setMatchedDn((LdapDN)ne.getResolvedName());
            }
        }
        session.getIoSession().write((Object)req.getResultResponse());
    }

    public abstract void handleIgnoringReferrals(LdapSession var1, T var2);

    public abstract void handleWithReferrals(LdapSession var1, LdapDN var2, T var3) throws NamingException;
}

