/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.integ.state;

import java.io.File;
import java.io.IOException;
import org.apache.directory.server.core.integ.IntegrationUtils;
import org.apache.directory.server.integ.InheritableServerSettings;
import org.apache.directory.server.integ.state.AbstractState;
import org.apache.directory.server.integ.state.TestServerContext;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartedNormalState
extends AbstractState {
    private static final Logger LOG = LoggerFactory.getLogger(StartedNormalState.class);

    public StartedNormalState(TestServerContext context) {
        super(context);
    }

    public void destroy() {
        LOG.debug("calling destroy()");
        this.context.getLdapServer().setDirectoryService(null);
        this.context.setLdapServer(null);
        this.context.setState(this.context.getNonExistentState());
        System.gc();
    }

    public void cleanup() throws IOException {
        LOG.debug("calling cleanup()");
        IntegrationUtils.doDelete((File)this.context.getLdapServer().getDirectoryService().getWorkingDirectory());
    }

    public void startup() throws Exception {
        LOG.debug("calling start()");
        this.context.getLdapServer().getDirectoryService().startup();
        this.context.getLdapServer().start();
    }

    public void shutdown() throws Exception {
        LOG.debug("calling shutdown()");
        this.context.getLdapServer().stop();
        this.context.getLdapServer().getDirectoryService().shutdown();
    }

    public void revert() throws Exception {
        LOG.debug("calling revert()");
        this.context.getLdapServer().getDirectoryService().revert();
    }

    public void test(TestClass testClass, Statement statement, RunNotifier notifier, InheritableServerSettings settings) {
        LOG.debug("calling test(): {}, mode {}", (Object)settings.getDescription().getDisplayName(), (Object)settings.getMode());
        switch (settings.getMode()) {
            case ROLLBACK: {
                try {
                    this.context.getLdapServer().getDirectoryService().getChangeLog().tag();
                    this.injectLdifs(this.context.getLdapServer().getDirectoryService(), settings);
                }
                catch (Exception e) {
                    this.testAborted(notifier, settings.getDescription(), e);
                    return;
                }
                TestServerContext.invokeTest(testClass, statement, notifier, settings.getDescription());
                try {
                    this.revert();
                }
                catch (Exception e) {
                    this.testAborted(notifier, settings.getDescription(), e);
                    return;
                }
                return;
            }
            case RESTART: {
                try {
                    this.injectLdifs(this.context.getLdapServer().getDirectoryService(), settings);
                }
                catch (Exception e) {
                    this.testAborted(notifier, settings.getDescription(), e);
                    return;
                }
                TestServerContext.invokeTest(testClass, statement, notifier, settings.getDescription());
                try {
                    this.shutdown();
                }
                catch (Exception e) {
                    this.testAborted(notifier, settings.getDescription(), e);
                    return;
                }
                try {
                    this.startup();
                }
                catch (Exception e) {
                    LOG.error("Failed to create and start new server instance: " + e);
                    this.testAborted(notifier, settings.getDescription(), e);
                    return;
                }
                return;
            }
        }
    }
}

