/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.search.ExtensibleMatchFilter;
import org.apache.directory.shared.ldap.codec.search.SearchRequestCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitExtensibleMatchFilterAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger(InitExtensibleMatchFilterAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public InitExtensibleMatchFilterAction() {
        super("Init Extensible Match filter Value");
    }

    public void action(IAsn1Container container) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        LdapMessageCodec ldapMessage = ldapMessageContainer.getLdapMessage();
        SearchRequestCodec searchRequest = ldapMessage.getSearchRequest();
        ExtensibleMatchFilter extensibleMatchFilter = new ExtensibleMatchFilter(ldapMessageContainer.getTlvId());
        searchRequest.addCurrentFilter(extensibleMatchFilter);
        searchRequest.setTerminalFilter(extensibleMatchFilter);
        if (IS_DEBUG) {
            log.debug("Initialize Extensible Match filter");
        }
    }
}

