/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.search.ConnectorFilter;
import org.apache.directory.shared.ldap.codec.search.Filter;

public class NotFilter
extends ConnectorFilter {
    public NotFilter(int tlvId) {
        super(tlvId);
    }

    public NotFilter() {
    }

    public void addFilter(Filter filter) throws DecoderException {
        if (this.filterSet != null) {
            throw new DecoderException("Cannot have more than one Filter within a Not Filter");
        }
        super.addFilter(filter);
    }

    public Filter getNotFilter() {
        return (Filter)((Object)this.filterSet.get(0));
    }

    public void setNotFilter(Filter notFilter) throws DecoderException {
        if (this.filterSet != null) {
            throw new DecoderException("Cannot have more than one Filter within a Not Filter");
        }
        super.addFilter(notFilter);
    }

    public int computeLength() {
        this.filtersLength = super.computeLength();
        return 1 + TLV.getNbBytes((int)this.filtersLength) + this.filtersLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)-94);
            buffer.put(TLV.getBytes((int)this.filtersLength));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        super.encode(buffer);
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('!').append(super.toString());
        return sb.toString();
    }
}

