/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.DITContentRule;
import org.apache.directory.shared.ldap.schema.DITStructureRule;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.MatchingRuleUse;
import org.apache.directory.shared.ldap.schema.NameForm;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.Syntax;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.shared.ldap.schema.parsers.AbstractAdsSchemaDescription;
import org.apache.directory.shared.ldap.schema.parsers.AbstractSchemaDescription;
import org.apache.directory.shared.ldap.schema.parsers.AttributeTypeDescription;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaUtils {
    public static Entry getTargetEntry(List<? extends Modification> mods, Entry entry) throws NamingException {
        Entry targetEntry = entry.clone();
        block5: for (Modification modification : mods) {
            String id = modification.getAttribute().getId();
            switch (modification.getOperation()) {
                case REPLACE_ATTRIBUTE: {
                    targetEntry.put(modification.getAttribute());
                    break;
                }
                case ADD_ATTRIBUTE: {
                    EntryAttribute combined = modification.getAttribute().clone();
                    EntryAttribute toBeAdded = modification.getAttribute();
                    EntryAttribute existing = entry.get(id);
                    if (existing != null) {
                        for (Value value : existing) {
                            combined.add(value);
                        }
                    }
                    for (Value value : toBeAdded) {
                        combined.add(value);
                    }
                    targetEntry.put(combined);
                    break;
                }
                case REMOVE_ATTRIBUTE: {
                    EntryAttribute toBeRemoved = modification.getAttribute();
                    if (toBeRemoved.size() == 0) {
                        targetEntry.removeAttributes(id);
                        break;
                    }
                    EntryAttribute existing = targetEntry.get(id);
                    if (existing == null) continue block5;
                    for (Value value : toBeRemoved) {
                        existing.remove(value);
                    }
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("undefined modification type: " + (Object)((Object)modification.getOperation()));
                }
            }
        }
        return targetEntry;
    }

    public static StringBuffer render(StringBuffer buf, String[] qdescrs) {
        if (qdescrs == null || qdescrs.length == 0) {
            return buf;
        }
        if (qdescrs.length == 1) {
            buf.append("'").append(qdescrs[0]).append("'");
        } else {
            buf.append("( ");
            for (int ii = 0; ii < qdescrs.length; ++ii) {
                buf.append("'").append(qdescrs[ii]).append("' ");
            }
            buf.append(")");
        }
        return buf;
    }

    public static StringBuffer render(String[] qdescrs) {
        StringBuffer buf = new StringBuffer();
        return SchemaUtils.render(buf, qdescrs);
    }

    public static StringBuffer render(ObjectClass[] ocs) {
        StringBuffer buf = new StringBuffer();
        return SchemaUtils.render(buf, ocs);
    }

    public static StringBuffer render(StringBuffer buf, ObjectClass[] ocs) {
        if (ocs == null || ocs.length == 0) {
            return buf;
        }
        if (ocs.length == 1) {
            buf.append(ocs[0].getName());
        } else {
            buf.append("( ");
            for (int ii = 0; ii < ocs.length; ++ii) {
                if (ii + 1 < ocs.length) {
                    buf.append(ocs[ii].getName()).append(" $ ");
                    continue;
                }
                buf.append(ocs[ii].getName());
            }
            buf.append(" )");
        }
        return buf;
    }

    public static StringBuffer render(AttributeType[] ats) {
        StringBuffer buf = new StringBuffer();
        return SchemaUtils.render(buf, ats);
    }

    public static StringBuffer render(StringBuffer buf, AttributeType[] ats) {
        if (ats == null || ats.length == 0) {
            return buf;
        }
        if (ats.length == 1) {
            buf.append(ats[0].getName());
        } else {
            buf.append("( ");
            for (int ii = 0; ii < ats.length; ++ii) {
                if (ii + 1 < ats.length) {
                    buf.append(ats[ii].getName()).append(" $ ");
                    continue;
                }
                buf.append(ats[ii].getName());
            }
            buf.append(" )");
        }
        return buf;
    }

    public static StringBuffer render(ObjectClass oc) throws NamingException {
        StringBuffer buf = new StringBuffer();
        buf.append("( ").append(oc.getOid());
        if (oc.getNamesRef() != null && oc.getNamesRef().length > 0) {
            buf.append(" NAME ");
            SchemaUtils.render(buf, oc.getNamesRef()).append(" ");
        } else {
            buf.append(" ");
        }
        if (oc.getDescription() != null) {
            buf.append("DESC ").append("'").append(oc.getDescription()).append("' ");
        }
        if (oc.isObsolete()) {
            buf.append(" OBSOLETE ");
        }
        if (oc.getSuperClasses() != null && oc.getSuperClasses().length > 0) {
            buf.append("SUP ");
            SchemaUtils.render(buf, oc.getSuperClasses());
        }
        if (oc.getType() != null) {
            buf.append(" ").append((Object)oc.getType());
        }
        if (oc.getMustList() != null && oc.getMustList().length > 0) {
            buf.append(" MUST ");
            SchemaUtils.render(buf, oc.getMustList());
        }
        if (oc.getMayList() != null && oc.getMayList().length > 0) {
            buf.append(" MAY ");
            SchemaUtils.render(buf, oc.getMayList());
        }
        buf.append(" X-SCHEMA '");
        buf.append(oc.getSchema());
        buf.append("'");
        buf.append(" )");
        return buf;
    }

    public static StringBuffer render(AttributeType at) throws NamingException {
        StringBuffer buf = new StringBuffer();
        buf.append("( ").append(at.getOid());
        if (at.getNamesRef() != null && at.getNamesRef().length > 0) {
            buf.append(" NAME ");
            SchemaUtils.render(buf, at.getNamesRef()).append(" ");
        } else {
            buf.append(" ");
        }
        if (at.getDescription() != null) {
            buf.append("DESC ").append("'").append(at.getDescription()).append("' ");
        }
        if (at.isObsolete()) {
            buf.append(" OBSOLETE");
        }
        if (at.getSuperior() != null) {
            buf.append(" SUP ").append(at.getSuperior().getName());
        }
        if (at.getEquality() != null) {
            buf.append(" EQUALITY ").append(at.getEquality().getName());
        }
        if (at.getOrdering() != null) {
            buf.append(" ORDERING ").append(at.getOrdering().getName());
        }
        if (at.getSubstr() != null) {
            buf.append(" SUBSTR ").append(at.getSubstr().getName());
        }
        if (at.getSyntax() != null) {
            buf.append(" SYNTAX ").append(at.getSyntax().getOid());
            if (at.getLength() > 0) {
                buf.append("{").append(at.getLength()).append("}");
            }
        }
        if (at.isSingleValue()) {
            buf.append(" SINGLE-VALUE");
        }
        if (at.isCollective()) {
            buf.append(" COLLECTIVE");
        }
        if (!at.isCanUserModify()) {
            buf.append(" NO-USER-MODIFICATION");
        }
        if (at.getUsage() != null) {
            buf.append(" USAGE ").append(UsageEnum.render(at.getUsage()));
        }
        buf.append(" X-SCHEMA '");
        buf.append(at.getSchema());
        buf.append("'");
        buf.append(" )");
        return buf;
    }

    public static StringBuffer render(AttributeTypeDescription atd) {
        StringBuffer buf = new StringBuffer();
        buf.append("( ").append(atd.getNumericOid());
        if (atd.getNames() != null && atd.getNames().size() > 0) {
            buf.append(" NAME ");
            SchemaUtils.render(buf, atd.getNames().toArray(new String[atd.getNames().size()])).append(" ");
        } else {
            buf.append(" ");
        }
        if (atd.getDescription() != null) {
            buf.append("DESC ").append("'").append(atd.getDescription()).append("' ");
        }
        if (atd.isObsolete()) {
            buf.append(" OBSOLETE");
        }
        if (atd.getSuperType() != null) {
            buf.append(" SUP ").append(atd.getSuperType());
        }
        if (atd.getEqualityMatchingRule() != null) {
            buf.append(" EQUALITY ").append(atd.getEqualityMatchingRule());
        }
        if (atd.getOrderingMatchingRule() != null) {
            buf.append(" ORDERING ").append(atd.getOrderingMatchingRule());
        }
        if (atd.getSubstringsMatchingRule() != null) {
            buf.append(" SUBSTR ").append(atd.getSubstringsMatchingRule());
        }
        if (atd.getSyntax() != null) {
            buf.append(" SYNTAX ").append(atd.getSyntax());
            if (atd.getSyntaxLength() > 0) {
                buf.append("{").append(atd.getSyntaxLength()).append("}");
            }
        }
        if (atd.isSingleValued()) {
            buf.append(" SINGLE-VALUE");
        }
        if (atd.isCollective()) {
            buf.append(" COLLECTIVE");
        }
        if (!atd.isUserModifiable()) {
            buf.append(" NO-USER-MODIFICATION");
        }
        if (atd.getUsage() != null) {
            buf.append(" USAGE ").append(UsageEnum.render(atd.getUsage()));
        }
        return buf.append(SchemaUtils.render(atd.getExtensions())).append(")");
    }

    public static StringBuffer render(Map<String, List<String>> extensions) {
        StringBuffer buf = new StringBuffer();
        if (extensions.isEmpty()) {
            return buf;
        }
        for (String key : extensions.keySet()) {
            buf.append(" ").append(key).append(" ");
            List<String> values = extensions.get(key);
            if (values == null || values.isEmpty()) continue;
            if (values.size() == 1) {
                buf.append("'").append(values.get(0)).append("' ");
                continue;
            }
            buf.append("( ");
            for (String value : values) {
                buf.append("'").append(value).append("' ");
            }
            buf.append(")");
        }
        if (buf.charAt(buf.length() - 1) != ' ') {
            buf.append(" ");
        }
        return buf;
    }

    public static StringBuffer render(MatchingRule mr) throws NamingException {
        StringBuffer buf = new StringBuffer();
        buf.append("( ").append(mr.getOid());
        if (mr.getNamesRef() != null && mr.getNamesRef().length > 0) {
            buf.append(" NAME ");
            SchemaUtils.render(buf, mr.getNamesRef()).append(" ");
        } else {
            buf.append(" ");
        }
        if (mr.getDescription() != null) {
            buf.append("DESC ").append("'").append(mr.getDescription()).append("' ");
        }
        if (mr.isObsolete()) {
            buf.append(" OBSOLETE");
        }
        if (mr.getSyntax() != null) {
            buf.append(" SYNTAX ").append(mr.getSyntax().getOid());
        }
        buf.append(" X-SCHEMA '");
        buf.append(mr.getSchema());
        buf.append("'");
        buf.append(" )");
        return buf;
    }

    public static StringBuffer render(Syntax syntax) {
        StringBuffer buf = new StringBuffer();
        buf.append("( ").append(syntax.getOid()).append(" ");
        if (syntax.getDescription() != null) {
            buf.append("DESC ").append("'").append(syntax.getDescription()).append("' ");
        }
        buf.append(" X-SCHEMA '");
        buf.append(syntax.getSchema());
        if (syntax.isHumanReadable()) {
            buf.append("' X-IS-HUMAN-READABLE 'true'");
        } else {
            buf.append("' X-IS-HUMAN-READABLE 'false'");
        }
        buf.append(" )");
        return buf;
    }

    public static StringBuffer render(MatchingRuleUse mru) {
        StringBuffer buf = new StringBuffer();
        buf.append("( ").append(mru.getOid()).append(" NAME ");
        SchemaUtils.render(buf, mru.getNamesRef()).append(" ");
        if (mru.getDescription() != null) {
            buf.append("DESC ").append("'").append(mru.getDescription()).append("' ");
        }
        buf.append(" X-SCHEMA '");
        buf.append(mru.getSchema());
        buf.append("'");
        buf.append(" )");
        return buf;
    }

    public static StringBuffer render(DITContentRule dcr) {
        StringBuffer buf = new StringBuffer();
        buf.append("( ").append(dcr.getOid()).append(" NAME ");
        SchemaUtils.render(buf, dcr.getNamesRef()).append(" ");
        if (dcr.getDescription() != null) {
            buf.append("DESC ").append("'").append(dcr.getDescription()).append("' ");
        }
        buf.append(" X-SCHEMA '");
        buf.append(dcr.getSchema());
        buf.append("'");
        buf.append(" )");
        return buf;
    }

    public static StringBuffer render(DITStructureRule dsr) {
        StringBuffer buf = new StringBuffer();
        buf.append("( ").append(dsr.getOid()).append(" NAME ");
        SchemaUtils.render(buf, dsr.getNamesRef()).append(" ");
        if (dsr.getDescription() != null) {
            buf.append("DESC ").append("'").append(dsr.getDescription()).append("' ");
        }
        buf.append(" X-SCHEMA '");
        buf.append(dsr.getSchema());
        buf.append("' )");
        return buf;
    }

    public static StringBuffer render(NameForm nf) {
        StringBuffer buf = new StringBuffer();
        buf.append("( ").append(nf.getOid()).append(" NAME ");
        SchemaUtils.render(buf, nf.getNamesRef()).append(" ");
        if (nf.getDescription() != null) {
            buf.append("DESC ").append("'").append(nf.getDescription()).append("' ");
        }
        buf.append(" X-SCHEMA '");
        buf.append(nf.getSchema());
        buf.append("' )");
        return buf;
    }

    public static String render(AbstractAdsSchemaDescription description) {
        StringBuilder buf = new StringBuilder();
        buf.append("( ").append(description.getNumericOid()).append(" ");
        if (description.getDescription() != null) {
            buf.append("DESC ").append("'").append(description.getDescription()).append("' ");
        }
        buf.append("FQCN ").append(description.getFqcn()).append(" ");
        if (description.getBytecode() != null) {
            buf.append("BYTECODE ").append(description.getBytecode());
        }
        buf.append(" X-SCHEMA '");
        buf.append(SchemaUtils.getSchema(description));
        buf.append("' )");
        return buf.toString();
    }

    private static String getSchema(AbstractSchemaDescription desc) {
        List<String> values = desc.getExtensions().get("X-SCHEMA");
        if (values == null || values.size() == 0) {
            return "other";
        }
        return values.get(0);
    }

    public static String stripOptions(String attributeId) {
        int optionsPos = attributeId.indexOf(";");
        if (optionsPos != -1) {
            return attributeId.substring(0, optionsPos);
        }
        return attributeId;
    }

    public static Set<String> getOptions(String attributeId) {
        int optionsPos = attributeId.indexOf(";");
        if (optionsPos != -1) {
            String[] res;
            HashSet<String> options = new HashSet<String>();
            for (String option : res = attributeId.substring(optionsPos + 1).split(";")) {
                if (StringTools.isEmpty(option)) continue;
                options.add(option);
            }
            return options;
        }
        return null;
    }

    public static byte[] uuidToBytes(UUID uuid) {
        Long low = uuid.getLeastSignificantBits();
        Long high = uuid.getMostSignificantBits();
        byte[] bytes = new byte[]{(byte)((high & 0xFF00000000000000L) >> 56), (byte)((high & 0xFF000000000000L) >> 48), (byte)((high & 0xFF0000000000L) >> 40), (byte)((high & 0xFF00000000L) >> 32), (byte)((high & 0xFF000000L) >> 24), (byte)((high & 0xFF0000L) >> 16), (byte)((high & 0xFF00L) >> 8), (byte)(high & 0xFFL), (byte)((low & 0xFF00000000000000L) >> 56), (byte)((low & 0xFF000000000000L) >> 48), (byte)((low & 0xFF0000000000L) >> 40), (byte)((low & 0xFF00000000L) >> 32), (byte)((low & 0xFF000000L) >> 24), (byte)((low & 0xFF0000L) >> 16), (byte)((low & 0xFF00L) >> 8), (byte)(low & 0xFFL)};
        return bytes;
    }
}

