/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntaxes;

import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.ldap.schema.AbstractSyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;

public class OidLenSyntaxChecker
extends AbstractSyntaxChecker {
    private static final String SC_OID = "1.3.6.1.4.1.18060.0.4.0.0.5";

    public OidLenSyntaxChecker() {
        super(SC_OID);
    }

    protected OidLenSyntaxChecker(String oid) {
        super(oid);
    }

    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            return false;
        }
        int pos = strValue.indexOf(123);
        if (pos < 0) {
            return OID.isOID((String)strValue);
        }
        String oid = strValue.substring(0, pos);
        if (!OID.isOID((String)oid)) {
            return false;
        }
        String len = strValue.substring(pos);
        if (len.charAt(len.length() - 1) != '}') {
            return false;
        }
        block3: for (int i = 1; i < len.length() - 1; ++i) {
            switch (len.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return len.charAt(1) != '0' || len.length() <= 3;
    }
}

