/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.subtree;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseSubtreeSpecification
implements SubtreeSpecification {
    private final LdapDN base;
    private final Set<LdapDN> chopBefore;
    private final Set<LdapDN> chopAfter;
    private final int minBaseDistance;
    private final int maxBaseDistance;
    private final ExprNode refinement;

    public BaseSubtreeSpecification() {
        this.base = new LdapDN();
        this.minBaseDistance = 0;
        this.maxBaseDistance = -1;
        this.chopAfter = Collections.EMPTY_SET;
        this.chopBefore = Collections.EMPTY_SET;
        this.refinement = null;
    }

    public BaseSubtreeSpecification(ExprNode refinement) {
        this.base = new LdapDN();
        this.minBaseDistance = 0;
        this.maxBaseDistance = -1;
        this.chopAfter = Collections.EMPTY_SET;
        this.chopBefore = Collections.EMPTY_SET;
        this.refinement = refinement;
    }

    public BaseSubtreeSpecification(LdapDN base) {
        this.base = base;
        this.minBaseDistance = 0;
        this.maxBaseDistance = -1;
        this.chopAfter = Collections.EMPTY_SET;
        this.chopBefore = Collections.EMPTY_SET;
        this.refinement = null;
    }

    public BaseSubtreeSpecification(LdapDN base, int minBaseDistance, int maxBaseDistance, Set<LdapDN> chopAfter, Set<LdapDN> chopBefore) {
        this(base, minBaseDistance, maxBaseDistance, chopAfter, chopBefore, null);
    }

    public BaseSubtreeSpecification(LdapDN base, int minBaseDistance, int maxBaseDistance, Set<LdapDN> chopAfter, Set<LdapDN> chopBefore, ExprNode refinement) {
        this.base = base;
        this.minBaseDistance = minBaseDistance;
        this.maxBaseDistance = maxBaseDistance < 0 ? -1 : maxBaseDistance;
        this.chopAfter = chopAfter;
        this.chopBefore = chopBefore;
        this.refinement = refinement;
    }

    @Override
    public LdapDN getBase() {
        return this.base;
    }

    @Override
    public Set<LdapDN> getChopBeforeExclusions() {
        return this.chopBefore;
    }

    @Override
    public Set<LdapDN> getChopAfterExclusions() {
        return this.chopAfter;
    }

    @Override
    public int getMinBaseDistance() {
        return this.minBaseDistance;
    }

    @Override
    public int getMaxBaseDistance() {
        return this.maxBaseDistance;
    }

    @Override
    public ExprNode getRefinement() {
        return this.refinement;
    }

    @Override
    public void printToBuffer(StringBuilder buffer) {
        buffer.append('{');
        if (!this.base.isEmpty()) {
            buffer.append(' ');
            buffer.append("base");
            buffer.append(' ');
            buffer.append('\"');
            buffer.append(this.base.getUpName());
            buffer.append('\"');
            buffer.append(',');
        }
        if (this.minBaseDistance > 0) {
            buffer.append(' ');
            buffer.append("minimum");
            buffer.append(' ');
            buffer.append(this.minBaseDistance);
            buffer.append(',');
        }
        if (this.maxBaseDistance > -1) {
            buffer.append(' ');
            buffer.append("maximum");
            buffer.append(' ');
            buffer.append(this.maxBaseDistance);
            buffer.append(',');
        }
        if (!this.chopBefore.isEmpty() || !this.chopAfter.isEmpty()) {
            LdapDN dn;
            buffer.append(' ');
            buffer.append("specificExclusions");
            buffer.append(' ');
            buffer.append('{');
            Iterator<LdapDN> it = this.chopBefore.iterator();
            while (it.hasNext()) {
                dn = it.next();
                buffer.append(' ');
                buffer.append("chopBefore");
                buffer.append(':');
                buffer.append(' ');
                buffer.append('\"');
                buffer.append(dn.getUpName());
                buffer.append('\"');
                if (!it.hasNext()) continue;
                buffer.append(',');
                buffer.append(' ');
            }
            if (!this.chopBefore.isEmpty() && !this.chopAfter.isEmpty()) {
                buffer.append(',');
                buffer.append(' ');
            }
            it = this.chopAfter.iterator();
            while (it.hasNext()) {
                dn = it.next();
                buffer.append(' ');
                buffer.append("chopAfter");
                buffer.append(':');
                buffer.append(' ');
                buffer.append('\"');
                buffer.append(dn.getUpName());
                buffer.append('\"');
                if (!it.hasNext()) continue;
                buffer.append(',');
                buffer.append(' ');
            }
            buffer.append(' ');
            buffer.append('}');
            buffer.append(',');
        }
        if (this.refinement != null) {
            buffer.append(' ');
            buffer.append("specificationFilter");
            buffer.append(' ');
            try {
                StringBuilder tempBuffer = new StringBuilder();
                this.refinement.printRefinementToBuffer(tempBuffer);
                buffer.append((CharSequence)tempBuffer);
            }
            catch (UnsupportedOperationException e) {
                buffer.append(this.refinement.toString());
            }
            buffer.append(',');
        }
        if (buffer.charAt(buffer.length() - 1) == ',') {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        buffer.append(' ');
        buffer.append('}');
    }
}

