/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobServerGetTest;
import org.apache.flink.runtime.blob.BlobServerPutTest;
import org.apache.flink.runtime.blob.BlobService;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class BlobServerCorruptionTest
extends TestLogger {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @Test
    public void testGetFailsFromCorruptFile() throws IOException {
        Configuration config = new Configuration();
        config.setString(HighAvailabilityOptions.HA_MODE, "ZOOKEEPER");
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        config.setString(HighAvailabilityOptions.HA_STORAGE_PATH, this.temporaryFolder.newFolder().getPath());
        BlobStoreService blobStoreService = null;
        try {
            blobStoreService = BlobUtils.createBlobStoreFromConfig((Configuration)config);
            BlobServerCorruptionTest.testGetFailsFromCorruptFile(config, (BlobStore)blobStoreService, this.exception);
        }
        finally {
            if (blobStoreService != null) {
                blobStoreService.closeAndCleanupAllData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testGetFailsFromCorruptFile(Configuration config, BlobStore blobStore, ExpectedException expectedException) throws IOException {
        Random rnd = new Random();
        JobID jobId = new JobID();
        try (BlobServer server = new BlobServer(config, blobStore);){
            server.start();
            byte[] data = new byte[2000000];
            rnd.nextBytes(data);
            BlobKey key = BlobServerPutTest.put((BlobService)server, jobId, data, BlobKey.BlobType.PERMANENT_BLOB);
            Assert.assertNotNull((Object)key);
            File blobFile = server.getStorageLocation(jobId, key);
            Assert.assertTrue((boolean)blobFile.delete());
            byte[] data2 = Arrays.copyOf(data, data.length);
            data2[0] = (byte)(data2[0] ^ 1);
            File tmpFile = Files.createTempFile("blob", ".jar", new FileAttribute[0]).toFile();
            try {
                FileUtils.writeByteArrayToFile((File)tmpFile, (byte[])data2);
                blobStore.put(tmpFile, jobId, key);
            }
            finally {
                tmpFile.delete();
            }
            expectedException.expect(IOException.class);
            expectedException.expectMessage("data corruption");
            BlobServerGetTest.get((BlobService)server, jobId, key);
        }
    }
}

