/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.PerJobCheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.TestingCompletedCheckpointStore;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class PerJobCheckpointRecoveryTest
extends TestLogger {
    @Test
    public void testFactoryWithoutCheckpointStoreRecovery() throws Exception {
        TestingCompletedCheckpointStore store = new TestingCompletedCheckpointStore(new CompletableFuture<JobStatus>());
        CheckpointRecoveryFactory factory = PerJobCheckpointRecoveryFactory.withoutCheckpointStoreRecovery(maxCheckpoints -> store);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        JobID firstJobId = new JobID();
        Assert.assertSame((Object)store, (Object)factory.createRecoveredCompletedCheckpointStore(firstJobId, 1, classLoader));
        Assert.assertThrows(UnsupportedOperationException.class, () -> factory.createRecoveredCompletedCheckpointStore(firstJobId, 1, classLoader));
        JobID secondJobId = new JobID();
        Assert.assertSame((Object)store, (Object)factory.createRecoveredCompletedCheckpointStore(secondJobId, 1, classLoader));
        Assert.assertThrows(UnsupportedOperationException.class, () -> factory.createRecoveredCompletedCheckpointStore(secondJobId, 1, classLoader));
    }
}

