/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import org.apache.flink.runtime.checkpoint.InflightDataRescalingDescriptorUtil;
import org.apache.flink.runtime.checkpoint.RescaleMappings;
import org.junit.Assert;
import org.junit.Test;

public class RescaleMappingsTest {
    @Test
    public void testInvert() {
        RescaleMappings mapping = InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(2, 3), InflightDataRescalingDescriptorUtil.to(0, 5));
        RescaleMappings inverted = mapping.invert();
        RescaleMappings expected = InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0, 1, 4), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(3), InflightDataRescalingDescriptorUtil.to(3), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(4));
        Assert.assertEquals((Object)expected, (Object)inverted);
        Assert.assertEquals((Object)mapping, (Object)inverted.invert());
    }

    @Test
    public void testNormalization() {
        RescaleMappings mapping = InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(2, 3), InflightDataRescalingDescriptorUtil.to(0, 5), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(new int[0]));
        Assert.assertEquals((long)7L, (long)mapping.getNumberOfSources());
        Assert.assertEquals((long)6L, (long)mapping.getNumberOfTargets());
        Assert.assertEquals((long)5L, (long)mapping.getMappings().length);
    }

    @Test
    public void testAmbiguousTargets() {
        RescaleMappings mapping = InflightDataRescalingDescriptorUtil.mappings(InflightDataRescalingDescriptorUtil.to(0), InflightDataRescalingDescriptorUtil.to(1, 2), InflightDataRescalingDescriptorUtil.to(new int[0]), InflightDataRescalingDescriptorUtil.to(2, 3, 4), InflightDataRescalingDescriptorUtil.to(4, 5), InflightDataRescalingDescriptorUtil.to(new int[0]));
        Assert.assertEquals(InflightDataRescalingDescriptorUtil.set(2, 4), (Object)mapping.getAmbiguousTargets());
    }
}

