/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.CheckpointsCleaner;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStoreTest;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.StandaloneCompletedCheckpointStore;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.testutils.TestCompletedCheckpointStorageLocation;
import org.apache.flink.util.concurrent.Executors;
import org.junit.Assert;
import org.junit.Test;

public class StandaloneCompletedCheckpointStoreTest
extends CompletedCheckpointStoreTest {
    @Override
    protected CompletedCheckpointStore createRecoveredCompletedCheckpointStore(int maxNumberOfCheckpointsToRetain, Executor executor) throws Exception {
        return new StandaloneCompletedCheckpointStore(maxNumberOfCheckpointsToRetain);
    }

    @Test
    public void testShutdownDiscardsCheckpoints() throws Exception {
        SharedStateRegistry sharedStateRegistry = new SharedStateRegistry();
        CompletedCheckpointStore store = this.createRecoveredCompletedCheckpointStore(1);
        CompletedCheckpointStoreTest.TestCompletedCheckpoint checkpoint = StandaloneCompletedCheckpointStoreTest.createCheckpoint(0L, sharedStateRegistry);
        Collection<OperatorState> operatorStates = checkpoint.getOperatorStates().values();
        store.addCheckpoint((CompletedCheckpoint)checkpoint, new CheckpointsCleaner(), () -> {});
        Assert.assertEquals((long)1L, (long)store.getNumberOfRetainedCheckpoints());
        this.verifyCheckpointRegistered(operatorStates, sharedStateRegistry);
        store.shutdown(JobStatus.FINISHED, new CheckpointsCleaner());
        Assert.assertEquals((long)0L, (long)store.getNumberOfRetainedCheckpoints());
        Assert.assertTrue((boolean)checkpoint.isDiscarded());
        StandaloneCompletedCheckpointStoreTest.verifyCheckpointDiscarded(operatorStates);
    }

    @Test
    public void testSuspendDiscardsCheckpoints() throws Exception {
        SharedStateRegistry sharedStateRegistry = new SharedStateRegistry();
        CompletedCheckpointStore store = this.createRecoveredCompletedCheckpointStore(1);
        CompletedCheckpointStoreTest.TestCompletedCheckpoint checkpoint = StandaloneCompletedCheckpointStoreTest.createCheckpoint(0L, sharedStateRegistry);
        Collection<OperatorState> taskStates = checkpoint.getOperatorStates().values();
        store.addCheckpoint((CompletedCheckpoint)checkpoint, new CheckpointsCleaner(), () -> {});
        Assert.assertEquals((long)1L, (long)store.getNumberOfRetainedCheckpoints());
        this.verifyCheckpointRegistered(taskStates, sharedStateRegistry);
        store.shutdown(JobStatus.SUSPENDED, new CheckpointsCleaner());
        Assert.assertEquals((long)0L, (long)store.getNumberOfRetainedCheckpoints());
        Assert.assertTrue((boolean)checkpoint.isDiscarded());
        StandaloneCompletedCheckpointStoreTest.verifyCheckpointDiscarded(taskStates);
    }

    @Test
    public void testAddCheckpointWithFailedRemove() throws Exception {
        boolean numCheckpointsToRetain = true;
        CompletedCheckpointStore store = this.createRecoveredCompletedCheckpointStore(1, Executors.directExecutor());
        final CountDownLatch discardAttempted = new CountDownLatch(1);
        for (long i = 0L; i < 2L; ++i) {
            CompletedCheckpoint checkpointToAdd = new CompletedCheckpoint(new JobID(), i, i, i, Collections.emptyMap(), Collections.emptyList(), CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), new TestCompletedCheckpointStorageLocation()){

                public boolean discardOnSubsume() {
                    discardAttempted.countDown();
                    throw new RuntimeException();
                }
            };
            store.addCheckpoint(checkpointToAdd, new CheckpointsCleaner(), () -> {});
        }
        discardAttempted.await();
    }
}

