/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.overlays;

import java.io.File;
import java.io.IOException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.clusterframework.ContainerSpecification;
import org.apache.flink.runtime.clusterframework.overlays.ContainerOverlayTestBase;
import org.apache.flink.runtime.clusterframework.overlays.Krb5ConfOverlay;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class Krb5ConfOverlayTest
extends ContainerOverlayTestBase {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void testConfigure() throws Exception {
        File krb5conf = this.tempFolder.newFile();
        Krb5ConfOverlay overlay = new Krb5ConfOverlay(krb5conf);
        ContainerSpecification spec = new ContainerSpecification();
        overlay.configure(spec);
        Assert.assertEquals((Object)Krb5ConfOverlay.TARGET_PATH.getPath(), (Object)spec.getSystemProperties().getString("java.security.krb5.conf", null));
        Krb5ConfOverlayTest.checkArtifact(spec, Krb5ConfOverlay.TARGET_PATH);
    }

    @Test
    public void testNoConf() throws Exception {
        Krb5ConfOverlay overlay = new Krb5ConfOverlay((Path)null);
        ContainerSpecification containerSpecification = new ContainerSpecification();
        overlay.configure(containerSpecification);
    }

    @Test
    public void testBuildOverlayFromConf() throws IOException {
        File krb5conf = this.tempFolder.newFile();
        Configuration configuration = new Configuration();
        configuration.set(SecurityOptions.KERBEROS_KRB5_PATH, (Object)krb5conf.getPath());
        Krb5ConfOverlay overlay = Krb5ConfOverlay.newBuilder().fromEnvironmentOrConfiguration(configuration).build();
        Assert.assertEquals((Object)overlay.krb5Conf.getPath(), (Object)krb5conf.getPath());
    }

    @Test
    public void testBuildOverlayFromEnv() throws IOException {
        File krb5conf = this.tempFolder.newFile();
        Configuration configuration = new Configuration();
        System.setProperty("java.security.krb5.conf", krb5conf.getPath());
        Krb5ConfOverlay overlay = Krb5ConfOverlay.newBuilder().fromEnvironmentOrConfiguration(configuration).build();
        Assert.assertEquals((Object)overlay.krb5Conf.getPath(), (Object)krb5conf.getPath());
    }
}

