/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.overlays;

import java.io.File;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.clusterframework.ContainerSpecification;
import org.apache.flink.runtime.clusterframework.overlays.ContainerOverlayTestBase;
import org.apache.flink.runtime.clusterframework.overlays.FlinkDistributionOverlay;
import org.apache.flink.runtime.clusterframework.overlays.UserLibOverlay;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class UserLibOverlayTest
extends ContainerOverlayTestBase {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void testConfigure() throws Exception {
        File userLibFolder = this.tempFolder.newFolder("usrlib");
        Path[] files = UserLibOverlayTest.createPaths(this.tempFolder.getRoot(), "usrlib/job_a.jar", "usrlib/lib/dep1.jar", "usrlib/lib/dep2.jar");
        ContainerSpecification containerSpecification = new ContainerSpecification();
        UserLibOverlay overlay = UserLibOverlay.newBuilder().setUsrLibDirectory(userLibFolder).build();
        overlay.configure(containerSpecification);
        for (Path file : files) {
            UserLibOverlayTest.checkArtifact(containerSpecification, new Path(FlinkDistributionOverlay.TARGET_ROOT, file.toString()));
        }
    }
}

