/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.executiongraph.JobStatusProvider;
import org.apache.flink.util.Preconditions;

public class TestingJobStatusProvider
implements JobStatusProvider {
    private final Supplier<JobStatus> statusSupplier;
    private final Function<JobStatus, Long> statusTimestampRetriever;

    public TestingJobStatusProvider(Supplier<JobStatus> statusSupplier, Function<JobStatus, Long> statusTimestampRetriever) {
        this.statusSupplier = (Supplier)Preconditions.checkNotNull(statusSupplier);
        this.statusTimestampRetriever = (Function)Preconditions.checkNotNull(statusTimestampRetriever);
    }

    public TestingJobStatusProvider(JobStatus state, Function<JobStatus, Long> statusTimestampRetriever) {
        this.statusSupplier = () -> (JobStatus)Preconditions.checkNotNull((Object)state);
        this.statusTimestampRetriever = (Function)Preconditions.checkNotNull(statusTimestampRetriever);
    }

    public TestingJobStatusProvider(JobStatus state, long statusTimestamp) {
        this.statusSupplier = () -> (JobStatus)Preconditions.checkNotNull((Object)state);
        this.statusTimestampRetriever = s -> statusTimestamp;
    }

    public JobStatus getState() {
        return this.statusSupplier.get();
    }

    public long getStatusTimestamp(JobStatus status) {
        return this.statusTimestampRetriever.apply(status);
    }
}

