/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.zookeeper;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.highavailability.AbstractHaServices;
import org.apache.flink.runtime.highavailability.RunningJobsRegistry;
import org.apache.flink.runtime.highavailability.zookeeper.ZooKeeperHaServices;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderelection.TestingContender;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.util.LeaderRetrievalUtils;
import org.apache.flink.runtime.util.TestingFatalErrorHandlerResource;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.runtime.zookeeper.ZooKeeperResource;
import org.apache.flink.shaded.curator4.org.apache.curator.RetryPolicy;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.flink.shaded.curator4.org.apache.curator.retry.RetryNTimes;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.Executors;
import org.apache.flink.util.function.ThrowingConsumer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class ZooKeeperHaServicesTest
extends TestLogger {
    @ClassRule
    public static final ZooKeeperResource ZOO_KEEPER_RESOURCE = new ZooKeeperResource();
    @Rule
    public final TestingFatalErrorHandlerResource testingFatalErrorHandlerResource = new TestingFatalErrorHandlerResource();
    private static CuratorFramework client;

    @BeforeClass
    public static void setupClass() {
        client = ZooKeeperHaServicesTest.startCuratorFramework();
        client.start();
    }

    @Before
    public void setup() throws Exception {
        List children = (List)client.getChildren().forPath("/");
        for (String child : children) {
            if (child.equals("zookeeper")) continue;
            client.delete().deletingChildrenIfNeeded().forPath('/' + child);
        }
    }

    @AfterClass
    public static void teardownClass() {
        if (client != null) {
            client.close();
        }
    }

    @Test
    public void testSimpleClose() throws Exception {
        String rootPath = "/foo/bar/flink";
        Configuration configuration = this.createConfiguration("/foo/bar/flink");
        TestingBlobStoreService blobStoreService = new TestingBlobStoreService();
        this.runCleanupTest(configuration, blobStoreService, (ThrowingConsumer<ZooKeeperHaServices, Exception>)((ThrowingConsumer)AbstractHaServices::close));
        Assert.assertThat((Object)blobStoreService.isClosed(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)blobStoreService.isClosedAndCleanedUpAllData(), (Matcher)Matchers.is((Object)false));
        List children = (List)client.getChildren().forPath("/foo/bar/flink");
        Assert.assertThat((Object)children, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
    }

    @Test
    public void testSimpleCloseAndCleanupAllData() throws Exception {
        Configuration configuration = this.createConfiguration("/foo/bar/flink");
        TestingBlobStoreService blobStoreService = new TestingBlobStoreService();
        List initialChildren = (List)client.getChildren().forPath("/");
        this.runCleanupTest(configuration, blobStoreService, (ThrowingConsumer<ZooKeeperHaServices, Exception>)((ThrowingConsumer)AbstractHaServices::closeAndCleanupAllData));
        Assert.assertThat((Object)blobStoreService.isClosedAndCleanedUpAllData(), (Matcher)Matchers.is((Object)true));
        List children = (List)client.getChildren().forPath("/");
        Assert.assertThat((Object)children, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)initialChildren)));
    }

    @Test
    public void testCloseAndCleanupAllDataWithUncle() throws Exception {
        String prefix = "/foo/bar";
        String flinkPath = "/foo/bar/flink";
        Configuration configuration = this.createConfiguration("/foo/bar/flink");
        TestingBlobStoreService blobStoreService = new TestingBlobStoreService();
        String unclePath = "/foo/bar/foobar";
        client.create().creatingParentContainersIfNeeded().forPath("/foo/bar/foobar");
        this.runCleanupTest(configuration, blobStoreService, (ThrowingConsumer<ZooKeeperHaServices, Exception>)((ThrowingConsumer)AbstractHaServices::closeAndCleanupAllData));
        Assert.assertThat((Object)blobStoreService.isClosedAndCleanedUpAllData(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)client.checkExists().forPath("/foo/bar/flink"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)client.checkExists().forPath("/foo/bar/foobar"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testCleanupJobData() throws Exception {
        String rootPath = "/foo/bar/flink";
        Configuration configuration = this.createConfiguration(rootPath);
        String namespace = (String)configuration.get(HighAvailabilityOptions.HA_CLUSTER_ID);
        JobID jobID = new JobID();
        String path = rootPath + namespace + ZooKeeperUtils.getJobsPath();
        TestingBlobStoreService blobStoreService = new TestingBlobStoreService();
        this.runCleanupTestWithJob(configuration, blobStoreService, jobID, (ThrowingConsumer<ZooKeeperHaServices, Exception>)((ThrowingConsumer)haServices -> {
            List childrenBefore = (List)client.getChildren().forPath(path);
            haServices.cleanupJobData(jobID);
            List childrenAfter = (List)client.getChildren().forPath(path);
            Assert.assertThat((Object)childrenBefore, (Matcher)Matchers.hasItem((Object)jobID.toString()));
            Assert.assertThat((Object)childrenAfter, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)jobID.toString())));
        }));
    }

    private static CuratorFramework startCuratorFramework() {
        return CuratorFrameworkFactory.builder().connectString(ZOO_KEEPER_RESOURCE.getConnectString()).retryPolicy((RetryPolicy)new RetryNTimes(50, 100)).build();
    }

    @Nonnull
    private Configuration createConfiguration(String rootPath) {
        Configuration configuration = new Configuration();
        configuration.setString(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, ZOO_KEEPER_RESOURCE.getConnectString());
        configuration.setString(HighAvailabilityOptions.HA_ZOOKEEPER_ROOT, rootPath);
        return configuration;
    }

    private void runCleanupTest(Configuration configuration, TestingBlobStoreService blobStoreService, ThrowingConsumer<ZooKeeperHaServices, Exception> zooKeeperHaServicesConsumer) throws Exception {
        this.runCleanupTestWithJob(configuration, blobStoreService, new JobID(), zooKeeperHaServicesConsumer);
    }

    private void runCleanupTestWithJob(Configuration configuration, TestingBlobStoreService blobStoreService, JobID jobId, ThrowingConsumer<ZooKeeperHaServices, Exception> zooKeeperHaServicesConsumer) throws Exception {
        try (ZooKeeperHaServices zooKeeperHaServices = new ZooKeeperHaServices(ZooKeeperUtils.startCuratorFramework((Configuration)configuration, (FatalErrorHandler)this.testingFatalErrorHandlerResource.getFatalErrorHandler()), Executors.directExecutor(), configuration, (BlobStoreService)blobStoreService);){
            LeaderRetrievalService resourceManagerLeaderRetriever = zooKeeperHaServices.getResourceManagerLeaderRetriever();
            LeaderElectionService resourceManagerLeaderElectionService = zooKeeperHaServices.getResourceManagerLeaderElectionService();
            LeaderRetrievalService jobManagerLeaderRetriever = zooKeeperHaServices.getJobManagerLeaderRetriever(jobId);
            LeaderElectionService jobManagerLeaderElectionService = zooKeeperHaServices.getJobManagerLeaderElectionService(jobId);
            RunningJobsRegistry runningJobsRegistry = zooKeeperHaServices.getRunningJobsRegistry();
            LeaderRetrievalUtils.LeaderConnectionInfoListener resourceManagerLeaderListener = new LeaderRetrievalUtils.LeaderConnectionInfoListener();
            resourceManagerLeaderElectionService.start((LeaderContender)new TestingContender("unused-resourcemanager-address", resourceManagerLeaderElectionService));
            resourceManagerLeaderRetriever.start((LeaderRetrievalListener)resourceManagerLeaderListener);
            LeaderRetrievalUtils.LeaderConnectionInfoListener jobManagerLeaderListener = new LeaderRetrievalUtils.LeaderConnectionInfoListener();
            jobManagerLeaderElectionService.start((LeaderContender)new TestingContender("unused-jobmanager-address", jobManagerLeaderElectionService));
            jobManagerLeaderRetriever.start((LeaderRetrievalListener)jobManagerLeaderListener);
            runningJobsRegistry.setJobRunning(jobId);
            resourceManagerLeaderListener.getLeaderConnectionInfoFuture().join();
            jobManagerLeaderListener.getLeaderConnectionInfoFuture().join();
            resourceManagerLeaderRetriever.stop();
            resourceManagerLeaderElectionService.stop();
            jobManagerLeaderRetriever.stop();
            jobManagerLeaderElectionService.stop();
            runningJobsRegistry.clearJob(jobId);
            zooKeeperHaServicesConsumer.accept((Object)zooKeeperHaServices);
        }
    }

    private static class TestingBlobStoreService
    implements BlobStoreService {
        private boolean closedAndCleanedUpAllData = false;
        private boolean closed = false;

        private TestingBlobStoreService() {
        }

        public void closeAndCleanupAllData() {
            this.closedAndCleanedUpAllData = true;
        }

        public void close() throws IOException {
            this.closed = true;
        }

        public boolean put(File localFile, JobID jobId, BlobKey blobKey) {
            return false;
        }

        public boolean delete(JobID jobId, BlobKey blobKey) {
            return false;
        }

        public boolean deleteAll(JobID jobId) {
            return false;
        }

        public boolean get(JobID jobId, BlobKey blobKey, File localFile) {
            return false;
        }

        private boolean isClosed() {
            return this.closed;
        }

        private boolean isClosedAndCleanedUpAllData() {
            return this.closedAndCleanedUpAllData;
        }
    }
}

