/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.Collection;
import java.util.Collections;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.io.network.partition.JobMasterPartitionTracker;
import org.apache.flink.runtime.io.network.partition.PartitionTrackerEntry;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;

public class TestingJobMasterPartitionTracker
implements JobMasterPartitionTracker {
    private Function<ResourceID, Boolean> isTrackingPartitionsForFunction = ignored -> false;
    private Function<ResultPartitionID, Boolean> isPartitionTrackedFunction = ignored -> false;
    private Consumer<ResourceID> stopTrackingAllPartitionsConsumer = ignored -> {};
    private BiConsumer<ResourceID, ResultPartitionDeploymentDescriptor> startTrackingPartitionsConsumer = (ignoredA, ignoredB) -> {};
    private Consumer<Collection<ResultPartitionID>> stopTrackingAndReleasePartitionsConsumer = ignored -> {};
    private Consumer<Collection<ResultPartitionID>> stopTrackingAndReleaseOrPromotePartitionsConsumer = ignored -> {};
    private Consumer<Collection<ResultPartitionID>> stopTrackingPartitionsConsumer = ignored -> {};
    private Supplier<Collection<ResultPartitionDeploymentDescriptor>> getAllTrackedPartitionsSupplier = () -> Collections.emptyList();

    public void setStartTrackingPartitionsConsumer(BiConsumer<ResourceID, ResultPartitionDeploymentDescriptor> startTrackingPartitionsConsumer) {
        this.startTrackingPartitionsConsumer = startTrackingPartitionsConsumer;
    }

    public void setIsTrackingPartitionsForFunction(Function<ResourceID, Boolean> isTrackingPartitionsForFunction) {
        this.isTrackingPartitionsForFunction = isTrackingPartitionsForFunction;
    }

    public void setIsPartitionTrackedFunction(Function<ResultPartitionID, Boolean> isPartitionTrackedFunction) {
        this.isPartitionTrackedFunction = isPartitionTrackedFunction;
    }

    public void setStopTrackingAllPartitionsConsumer(Consumer<ResourceID> stopTrackingAllPartitionsConsumer) {
        this.stopTrackingAllPartitionsConsumer = stopTrackingAllPartitionsConsumer;
    }

    public void setStopTrackingAndReleasePartitionsConsumer(Consumer<Collection<ResultPartitionID>> stopTrackingAndReleasePartitionsConsumer) {
        this.stopTrackingAndReleasePartitionsConsumer = stopTrackingAndReleasePartitionsConsumer;
    }

    public void setStopTrackingAndReleaseOrPromotePartitionsConsumer(Consumer<Collection<ResultPartitionID>> stopTrackingAndReleaseOrPromotePartitionsConsumer) {
        this.stopTrackingAndReleaseOrPromotePartitionsConsumer = stopTrackingAndReleaseOrPromotePartitionsConsumer;
    }

    public void setStopTrackingPartitionsConsumer(Consumer<Collection<ResultPartitionID>> stopTrackingPartitionsConsumer) {
        this.stopTrackingPartitionsConsumer = stopTrackingPartitionsConsumer;
    }

    public void setGetAllTrackedPartitionsSupplier(Supplier<Collection<ResultPartitionDeploymentDescriptor>> getAllTrackedPartitionsSupplier) {
        this.getAllTrackedPartitionsSupplier = getAllTrackedPartitionsSupplier;
    }

    public void startTrackingPartition(ResourceID producingTaskExecutorId, ResultPartitionDeploymentDescriptor resultPartitionDeploymentDescriptor) {
        this.startTrackingPartitionsConsumer.accept(producingTaskExecutorId, resultPartitionDeploymentDescriptor);
    }

    public Collection<PartitionTrackerEntry<ResourceID, ResultPartitionDeploymentDescriptor>> stopTrackingPartitionsFor(ResourceID producingTaskExecutorId) {
        this.stopTrackingAllPartitionsConsumer.accept(producingTaskExecutorId);
        return Collections.emptyList();
    }

    public void stopTrackingAndReleasePartitions(Collection<ResultPartitionID> resultPartitionIds, boolean releaseOnShuffleMaster) {
        this.stopTrackingAndReleasePartitionsConsumer.accept(resultPartitionIds);
    }

    public Collection<PartitionTrackerEntry<ResourceID, ResultPartitionDeploymentDescriptor>> stopTrackingPartitions(Collection<ResultPartitionID> resultPartitionIds) {
        this.stopTrackingPartitionsConsumer.accept(resultPartitionIds);
        return Collections.emptyList();
    }

    public void stopTrackingAndReleaseOrPromotePartitions(Collection<ResultPartitionID> resultPartitionIds) {
        this.stopTrackingAndReleaseOrPromotePartitionsConsumer.accept(resultPartitionIds);
    }

    public Collection<ResultPartitionDeploymentDescriptor> getAllTrackedPartitions() {
        return this.getAllTrackedPartitionsSupplier.get();
    }

    public boolean isTrackingPartitionsFor(ResourceID producingTaskExecutorId) {
        return this.isTrackingPartitionsForFunction.apply(producingTaskExecutorId);
    }

    public boolean isPartitionTracked(ResultPartitionID resultPartitionID) {
        return this.isPartitionTrackedFunction.apply(resultPartitionID);
    }
}

