/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.memory;

import org.apache.flink.runtime.memory.MemoryAllocationException;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.MemoryManagerBuilder;
import org.apache.flink.runtime.memory.OpaqueMemoryResource;
import org.junit.Assert;
import org.junit.Test;

public class MemoryManagerSharedResourcesTest {
    @Test
    public void getSameTypeGetsSameHandle() throws Exception {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        OpaqueMemoryResource resource1 = memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.1);
        OpaqueMemoryResource resource2 = memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.1);
        Assert.assertNotSame((Object)resource1, (Object)resource2);
        Assert.assertSame((Object)resource1.getResourceHandle(), (Object)resource2.getResourceHandle());
    }

    @Test
    public void getDifferentTypeGetsDifferentResources() throws Exception {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        OpaqueMemoryResource resource1 = memoryManager.getSharedMemoryResourceForManagedMemory("type1", TestResource::new, 0.1);
        OpaqueMemoryResource resource2 = memoryManager.getSharedMemoryResourceForManagedMemory("type2", TestResource::new, 0.1);
        Assert.assertNotSame((Object)resource1, (Object)resource2);
        Assert.assertNotSame((Object)resource1.getResourceHandle(), (Object)resource2.getResourceHandle());
    }

    @Test
    public void testAllocatesFractionOfTotalMemory() throws Exception {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        double fraction = 0.2;
        OpaqueMemoryResource resource = memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.2);
        Assert.assertEquals((long)((long)(0.2 * (double)memoryManager.getMemorySize())), (long)resource.getSize());
    }

    @Test
    public void getAllocateNewReservesMemory() throws Exception {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.5);
        Assert.assertEquals((long)(memoryManager.getMemorySize() / 2L), (long)memoryManager.availableMemory());
    }

    @Test
    public void getExistingDoesNotAllocateAdditionalMemory() throws Exception {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.8);
        long freeMemory = memoryManager.availableMemory();
        memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.8);
        Assert.assertEquals((long)freeMemory, (long)memoryManager.availableMemory());
    }

    @Test
    public void testFailReservation() throws Exception {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.8);
        try {
            memoryManager.getSharedMemoryResourceForManagedMemory("type2", TestResource::new, 0.8);
            Assert.fail((String)"exception expected");
        }
        catch (MemoryAllocationException memoryAllocationException) {
            // empty catch block
        }
    }

    @Test
    public void testPartialReleaseDoesNotReleaseMemory() throws Exception {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        OpaqueMemoryResource resource1 = memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.1);
        memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.1);
        Assert.assertFalse((boolean)memoryManager.verifyEmpty());
        resource1.close();
        Assert.assertFalse((boolean)((TestResource)resource1.getResourceHandle()).closed);
        Assert.assertFalse((boolean)memoryManager.verifyEmpty());
    }

    @Test
    public void testLastReleaseReleasesMemory() throws Exception {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        OpaqueMemoryResource resource1 = memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.1);
        OpaqueMemoryResource resource2 = memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.1);
        Assert.assertFalse((boolean)memoryManager.verifyEmpty());
        resource1.close();
        resource2.close();
        Assert.assertTrue((boolean)((TestResource)resource1.getResourceHandle()).closed);
        Assert.assertTrue((boolean)memoryManager.verifyEmpty());
    }

    @Test
    public void testPartialReleaseDoesNotDisposeResource() throws Exception {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        OpaqueMemoryResource resource1 = memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.1);
        memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.1);
        resource1.close();
        Assert.assertFalse((boolean)((TestResource)resource1.getResourceHandle()).closed);
        Assert.assertFalse((boolean)memoryManager.verifyEmpty());
    }

    @Test
    public void testLastReleaseDisposesResource() throws Exception {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        OpaqueMemoryResource resource1 = memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.1);
        OpaqueMemoryResource resource2 = memoryManager.getSharedMemoryResourceForManagedMemory("type", TestResource::new, 0.1);
        resource1.close();
        resource2.close();
        Assert.assertTrue((boolean)((TestResource)resource1.getResourceHandle()).closed);
        Assert.assertTrue((boolean)((TestResource)resource2.getResourceHandle()).closed);
        Assert.assertTrue((boolean)memoryManager.verifyEmpty());
    }

    @Test
    public void getAllocateExternalResource() throws Exception {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        OpaqueMemoryResource resource = memoryManager.getExternalSharedMemoryResource("external-type", TestResource::new, 1337L);
        Assert.assertEquals((long)1337L, (long)resource.getSize());
    }

    @Test
    public void getExistingExternalResource() throws Exception {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        OpaqueMemoryResource resource1 = memoryManager.getExternalSharedMemoryResource("external-type", TestResource::new, 1337L);
        OpaqueMemoryResource resource2 = memoryManager.getExternalSharedMemoryResource("external-type", TestResource::new, 1337L);
        Assert.assertNotSame((Object)resource1, (Object)resource2);
        Assert.assertSame((Object)resource1.getResourceHandle(), (Object)resource2.getResourceHandle());
    }

    @Test
    public void getDifferentExternalResources() throws Exception {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        OpaqueMemoryResource resource1 = memoryManager.getExternalSharedMemoryResource("external-type-1", TestResource::new, 1337L);
        OpaqueMemoryResource resource2 = memoryManager.getExternalSharedMemoryResource("external-type-2", TestResource::new, 1337L);
        Assert.assertNotSame((Object)resource1, (Object)resource2);
        Assert.assertNotSame((Object)resource1.getResourceHandle(), (Object)resource2.getResourceHandle());
    }

    @Test
    public void testReleaseDisposesExternalResource() throws Exception {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        OpaqueMemoryResource resource = memoryManager.getExternalSharedMemoryResource("external-type", TestResource::new, 1337L);
        resource.close();
        Assert.assertTrue((boolean)((TestResource)resource.getResourceHandle()).closed);
    }

    @Test
    public void testAllocateResourceInitializeFail() {
        MemoryManager memoryManager = MemoryManagerSharedResourcesTest.createMemoryManager();
        try {
            memoryManager.getSharedMemoryResourceForManagedMemory("type", ignore -> {
                throw new RuntimeException("initialization fail");
            }, 0.1);
            Assert.fail((String)"expect to fail");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Assert.assertTrue((boolean)memoryManager.verifyEmpty());
    }

    private static MemoryManager createMemoryManager() {
        long size = 0x8000000L;
        MemoryManager mm = MemoryManagerBuilder.newBuilder().setMemorySize(0x8000000L).build();
        Assert.assertEquals((long)0x8000000L, (long)mm.getMemorySize());
        Assert.assertEquals((long)0x8000000L, (long)mm.availableMemory());
        return mm;
    }

    private static final class TestResource
    implements AutoCloseable {
        final long size;
        boolean closed;

        TestResource(long size) {
            this.size = size;
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

