/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.memory;

import java.util.function.Consumer;
import org.apache.flink.runtime.memory.SharedResources;
import org.junit.Assert;
import org.junit.Test;

public class SharedResourcesTest {
    @Test
    public void testAllocatedResourcesInMap() throws Exception {
        SharedResources resources = new SharedResources();
        TestResource tr = (TestResource)resources.getOrAllocateSharedResource("theType", new Object(), TestResource::new, 100L).resourceHandle();
        Assert.assertEquals((long)1L, (long)resources.getNumResources());
        Assert.assertFalse((boolean)tr.closed);
    }

    @Test
    public void testIntermediateReleaseDoesNotRemoveFromMap() throws Exception {
        SharedResources resources = new SharedResources();
        String type = "theType";
        Object leaseHolder1 = new Object();
        Object leaseHolder2 = new Object();
        resources.getOrAllocateSharedResource("theType", leaseHolder1, TestResource::new, 100L);
        resources.getOrAllocateSharedResource("theType", leaseHolder2, TestResource::new, 100L);
        resources.release("theType", leaseHolder1);
        Assert.assertEquals((long)1L, (long)resources.getNumResources());
    }

    @Test
    public void testReleaseIsIdempotent() throws Exception {
        SharedResources resources = new SharedResources();
        String type = "theType";
        Object leaseHolder1 = new Object();
        Object leaseHolder2 = new Object();
        resources.getOrAllocateSharedResource("theType", leaseHolder1, TestResource::new, 100L);
        resources.getOrAllocateSharedResource("theType", leaseHolder2, TestResource::new, 100L);
        resources.release("theType", leaseHolder2);
        resources.release("theType", leaseHolder2);
        Assert.assertEquals((long)1L, (long)resources.getNumResources());
    }

    @Test
    public void testLastReleaseRemovesFromMap() throws Exception {
        SharedResources resources = new SharedResources();
        String type = "theType";
        Object leaseHolder = new Object();
        resources.getOrAllocateSharedResource("theType", leaseHolder, TestResource::new, 100L);
        resources.release("theType", leaseHolder);
        Assert.assertEquals((long)0L, (long)resources.getNumResources());
    }

    @Test
    public void testLastReleaseDisposesResource() throws Exception {
        SharedResources resources = new SharedResources();
        String type = "theType";
        Object leaseHolder = new Object();
        TestResource tr = (TestResource)resources.getOrAllocateSharedResource("theType", leaseHolder, TestResource::new, 100L).resourceHandle();
        resources.release("theType", leaseHolder);
        Assert.assertTrue((boolean)tr.closed);
    }

    @Test
    public void testLastReleaseCallsReleaseHook() throws Exception {
        String type = "theType";
        long size = 100L;
        SharedResources resources = new SharedResources();
        Object leaseHolder = new Object();
        TestReleaseHook hook = new TestReleaseHook(100L);
        resources.getOrAllocateSharedResource("theType", leaseHolder, TestResource::new, 100L);
        resources.release("theType", leaseHolder, (Consumer)hook);
        Assert.assertTrue((boolean)hook.wasCalled);
    }

    @Test
    public void testReleaseNoneExistingLease() throws Exception {
        SharedResources resources = new SharedResources();
        resources.release("theType", new Object());
        Assert.assertEquals((long)0L, (long)resources.getNumResources());
    }

    private static final class TestReleaseHook
    implements Consumer<Long> {
        private final long expectedValue;
        boolean wasCalled;

        TestReleaseHook(long expectedValue) {
            this.expectedValue = expectedValue;
        }

        @Override
        public void accept(Long value) {
            this.wasCalled = true;
            Assert.assertEquals((long)this.expectedValue, (long)value);
        }
    }

    private static final class TestResource
    implements AutoCloseable {
        final long size;
        boolean closed;

        TestResource(long size) {
            this.size = size;
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

