/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.Collections;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.apache.flink.runtime.metrics.groups.FrontMetricGroup;
import org.apache.flink.runtime.metrics.groups.ProcessMetricGroup;
import org.apache.flink.runtime.metrics.groups.ReporterScopedSettings;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.runtime.metrics.scope.ScopeFormats;
import org.apache.flink.runtime.metrics.util.TestingMetricRegistry;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class FrontMetricGroupTest {
    @Test
    public void testDelimiterReplacement() {
        int delimiter = 42;
        String hostName = "some*host";
        String metricName = "hello*world";
        Configuration config = new Configuration();
        config.set(MetricOptions.SCOPE_NAMING_JM, (Object)ScopeFormat.SCOPE_HOST);
        FrontMetricGroup frontMetricGroup = new FrontMetricGroup(new ReporterScopedSettings(0, '*', Collections.emptySet()), (AbstractMetricGroup)new ProcessMetricGroup((MetricRegistry)TestingMetricRegistry.builder().setScopeFormats(ScopeFormats.fromConfig((Configuration)config)).build(), "some*host"));
        Assert.assertThat((Object)frontMetricGroup.getMetricIdentifier("hello*world"), (Matcher)CoreMatchers.is((Object)("some*host".replace('*', '_') + '*' + "hello*world".replace('*', '_'))));
        Assert.assertThat((Object)frontMetricGroup.getAllVariables(), (Matcher)Matchers.hasEntry((Object)ScopeFormat.SCOPE_HOST, (Object)"some*host"));
    }

    @Test
    public void testDelimiterReplacementWithAlternative() {
        int delimiter = 95;
        String hostName = "some_host";
        String metricName = "hello_world";
        Configuration config = new Configuration();
        config.set(MetricOptions.SCOPE_NAMING_JM, (Object)ScopeFormat.SCOPE_HOST);
        FrontMetricGroup frontMetricGroup = new FrontMetricGroup(new ReporterScopedSettings(0, '_', Collections.emptySet()), (AbstractMetricGroup)new ProcessMetricGroup((MetricRegistry)TestingMetricRegistry.builder().setScopeFormats(ScopeFormats.fromConfig((Configuration)config)).build(), "some_host"));
        Assert.assertThat((Object)frontMetricGroup.getMetricIdentifier("hello_world"), (Matcher)CoreMatchers.is((Object)("some_host".replace('_', '-') + '_' + "hello_world".replace('_', '-'))));
        Assert.assertThat((Object)frontMetricGroup.getAllVariables(), (Matcher)Matchers.hasEntry((Object)ScopeFormat.SCOPE_HOST, (Object)"some_host"));
    }
}

