/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.taskmanager;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.exceptions.UnknownTaskExecutorException;
import org.apache.flink.runtime.resourcemanager.utils.TestingResourceManagerGateway;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.HandlerRequestException;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.taskmanager.TaskManagerLogListHandler;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.LogInfo;
import org.apache.flink.runtime.rest.messages.LogListInfo;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerLogsHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerMessageParameters;
import org.apache.flink.runtime.testutils.TestingUtils;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.FutureUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TaskManagerLogListHandlerTest
extends TestLogger {
    private static final ResourceID EXPECTED_TASK_MANAGER_ID = ResourceID.generate();
    private TestingResourceManagerGateway resourceManagerGateway;
    private TaskManagerLogListHandler taskManagerLogListHandler;
    private HandlerRequest<EmptyRequestBody, TaskManagerMessageParameters> handlerRequest;

    @Before
    public void setUp() throws HandlerRequestException {
        this.resourceManagerGateway = new TestingResourceManagerGateway();
        this.taskManagerLogListHandler = new TaskManagerLogListHandler(() -> CompletableFuture.completedFuture(null), TestingUtils.TIMEOUT, Collections.emptyMap(), (MessageHeaders)TaskManagerLogsHeaders.getInstance(), () -> CompletableFuture.completedFuture(this.resourceManagerGateway));
        this.handlerRequest = TaskManagerLogListHandlerTest.createRequest(EXPECTED_TASK_MANAGER_ID);
    }

    @Test
    public void testGetTaskManagerLogsList() throws Exception {
        List<LogInfo> logsList = Arrays.asList(new LogInfo("taskmanager.log", 1024L), new LogInfo("taskmanager.out", 1024L), new LogInfo("taskmanager-2.out", 1024L));
        this.resourceManagerGateway.setRequestTaskManagerLogListFunction(EXPECTED_TASK_MANAGER_ID -> CompletableFuture.completedFuture(logsList));
        LogListInfo logListInfo = (LogListInfo)this.taskManagerLogListHandler.handleRequest(this.handlerRequest, (ResourceManagerGateway)this.resourceManagerGateway).get();
        Assert.assertThat((Object)logListInfo.getLogInfos(), (Matcher)Matchers.hasSize((int)logsList.size()));
    }

    @Test
    public void testGetTaskManagerLogsListForUnknownTaskExecutorException() throws Exception {
        this.resourceManagerGateway.setRequestTaskManagerLogListFunction(EXPECTED_TASK_MANAGER_ID -> FutureUtils.completedExceptionally((Throwable)new UnknownTaskExecutorException(EXPECTED_TASK_MANAGER_ID)));
        try {
            this.taskManagerLogListHandler.handleRequest(this.handlerRequest, (ResourceManagerGateway)this.resourceManagerGateway).get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Assert.assertThat((Object)cause, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(RestHandlerException.class)));
            RestHandlerException restHandlerException = (RestHandlerException)cause;
            Assert.assertThat((Object)restHandlerException.getHttpResponseStatus(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)HttpResponseStatus.NOT_FOUND)));
            Assert.assertThat((Object)restHandlerException.getMessage(), (Matcher)Matchers.containsString((String)("Could not find TaskExecutor " + TaskManagerLogListHandlerTest.EXPECTED_TASK_MANAGER_ID)));
        }
    }

    private static HandlerRequest<EmptyRequestBody, TaskManagerMessageParameters> createRequest(ResourceID taskManagerId) throws HandlerRequestException {
        HashMap<String, String> pathParameters = new HashMap<String, String>();
        pathParameters.put("taskmanagerid", taskManagerId.toString());
        Map queryParameters = Collections.emptyMap();
        return new HandlerRequest((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new TaskManagerMessageParameters(), pathParameters, queryParameters);
    }
}

