/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import org.apache.flink.runtime.rest.messages.ConversionException;
import org.apache.flink.runtime.rest.messages.SubtaskIndexPathParameter;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SubtaskIndexPathParameterTest {
    private SubtaskIndexPathParameter subtaskIndexPathParameter;

    @Before
    public void setUp() {
        this.subtaskIndexPathParameter = new SubtaskIndexPathParameter();
    }

    @Test
    public void testConversionFromString() throws Exception {
        Assert.assertThat((Object)this.subtaskIndexPathParameter.convertFromString("2147483647"), (Matcher)Matchers.equalTo((Object)Integer.MAX_VALUE));
    }

    @Test
    public void testConversionFromStringNegativeNumber() throws Exception {
        try {
            this.subtaskIndexPathParameter.convertFromString("-2147483648");
            Assert.fail((String)"Expected exception not thrown");
        }
        catch (ConversionException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"subtaskindex must be positive, was: -2147483648"));
        }
    }

    @Test
    public void testConvertToString() throws Exception {
        Assert.assertThat((Object)this.subtaskIndexPathParameter.convertToString(Integer.valueOf(Integer.MAX_VALUE)), (Matcher)Matchers.equalTo((Object)"2147483647"));
    }

    @Test
    public void testIsMandatoryParameter() {
        Assert.assertTrue((boolean)this.subtaskIndexPathParameter.isMandatory());
    }
}

