/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import javax.annotation.Nullable;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.instance.SimpleSlotContext;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;

public class TestingPhysicalSlot
extends SimpleSlotContext
implements PhysicalSlot {
    @Nullable
    private PhysicalSlot.Payload payload;

    TestingPhysicalSlot(ResourceProfile resourceProfile, AllocationID allocationId) {
        this(allocationId, (TaskManagerLocation)new LocalTaskManagerLocation(), new SimpleAckingTaskManagerGateway(), resourceProfile);
    }

    TestingPhysicalSlot(AllocationID allocationID, TaskManagerLocation taskManagerLocation, TaskManagerGateway taskManagerGateway, ResourceProfile resourceProfile) {
        this(allocationID, taskManagerLocation, 0, taskManagerGateway, resourceProfile);
    }

    TestingPhysicalSlot(AllocationID allocationId, TaskManagerLocation taskManagerLocation, int physicalSlotNumber, TaskManagerGateway taskManagerGateway, ResourceProfile resourceProfile) {
        super(allocationId, taskManagerLocation, physicalSlotNumber, taskManagerGateway, resourceProfile);
    }

    public boolean tryAssignPayload(PhysicalSlot.Payload payload) {
        if (this.payload != null) {
            return false;
        }
        this.payload = payload;
        return true;
    }

    @Nullable
    public PhysicalSlot.Payload getPayload() {
        return this.payload;
    }

    public void releasePayload(Throwable cause) {
        if (this.payload != null) {
            this.payload.release(cause);
            this.payload = null;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private AllocationID allocationID = new AllocationID();
        private TaskManagerLocation taskManagerLocation = new LocalTaskManagerLocation();
        private int physicalSlotNumber = 0;
        private TaskManagerGateway taskManagerGateway = new SimpleAckingTaskManagerGateway();
        private ResourceProfile resourceProfile = ResourceProfile.ANY;

        private Builder() {
        }

        public Builder withAllocationID(AllocationID allocationID) {
            this.allocationID = allocationID;
            return this;
        }

        public Builder withTaskManagerLocation(TaskManagerLocation taskManagerLocation) {
            this.taskManagerLocation = taskManagerLocation;
            return this;
        }

        public Builder withPhysicalSlotNumber(int physicalSlotNumber) {
            this.physicalSlotNumber = physicalSlotNumber;
            return this;
        }

        public Builder withTaskManagerGateway(TaskManagerGateway taskManagerGateway) {
            this.taskManagerGateway = taskManagerGateway;
            return this;
        }

        public Builder withResourceProfile(ResourceProfile resourceProfile) {
            this.resourceProfile = resourceProfile;
            return this;
        }

        public TestingPhysicalSlot build() {
            return new TestingPhysicalSlot(this.allocationID, this.taskManagerLocation, this.physicalSlotNumber, this.taskManagerGateway, this.resourceProfile);
        }
    }
}

