/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.messages.ThreadInfoSample;
import org.apache.flink.runtime.taskexecutor.SampleableTask;
import org.apache.flink.runtime.taskexecutor.ThreadInfoSampleService;
import org.apache.flink.runtime.webmonitor.threadinfo.ThreadInfoSamplesRequest;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ThreadInfoSampleServiceTest
extends TestLogger {
    private static final int NUMBER_OF_SAMPLES = 10;
    private static final Duration DELAY_BETWEEN_SAMPLES = Duration.ofMillis(10L);
    private static final int MAX_STACK_TRACK_DEPTH = 10;
    private static final ThreadInfoSamplesRequest requestParams = new ThreadInfoSamplesRequest(1, 10, DELAY_BETWEEN_SAMPLES, 10);
    @ClassRule
    public static final TemporaryFolder TEMPORARY_FOLDER = new TemporaryFolder();
    private ThreadInfoSampleService threadInfoSampleService;

    @Before
    public void setUp() throws Exception {
        this.threadInfoSampleService = new ThreadInfoSampleService(Executors.newSingleThreadScheduledExecutor());
    }

    @After
    public void tearDown() throws Exception {
        if (this.threadInfoSampleService != null) {
            this.threadInfoSampleService.close();
        }
    }

    @Test(timeout=10000L)
    public void testSampleTaskThreadInfo() throws Exception {
        List threadInfoSamples = (List)this.threadInfoSampleService.requestThreadInfoSamples((SampleableTask)new TestTask(), requestParams).get();
        Assert.assertThat((Object)threadInfoSamples, (Matcher)Matchers.hasSize((int)10));
        for (ThreadInfoSample sample : threadInfoSamples) {
            StackTraceElement[] traces = sample.getStackTrace();
            Assert.assertTrue((sample.getStackTrace().length <= 10 ? 1 : 0) != 0);
            Assert.assertThat((Object)traces, (Matcher)Matchers.is((Matcher)Matchers.arrayWithSize((Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(10)))));
        }
    }

    @Test(timeout=10000L)
    public void testTruncateStackTraceIfLimitIsSpecified() throws Exception {
        List threadInfoSamples1 = (List)this.threadInfoSampleService.requestThreadInfoSamples((SampleableTask)new TestTask(), requestParams).get();
        List threadInfoSamples2 = (List)this.threadInfoSampleService.requestThreadInfoSamples((SampleableTask)new TestTask(), new ThreadInfoSamplesRequest(1, 10, DELAY_BETWEEN_SAMPLES, 5)).get();
        for (ThreadInfoSample sample : threadInfoSamples1) {
            Assert.assertThat((Object)sample.getStackTrace(), (Matcher)Matchers.is((Matcher)Matchers.arrayWithSize((Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(10)))));
            Assert.assertTrue((sample.getStackTrace().length <= 10 ? 1 : 0) != 0);
        }
        for (ThreadInfoSample sample : threadInfoSamples2) {
            Assert.assertThat((Object)sample.getStackTrace(), (Matcher)Matchers.is((Matcher)Matchers.arrayWithSize((int)5)));
        }
    }

    @Test
    public void testThrowExceptionIfNumSamplesIsNegative() {
        try {
            this.threadInfoSampleService.requestThreadInfoSamples((SampleableTask)new TestTask(), new ThreadInfoSamplesRequest(1, -1, DELAY_BETWEEN_SAMPLES, 10));
            Assert.fail((String)"Expected exception not thrown");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"numSamples must be positive")));
        }
    }

    @Test
    public void testShouldThrowExceptionIfTaskIsNotRunningBeforeSampling() {
        CompletableFuture sampleFuture = this.threadInfoSampleService.requestThreadInfoSamples((SampleableTask)new NotRunningTask(), requestParams);
        Assert.assertThat((Object)sampleFuture, (Matcher)FlinkMatchers.futureWillCompleteExceptionally(IllegalStateException.class, (Duration)Duration.ofSeconds(10L)));
    }

    private static class NotRunningTask
    extends TestTask {
        private NotRunningTask() {
        }

        @Override
        public Thread getExecutingThread() {
            return new Thread();
        }

        @Override
        public ExecutionAttemptID getExecutionId() {
            return null;
        }
    }

    private static class TestTask
    implements SampleableTask {
        private final ExecutionAttemptID executionAttemptID = new ExecutionAttemptID();

        private TestTask() {
        }

        public Thread getExecutingThread() {
            return Thread.currentThread();
        }

        public ExecutionAttemptID getExecutionId() {
            return this.executionAttemptID;
        }
    }
}

