/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.slot;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlot;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotPayload;
import org.apache.flink.runtime.taskexecutor.slot.TestingTaskSlotPayload;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.Executors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TaskSlotTest
extends TestLogger {
    private static final JobID JOB_ID = new JobID();
    private static final AllocationID ALLOCATION_ID = new AllocationID();

    @Test
    public void testTaskSlotClosedOnlyWhenAddedTasksTerminated() throws Exception {
        try (TaskSlot taskSlot = TaskSlotTest.createTaskSlot();){
            taskSlot.markActive();
            TestingTaskSlotPayload task = new TestingTaskSlotPayload(JOB_ID, new ExecutionAttemptID(), ALLOCATION_ID);
            taskSlot.add((TaskSlotPayload)task);
            CompletableFuture closingFuture = taskSlot.closeAsync();
            task.waitForFailure();
            MemoryManager memoryManager = taskSlot.getMemoryManager();
            Assert.assertThat((Object)closingFuture.isDone(), (Matcher)CoreMatchers.is((Object)false));
            Assert.assertThat((Object)memoryManager.isShutdown(), (Matcher)CoreMatchers.is((Object)false));
            task.terminate();
            closingFuture.get();
            Assert.assertThat((Object)memoryManager.isShutdown(), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    private static <T extends TaskSlotPayload> TaskSlot<T> createTaskSlot() {
        return new TaskSlot(0, ResourceProfile.ZERO, 4096, JOB_ID, ALLOCATION_ID, (Executor)Executors.newDirectExecutorService());
    }
}

