/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import java.time.Duration;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.StateBackendOptions;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperTestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperTestUtils.class);

    public static Configuration createZooKeeperHAConfig(String zooKeeperQuorum, String fsStateHandlePath) {
        return ZooKeeperTestUtils.configureZooKeeperHA(new Configuration(), zooKeeperQuorum, fsStateHandlePath);
    }

    public static Configuration configureZooKeeperHA(Configuration config, String zooKeeperQuorum, String fsStateHandlePath) {
        Preconditions.checkNotNull((Object)config, (String)"Configuration");
        Preconditions.checkNotNull((Object)zooKeeperQuorum, (String)"ZooKeeper quorum");
        Preconditions.checkNotNull((Object)fsStateHandlePath, (String)"File state handle backend path");
        config.setString(HighAvailabilityOptions.HA_MODE, "ZOOKEEPER");
        config.setString(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, zooKeeperQuorum);
        int connTimeout = 5000;
        if (ZooKeeperTestUtils.runsOnCIInfrastructure()) {
            LOG.info("Detected CI environment: Configuring connection and session timeout of 30 seconds");
            connTimeout = 30000;
        }
        config.setInteger(HighAvailabilityOptions.ZOOKEEPER_CONNECTION_TIMEOUT, connTimeout);
        config.setInteger(HighAvailabilityOptions.ZOOKEEPER_SESSION_TIMEOUT, connTimeout);
        config.setString(StateBackendOptions.STATE_BACKEND, "FILESYSTEM");
        config.setString(CheckpointingOptions.CHECKPOINTS_DIRECTORY, fsStateHandlePath + "/checkpoints");
        config.setString(HighAvailabilityOptions.HA_STORAGE_PATH, fsStateHandlePath + "/recovery");
        config.set(AkkaOptions.ASK_TIMEOUT_DURATION, (Object)Duration.ofSeconds(100L));
        return config;
    }

    public static boolean runsOnCIInfrastructure() {
        return System.getenv().containsKey("CI") || System.getenv().containsKey("TF_BUILD");
    }
}

