/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.writer;

import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.io.network.api.writer.BroadcastRecordWriter;
import org.apache.flink.runtime.io.network.api.writer.ChannelSelector;
import org.apache.flink.runtime.io.network.api.writer.ChannelSelectorRecordWriter;
import org.apache.flink.runtime.io.network.api.writer.RecordWriter;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.api.writer.RoundRobinChannelSelector;

public class RecordWriterBuilder<T extends IOReadableWritable> {
    private ChannelSelector<T> selector = new RoundRobinChannelSelector();
    private long timeout = -1L;
    private String taskName = "test";

    public RecordWriterBuilder<T> setChannelSelector(ChannelSelector<T> selector) {
        this.selector = selector;
        return this;
    }

    public RecordWriterBuilder<T> setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public RecordWriterBuilder<T> setTaskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    public RecordWriter<T> build(ResultPartitionWriter writer) {
        if (this.selector.isBroadcast()) {
            return new BroadcastRecordWriter(writer, this.timeout, this.taskName);
        }
        return new ChannelSelectorRecordWriter<T>(writer, this.selector, this.timeout, this.taskName);
    }
}

