/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.apache.flink.runtime.io.network.partition.BufferReaderWriterUtil;
import org.apache.flink.runtime.io.network.partition.hybrid.HsFileDataIndexImpl;

public class InternalRegionWriteReadUtils {
    public static ByteBuffer allocateAndConfigureBuffer(int bufferSize) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(bufferSize);
        buffer.order(ByteOrder.nativeOrder());
        return buffer;
    }

    public static void writeRegionToFile(FileChannel channel, ByteBuffer headerBuffer, HsFileDataIndexImpl.InternalRegion region) throws IOException {
        boolean[] released;
        headerBuffer.clear();
        headerBuffer.putInt(region.getFirstBufferIndex());
        headerBuffer.putInt(region.getNumBuffers());
        headerBuffer.putLong(region.getFirstBufferOffset());
        headerBuffer.flip();
        ByteBuffer payloadBuffer = InternalRegionWriteReadUtils.allocateAndConfigureBuffer(region.getNumBuffers());
        for (boolean b : released = region.getReleased()) {
            payloadBuffer.put(b ? (byte)1 : 0);
        }
        payloadBuffer.flip();
        BufferReaderWriterUtil.writeBuffers(channel, headerBuffer.capacity() + payloadBuffer.capacity(), headerBuffer, payloadBuffer);
    }

    public static HsFileDataIndexImpl.InternalRegion readRegionFromFile(FileChannel channel, ByteBuffer headerBuffer, long position) throws IOException {
        headerBuffer.clear();
        BufferReaderWriterUtil.readByteBufferFully(channel, headerBuffer, position);
        headerBuffer.flip();
        int firstBufferIndex = headerBuffer.getInt();
        int numBuffers = headerBuffer.getInt();
        long firstBufferOffset = headerBuffer.getLong();
        ByteBuffer payloadBuffer = InternalRegionWriteReadUtils.allocateAndConfigureBuffer(numBuffers);
        BufferReaderWriterUtil.readByteBufferFully(channel, payloadBuffer, position + 16L);
        boolean[] released = new boolean[numBuffers];
        payloadBuffer.flip();
        for (int i = 0; i < numBuffers; ++i) {
            released[i] = payloadBuffer.get() != 0;
        }
        return new HsFileDataIndexImpl.InternalRegion(firstBufferIndex, firstBufferOffset, numBuffers, released);
    }
}

