/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.testutils.org.jboss.netty.handler.codec.http;

import org.apache.flink.shaded.testutils.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.flink.shaded.testutils.org.jboss.netty.buffer.ChannelBuffers;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.ChannelStateEvent;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.Channels;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.LifeCycleAwareChannelHandler;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.MessageEvent;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.apache.flink.shaded.testutils.org.jboss.netty.handler.codec.embedder.DecoderEmbedder;
import org.apache.flink.shaded.testutils.org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.apache.flink.shaded.testutils.org.jboss.netty.handler.codec.http.HttpChunk;
import org.apache.flink.shaded.testutils.org.jboss.netty.handler.codec.http.HttpMessage;
import org.apache.flink.shaded.testutils.org.jboss.netty.handler.codec.http.HttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpContentDecoder
extends SimpleChannelUpstreamHandler
implements LifeCycleAwareChannelHandler {
    private DecoderEmbedder<ChannelBuffer> decoder;

    protected HttpContentDecoder() {
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object msg = e.getMessage();
        if (msg instanceof HttpResponse && ((HttpResponse)msg).getStatus().getCode() == 100) {
            ctx.sendUpstream(e);
        } else if (msg instanceof HttpMessage) {
            boolean hasContent;
            HttpMessage m = (HttpMessage)msg;
            this.finishDecode();
            String contentEncoding = m.headers().get("Content-Encoding");
            contentEncoding = contentEncoding != null ? contentEncoding.trim() : "identity";
            boolean bl = hasContent = m.isChunked() || m.getContent().readable();
            if (hasContent && (this.decoder = this.newContentDecoder(contentEncoding)) != null) {
                String targetContentEncoding = this.getTargetContentEncoding(contentEncoding);
                if ("identity".equals(targetContentEncoding)) {
                    m.headers().remove("Content-Encoding");
                } else {
                    m.headers().set("Content-Encoding", targetContentEncoding);
                }
                if (!m.isChunked()) {
                    ChannelBuffer content = m.getContent();
                    content = ChannelBuffers.wrappedBuffer(this.decode(content), this.finishDecode());
                    m.setContent(content);
                    if (m.headers().contains("Content-Length")) {
                        m.headers().set("Content-Length", Integer.toString(content.readableBytes()));
                    }
                }
            }
            ctx.sendUpstream(e);
        } else if (msg instanceof HttpChunk) {
            HttpChunk c = (HttpChunk)msg;
            ChannelBuffer content = c.getContent();
            if (this.decoder != null) {
                if (!c.isLast()) {
                    if ((content = this.decode(content)).readable()) {
                        c.setContent(content);
                        ctx.sendUpstream(e);
                    }
                } else {
                    ChannelBuffer lastProduct = this.finishDecode();
                    if (lastProduct.readable()) {
                        Channels.fireMessageReceived(ctx, (Object)new DefaultHttpChunk(lastProduct), e.getRemoteAddress());
                    }
                    ctx.sendUpstream(e);
                }
            } else {
                ctx.sendUpstream(e);
            }
        } else {
            ctx.sendUpstream(e);
        }
    }

    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.finishDecode();
        super.channelClosed(ctx, e);
    }

    protected abstract DecoderEmbedder<ChannelBuffer> newContentDecoder(String var1) throws Exception;

    protected String getTargetContentEncoding(String contentEncoding) throws Exception {
        return "identity";
    }

    private ChannelBuffer decode(ChannelBuffer buf) {
        this.decoder.offer(buf);
        return ChannelBuffers.wrappedBuffer(this.decoder.pollAll(new ChannelBuffer[this.decoder.size()]));
    }

    private ChannelBuffer finishDecode() {
        if (this.decoder == null) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        ChannelBuffer result = this.decoder.finish() ? ChannelBuffers.wrappedBuffer(this.decoder.pollAll(new ChannelBuffer[this.decoder.size()])) : ChannelBuffers.EMPTY_BUFFER;
        this.decoder = null;
        return result;
    }

    @Override
    public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public void afterAdd(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public void beforeRemove(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public void afterRemove(ChannelHandlerContext ctx) throws Exception {
        this.finishDecode();
    }
}

