/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.cq.internal.ops;

import java.util.LinkedList;
import java.util.List;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.Op;
import org.apache.geode.cache.query.cq.internal.ops.CreateCQOp;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;

public class GetDurableCQsOp {
    public static List<String> execute(ExecutablePool pool) {
        GetDurableCQsOpImpl op = new GetDurableCQsOpImpl();
        return (List)pool.executeOnPrimary((Op)op);
    }

    private GetDurableCQsOp() {
    }

    private static class GetDurableCQsOpImpl
    extends CreateCQOp.CreateCQOpImpl {
        public GetDurableCQsOpImpl() {
            super(105, 1);
        }

        @Override
        protected String getOpName() {
            return "getDurableCQs";
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startGetDurableCQs();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endGetDurableCQsSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endGetDurableCQs(start, this.hasTimedOut(), this.hasFailed());
        }

        @Override
        protected Message createResponseMessage() {
            return new ChunkedMessage(1, Version.CURRENT);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            ChunkedMessage getDurableCQsResponseMsg = (ChunkedMessage)msg;
            LinkedList result = new LinkedList();
            Exception[] exceptionRef = new Exception[1];
            getDurableCQsResponseMsg.readHeader();
            int msgType = getDurableCQsResponseMsg.getMessageType();
            if (msgType == 1) {
                do {
                    getDurableCQsResponseMsg.receiveChunk();
                    Part part = getDurableCQsResponseMsg.getPart(0);
                    Object o = part.getObject();
                    if (o instanceof Throwable) {
                        String s = "While performing a remote GetDurableCQs";
                        exceptionRef[0] = new ServerOperationException(s, (Throwable)o);
                        continue;
                    }
                    result.addAll((List)o);
                } while (!getDurableCQsResponseMsg.isLastChunk());
            } else {
                if (msgType == 2) {
                    getDurableCQsResponseMsg.receiveChunk();
                    Part part = msg.getPart(0);
                    String s = "While performing a remote GetDurableCQs";
                    throw new ServerOperationException(s, (Throwable)part.getObject());
                }
                if (this.isErrorResponse(msgType)) {
                    getDurableCQsResponseMsg.receiveChunk();
                    Part part = msg.getPart(0);
                    throw new ServerOperationException(part.getString());
                }
                throw new InternalGemFireError("Unexpected message type " + MessageType.getString((int)msgType));
            }
            if (exceptionRef[0] != null) {
                throw exceptionRef[0];
            }
            return result;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 106;
        }
    }
}

