/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import org.apache.geode.management.api.Status;

public class ClusterManagementResult {
    private Map<String, Status> memberStatuses = new HashMap<String, Status>();
    private StatusCode statusCode = StatusCode.OK;
    private String statusMessage;

    public ClusterManagementResult() {
    }

    public ClusterManagementResult(boolean success, String message) {
        this.setStatus(success, message);
    }

    public ClusterManagementResult(StatusCode statusCode, String message) {
        this.statusCode = statusCode;
        this.statusMessage = message;
    }

    public void addMemberStatus(String member, boolean success, String message) {
        this.memberStatuses.put(member, new Status(success, message));
        if (!success) {
            this.statusCode = StatusCode.ERROR;
        }
    }

    public void setStatus(boolean success, String message) {
        if (!success) {
            this.statusCode = StatusCode.ERROR;
        }
        this.statusMessage = message;
    }

    public void setStatus(StatusCode code, String message) {
        this.statusCode = code;
        this.statusMessage = message;
    }

    public Map<String, Status> getMemberStatuses() {
        return this.memberStatuses;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    @JsonIgnore
    public boolean isSuccessful() {
        return this.statusCode == StatusCode.OK;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public static enum StatusCode {
        ILLEGAL_ARGUMENT,
        UNAUTHENTICATED,
        UNAUTHORIZED,
        ENTITY_EXISTS,
        ENTITY_NOT_FOUND,
        ERROR,
        FAIL_TO_PERSIST,
        OK;

    }
}

